/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.changes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.util.collections.BucketMap;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.refactoring.core.changes.Messages;

public class RenameBreackpointChange
extends Change {
    private IPath fDest;
    private IPath fSource;
    private String fName;
    private String fNewName;
    private BucketMap<IResource, IBreakpoint> fBreakpoints;
    private Map<IBreakpoint, Map<String, Object>> fBreakpointAttributes;

    public RenameBreackpointChange(IPath source, IPath dest, String resName, String newName, BucketMap<IResource, IBreakpoint> breakpoints, Map<IBreakpoint, Map<String, Object>> breakpointAttributes) {
        this.fSource = source;
        this.fDest = dest;
        this.fName = resName;
        this.fNewName = newName;
        this.fBreakpoints = breakpoints;
        this.fBreakpointAttributes = breakpointAttributes;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return NLS.bind((String)Messages.RenameBreackpointChange_0, (Object)this.fName);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.fBreakpoints == null || this.fBreakpointAttributes == null) {
            return new RenameBreackpointChange(this.fDest, this.fSource, this.fNewName, this.fName, null, null);
        }
        final IPath dest = this.fDest.append(this.fNewName);
        final IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        for (IResource markerResource : this.fBreakpoints.getKeys()) {
            Set breakPoints = this.fBreakpoints.get((Object)markerResource);
            final Path newPath = new Path(markerResource.getFullPath().toString().replaceFirst(this.fSource.append(this.fName).toString(), dest.toString()));
            final IResource newMarkerResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)newPath);
            for (final IBreakpoint breakpoint : breakPoints) {
                final Map<String, Object> oldAttributesMap = this.fBreakpointAttributes.get(breakpoint);
                IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IMarker newMarker = newMarkerResource.createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                        HashMap<String, Object> newAttributesMap = new HashMap<String, Object>();
                        String oldMessge = (String)oldAttributesMap.get("message");
                        if (oldMessge != null) {
                            newAttributesMap.put("message", oldMessge.replaceFirst(RenameBreackpointChange.this.fName, dest.lastSegment()));
                        }
                        newAttributesMap.put("location", newPath.toPortableString());
                        newAttributesMap.put("lineNumber", oldAttributesMap.get("lineNumber"));
                        newAttributesMap.put("org.eclipse.debug.core.enabled", oldAttributesMap.get("org.eclipse.debug.core.enabled"));
                        newAttributesMap.put("org.eclipse.debug.core.persisted", false);
                        newAttributesMap.put("org.eclipse.debug.core.id", oldAttributesMap.get("org.eclipse.debug.core.id"));
                        newMarker.setAttributes(newAttributesMap);
                        PHPLineBreakpoint newBreakPoint = RenameBreackpointChange.this.createBreakPoint(breakpoint);
                        newBreakPoint.setMarker(newMarker);
                        newBreakPoint.setPersisted(breakpoint.isPersisted());
                        breakpointManager.addBreakpoint((IBreakpoint)newBreakPoint);
                        breakpoint.delete();
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(wr, this.getMarkerRule(newMarkerResource), 0, null);
                }
                catch (CoreException e) {
                    throw new DebugException(e.getStatus());
                }
            }
        }
        return new RenameBreackpointChange(this.fDest, this.fSource, this.fNewName, this.fName, null, null);
    }

    protected PHPLineBreakpoint createBreakPoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof PHPConditionalBreakpoint) {
            return new PHPConditionalBreakpoint();
        }
        return new PHPLineBreakpoint();
    }

    protected ISchedulingRule getMarkerRule(IResource resource) {
        ISchedulingRule rule = null;
        if (resource != null) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rule = ruleFactory.markerRule(resource);
        }
        return rule;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fSource.append(this.fName));
    }
}

