/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;
import org.eclipse.php.refactoring.ui.actions.RenamePHPElementActionDelegateProxy;

public class RenamePHPElementActionDelegateTest
extends TestCase {
    private IProject project1;

    protected void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"project1");
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        folder = TestUtils.createFolder((IProject)this.project1, (String)"src2");
        folder = TestUtils.createFolder((IProject)this.project1, (String)"src/src1");
        TestUtils.createFile((IFolder)folder, (String)"test1.php", (String)"<?php class TestRenameClass{}?>");
        TestUtils.waitForIndexer();
    }

    public void testGetSourceOffsetAndGetNode() {
        IFile file = this.project1.getFile("src/src1/test1.php");
        IModelElement source = null;
        try {
            source = DLTKCore.create((IFile)file);
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertNotNull((Object)source);
        final ArrayList type = new ArrayList();
        try {
            source.accept(new IModelElementVisitor(){

                public boolean visit(IModelElement element) {
                    if (element.getElementType() == 7) {
                        type.add((IType)element);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (ModelException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertTrue((type.size() > 0 ? 1 : 0) != 0);
        RenamePHPElementActionDelegateProxy action = new RenamePHPElementActionDelegateProxy();
        int offset = -1;
        try {
            offset = action.getSourceOffset((IModelElement)type.get(0));
        }
        catch (ModelException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertTrue((offset >= 0 ? 1 : 0) != 0);
        try {
            Program program = RefactoringUtility.getProgramForFile((IFile)file);
            ASTNode node = action.getSelectedNode(program, offset, 0);
            RenamePHPElementActionDelegateTest.assertTrue((boolean)(node instanceof ClassDeclaration));
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
    }

    public void testGetSourceOffsetAndGetNode1() {
        IFile file = this.project1.getFile("test1.php");
        ByteArrayInputStream sourceStream = new ByteArrayInputStream("<?php function foo(){};?>".getBytes());
        try {
            if (!file.exists()) {
                file.create((InputStream)sourceStream, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.setContents((InputStream)sourceStream, 1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        IModelElement source = null;
        try {
            source = DLTKCore.create((IFile)file);
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertNotNull((Object)source);
        final ArrayList methods = new ArrayList();
        try {
            source.accept(new IModelElementVisitor(){

                public boolean visit(IModelElement element) {
                    if (element.getElementType() == 9) {
                        methods.add((IMethod)element);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (ModelException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertTrue((methods.size() > 0 ? 1 : 0) != 0);
        RenamePHPElementActionDelegateProxy action = new RenamePHPElementActionDelegateProxy();
        int offset = -1;
        try {
            offset = action.getSourceOffset((IModelElement)methods.get(0));
        }
        catch (ModelException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertTrue((offset >= 0 ? 1 : 0) != 0);
        try {
            Program program = RefactoringUtility.getProgramForFile((IFile)file);
            ASTNode node = action.getSelectedNode(program, offset, 0);
            RenamePHPElementActionDelegateTest.assertTrue((boolean)(node instanceof FunctionDeclaration));
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
    }

    public void testGetSourceOffsetAndGetNode2() {
        IFile file = this.project1.getFile("test2.php");
        ByteArrayInputStream sourceStream = new ByteArrayInputStream("<?php class MyClass { function myfunc1(){ return(true);}}?>".getBytes());
        try {
            if (!file.exists()) {
                file.create((InputStream)sourceStream, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.setContents((InputStream)sourceStream, 1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        IModelElement source = null;
        try {
            source = DLTKCore.create((IFile)file);
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertNotNull((Object)source);
        try {
            ((ISourceModule)source).makeConsistent((IProgressMonitor)new NullProgressMonitor());
        }
        catch (ModelException e1) {
            RenamePHPElementActionDelegateTest.fail((String)e1.getMessage());
        }
        final ArrayList methods = new ArrayList();
        try {
            source.accept(new IModelElementVisitor(){

                public boolean visit(IModelElement element) {
                    if (element.getElementType() == 9) {
                        methods.add((IMethod)element);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (ModelException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertTrue((methods.size() > 0 ? 1 : 0) != 0);
        RenamePHPElementActionDelegateProxy action = new RenamePHPElementActionDelegateProxy();
        int offset = -1;
        try {
            offset = action.getSourceOffset((IModelElement)methods.get(0));
        }
        catch (ModelException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertTrue((offset >= 0 ? 1 : 0) != 0);
        try {
            Program program = RefactoringUtility.getProgramForFile((IFile)file);
            ASTNode node = action.getSelectedNode(program, offset, 0);
            RenamePHPElementActionDelegateTest.assertTrue((boolean)(node instanceof FunctionDeclaration));
            RenamePHPElementActionDelegateTest.assertTrue((boolean)(node.getParent() instanceof MethodDeclaration));
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
    }

    public void testGetSourceOffsetAndGetNode3() {
        IFile file = this.project1.getFile("test3.php");
        ByteArrayInputStream sourceStream = new ByteArrayInputStream("<?php class MyClss{public $a,$b;}?>".getBytes());
        try {
            if (!file.exists()) {
                file.create((InputStream)sourceStream, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.setContents((InputStream)sourceStream, 1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        IModelElement source = null;
        try {
            source = DLTKCore.create((IFile)file);
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertNotNull((Object)source);
        try {
            ((ISourceModule)source).makeConsistent((IProgressMonitor)new NullProgressMonitor());
        }
        catch (ModelException e1) {
            RenamePHPElementActionDelegateTest.fail((String)e1.getMessage());
        }
        final ArrayList methods = new ArrayList();
        try {
            source.accept(new IModelElementVisitor(){

                public boolean visit(IModelElement element) {
                    if (element.getElementType() == 8) {
                        methods.add((IField)element);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (ModelException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertTrue((methods.size() > 0 ? 1 : 0) != 0);
        RenamePHPElementActionDelegateProxy action = new RenamePHPElementActionDelegateProxy();
        int offset = -1;
        try {
            offset = action.getSourceOffset((IModelElement)methods.get(0));
        }
        catch (ModelException e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertTrue((offset >= 0 ? 1 : 0) != 0);
        try {
            Program program = RefactoringUtility.getProgramForFile((IFile)file);
            ASTNode node = action.getSelectedNode(program, offset, 0);
            RenamePHPElementActionDelegateTest.assertTrue((boolean)(node instanceof Variable));
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
    }

    public void testIsSourceReference() {
        IFile file = this.project1.getFile("src/src1/test1.php");
        IModelElement source = null;
        try {
            source = DLTKCore.create((IFile)file);
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertNotNull((Object)source);
        RenamePHPElementActionDelegateProxy action = new RenamePHPElementActionDelegateProxy();
        RenamePHPElementActionDelegateTest.assertTrue((boolean)action.isModelElement(source));
        RenamePHPElementActionDelegateTest.assertTrue((boolean)action.isSourceReference(source));
    }

    public void testIsScriptContainer() {
        RenamePHPElementActionDelegateProxy action = new RenamePHPElementActionDelegateProxy();
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project1.getProject());
        RenamePHPElementActionDelegateTest.assertTrue((boolean)action.isScriptContainer(scriptProject));
        Path fPath = new Path("/project1/src");
        IFolder folder = this.project1.getFolder((IPath)fPath);
        IProjectFragment element = scriptProject.getProjectFragment((IResource)folder);
        RenamePHPElementActionDelegateTest.assertTrue((boolean)action.isScriptContainer(element));
        fPath = new Path("/project1/src/src1");
        folder = this.project1.getFolder((IPath)fPath);
        element = DLTKCore.create((IResource)folder);
        RenamePHPElementActionDelegateTest.assertTrue((boolean)action.isScriptContainer(element));
        folder = this.project1.getFolder("src2");
        RenamePHPElementActionDelegateTest.assertFalse((boolean)action.isScriptContainer(folder));
        IFile file = this.project1.getFile("src/src1/test1.php");
        RenamePHPElementActionDelegateTest.assertFalse((boolean)action.isScriptContainer(folder));
        Program program = null;
        try {
            program = RefactoringUtility.getProgramForFile((IFile)file);
        }
        catch (Exception e) {
            RenamePHPElementActionDelegateTest.fail((String)e.getMessage());
        }
        RenamePHPElementActionDelegateTest.assertFalse((boolean)action.isScriptContainer(program));
    }

    protected void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

