/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views.coverage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.php.internal.debug.core.zend.communication.IRemoteFileContentRequestor;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageTextViewer;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageViewActionGroup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class CodeCoverageView
extends ViewPart {
    private CodeCoverageTextViewer fSourceViewer;
    private CodeCoverageData fCodeCoverageData;
    private CodeCoverageViewActionGroup fActionGroup;

    public void createPartControl(Composite parent) {
        this.fSourceViewer = new CodeCoverageTextViewer(parent, 0);
        this.fActionGroup = new CodeCoverageViewActionGroup(this);
        this.fActionGroup.fillActionBars(this.getViewSite().getActionBars());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.code_coverage_view");
    }

    public void setFocus() {
    }

    public void setInput(CodeCoverageData codeCoverageData) {
        if (this.fSourceViewer != null && this.fCodeCoverageData != codeCoverageData) {
            this.fCodeCoverageData = codeCoverageData;
            this.fSourceViewer.setCoverageBitmask(codeCoverageData.getCoverageBitmask());
            this.fSourceViewer.setSingificanceBitmask(codeCoverageData.getSignificanceBitmask());
            this.fSourceViewer.applyStyles();
            String fileName = codeCoverageData.getLocalFileName();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            InputStream inputStream = null;
            try {
                Path path = new Path(fileName);
                IFile file = root.getFile((IPath)path);
                if (file != null && file.exists()) {
                    inputStream = file.getContents();
                } else {
                    file = root.getFileForLocation((IPath)path);
                    if (file != null && file.exists()) {
                        inputStream = file.getContents();
                    }
                }
            }
            catch (Exception path) {
                // empty catch block
            }
            try {
                File localFile;
                if (inputStream == null && (localFile = new File(fileName)).exists()) {
                    inputStream = new FileInputStream(localFile);
                }
            }
            catch (IOException e) {
                DebugUIPlugin.log((Throwable)e);
            }
            if (inputStream != null) {
                try {
                    BufferedReader is = new BufferedReader(new InputStreamReader(inputStream));
                    StringBuilder fileContents = new StringBuilder();
                    String line = null;
                    while ((line = is.readLine()) != null) {
                        fileContents.append(line);
                        fileContents.append("\n");
                    }
                    this.fSourceViewer.setText(fileContents.toString());
                }
                catch (IOException e) {
                    DebugUIPlugin.log((Throwable)e);
                }
            } else {
                RemoteDebugger.requestRemoteFile((IRemoteFileContentRequestor)new IRemoteFileContentRequestor(){

                    public void fileContentReceived(final byte[] content, String serverAddress, String originalURL, String fileName, int lineNumber) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).CodeCoverageView.this.fSourceViewer != null && !(this).CodeCoverageView.this.fSourceViewer.isDisposed()) {
                                    (this).CodeCoverageView.this.fSourceViewer.setText(new String(content));
                                }
                            }
                        });
                    }

                    public void requestCompleted(Exception e) {
                    }
                }, (String)fileName, (int)1, (String)codeCoverageData.getURL());
            }
            this.setTitleToolTip(fileName);
            int idx = Math.max(fileName.lastIndexOf(92), fileName.lastIndexOf(47));
            String lastSegment = idx == -1 ? fileName : fileName.substring(idx + 1);
            this.setPartName(lastSegment);
        }
    }

    public CodeCoverageTextViewer getViewer() {
        return this.fSourceViewer;
    }
}

