/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.Collections;
import java.util.Map;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;

public abstract class AbstractDebuggerSettings
implements IDebuggerSettings {
    protected String ownerId;
    protected Map<String, String> attributes;

    public AbstractDebuggerSettings(String ownerId) {
        this.ownerId = ownerId;
        this.attributes = Collections.unmodifiableMap(this.createAttributes());
    }

    public AbstractDebuggerSettings(String ownerId, Map<String, String> attributes) {
        this.ownerId = ownerId;
        this.attributes = attributes;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    protected abstract Map<String, String> createAttributes();

    void update(IDebuggerSettingsWorkingCopy settingsWorkingCopy) {
        this.attributes = Collections.unmodifiableMap(settingsWorkingCopy.getAttributes());
    }
}

