/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.FixedAnswerEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;

public class ScalarEvaluator
extends FixedAnswerEvaluator {
    public ScalarEvaluator(IGoal goal, Scalar scalar) {
        super(goal, ScalarEvaluator.evaluateScalar(goal, scalar));
    }

    private static Object evaluateScalar(IGoal goal, Scalar scalar) {
        int scalarType = scalar.getScalarType();
        IEvaluatedType simpleType = PHPSimpleTypes.VOID;
        switch (scalarType) {
            case 0: 
            case 1: {
                simpleType = PHPSimpleTypes.NUMBER;
                break;
            }
            case 2: {
                IEvaluatedType resolved;
                String declaringTypeName;
                MethodDeclaration methodNode;
                IContext context;
                if ("null".equalsIgnoreCase(scalar.getValue())) {
                    simpleType = PHPSimpleTypes.NULL;
                    break;
                }
                if ("this".equalsIgnoreCase(scalar.getValue()) && (context = goal.getContext()) instanceof MethodContext && (methodNode = ((MethodContext)context).getMethodNode()) != null && (declaringTypeName = methodNode.getDeclaringTypeName()) != null && (resolved = PHPSimpleTypes.fromString(declaringTypeName)) == null) {
                    return new PHPClassType(declaringTypeName);
                }
            }
            case 4: {
                String value = scalar.getValue();
                simpleType = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) ? PHPSimpleTypes.BOOLEAN : PHPSimpleTypes.STRING;
            }
        }
        return simpleType;
    }
}

