/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AttributeGroup;
import org.eclipse.php.core.ast.nodes.BodyDeclaration;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class MethodDeclaration
extends BodyDeclaration {
    private FunctionDeclaration function;
    private Comment comment;
    public static final ChildPropertyDescriptor FUNCTION_PROPERTY = new ChildPropertyDescriptor(MethodDeclaration.class, "function", FunctionDeclaration.class, true, true);
    public static final SimplePropertyDescriptor MODIFIER_PROPERTY = new SimplePropertyDescriptor(MethodDeclaration.class, "modifier", Integer.class, false);
    public static final ChildPropertyDescriptor COMMENT_PROPERTY = new ChildPropertyDescriptor(Comment.class, "comment", Comment.class, false, false);
    public static final ChildListPropertyDescriptor ATTRIBUTES_PROPERTY = new ChildListPropertyDescriptor(MethodDeclaration.class, "attributes", AttributeGroup.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_PHP8;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(3);
        propertyList.add(FUNCTION_PROPERTY);
        propertyList.add(MODIFIER_PROPERTY);
        propertyList.add(COMMENT_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
        propertyList = new ArrayList(4);
        propertyList.add(FUNCTION_PROPERTY);
        propertyList.add(MODIFIER_PROPERTY);
        propertyList.add(COMMENT_PROPERTY);
        propertyList.add(ATTRIBUTES_PROPERTY);
        PROPERTY_DESCRIPTORS_PHP8 = Collections.unmodifiableList(propertyList);
    }

    @Override
    public final SimplePropertyDescriptor getModifierProperty() {
        return MODIFIER_PROPERTY;
    }

    @Override
    protected ChildListPropertyDescriptor getAttributesProperty() {
        return ATTRIBUTES_PROPERTY;
    }

    public MethodDeclaration(int start, int end, AST ast, int modifier, FunctionDeclaration function, boolean shouldComplete, List<AttributeGroup> attributes) {
        this(start, end, ast, modifier, function, shouldComplete);
        if (attributes != null) {
            this.attributes().addAll(attributes);
        }
    }

    public MethodDeclaration(int start, int end, AST ast, int modifier, FunctionDeclaration function, boolean shouldComplete) {
        super(start, end, ast, modifier, shouldComplete);
        if (function == null) {
            throw new IllegalArgumentException();
        }
        this.setFunction(function);
    }

    public MethodDeclaration(int start, int end, AST ast, int modifier, FunctionDeclaration function) {
        this(start, end, ast, modifier, function, false);
    }

    public MethodDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (AttributeGroup object : this.attributes()) {
            object.accept(visitor);
        }
        if (this.comment != null) {
            this.comment.accept(visitor);
        }
        this.function.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (AttributeGroup object : this.attributes()) {
            object.traverseTopDown(visitor);
        }
        if (this.comment != null) {
            this.comment.traverseTopDown(visitor);
        }
        this.function.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (AttributeGroup object : this.attributes()) {
            object.traverseBottomUp(visitor);
        }
        this.function.traverseBottomUp(visitor);
        if (this.comment != null) {
            this.comment.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<MethodDeclaration");
        this.appendInterval(buffer);
        buffer.append(" modifier='").append(this.getModifierString()).append("'>\n");
        this.toStringAttributes(buffer, "\t" + tab);
        this.function.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</MethodDeclaration>");
    }

    @Override
    public int getType() {
        return 42;
    }

    public FunctionDeclaration getFunction() {
        return this.function;
    }

    public void setFunction(FunctionDeclaration expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        FunctionDeclaration oldChild = this.function;
        this.preReplaceChild(oldChild, expression, FUNCTION_PROPERTY);
        this.function = expression;
        this.postReplaceChild(oldChild, expression, FUNCTION_PROPERTY);
    }

    public void setComment(Comment expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Comment oldChild = this.comment;
        this.preReplaceChild(oldChild, expression, COMMENT_PROPERTY);
        this.comment = expression;
        this.postReplaceChild(oldChild, expression, COMMENT_PROPERTY);
    }

    public Comment getComment() {
        return this.comment;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == FUNCTION_PROPERTY) {
            if (get) {
                return this.getFunction();
            }
            this.setFunction((FunctionDeclaration)child);
            return null;
        }
        if (property == COMMENT_PROPERTY) {
            if (get) {
                return this.getComment();
            }
            this.setComment((Comment)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        FunctionDeclaration function = ASTNode.copySubtree(target, this.getFunction());
        int modifier = this.getModifier();
        List<AttributeGroup> attributes = ASTNode.copySubtrees(target, this.attributes());
        MethodDeclaration result = new MethodDeclaration(this.getStart(), this.getEnd(), target, modifier, function, true, attributes);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        if (PHPVersion.PHP8_0.isGreaterThan(apiLevel)) {
            return PROPERTY_DESCRIPTORS;
        }
        return PROPERTY_DESCRIPTORS_PHP8;
    }

    public IMethodBinding resolveMethodBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }
}

