/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.rewrite;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.tests.dom_ast.rewrite.ASTRewriteTestsPHP56;
import org.eclipse.php.core.tests.dom_ast.rewrite.NodeDeletionTestsPHP7;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

public class ASTRewriteTestsPHP7
extends ASTRewriteTestsPHP56 {
    @Override
    protected PHPVersion getPHPVersion() {
        return PHPVersion.PHP7_0;
    }

    @Override
    @Test
    public void staticMemberWithArray() throws Exception {
        String str = "<?php MyClass::$$a[5];?>";
        this.initialize(str);
        List<ArrayAccess> arrayAccess = this.getAllOfType(this.program, ArrayAccess.class);
        Assert.assertTrue((String)"Unexpected list size.", (arrayAccess.size() == 1 ? 1 : 0) != 0);
        ((StaticFieldAccess)arrayAccess.get(0).getName()).setField((Variable)this.ast.newReflectionVariable((Expression)this.ast.newArrayAccess((VariableBase)this.ast.newVariable("bar"), (Expression)this.ast.newScalar("333"))));
        this.rewrite();
        this.checkResult("<?php MyClass::$$bar[333][5];?>");
    }

    @Test
    public void functionReturnTypeSet() throws Exception {
        String str = "<?php function test($tmp) {} \n ?>";
        this.initialize(str);
        List<FunctionDeclaration> statements = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Identifier identifier = this.ast.newIdentifier("MyClass");
        statements.get(0).setReturnType(identifier);
        this.rewrite();
        this.checkResult("<?php function test($tmp): MyClass {} \n ?>");
    }

    @Test
    public void functionReturnTypeUnset() throws Exception {
        String str = "<?php function test($tmp): MyClass {} \n ?>";
        this.initialize(str);
        List<FunctionDeclaration> statements = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setReturnType(null);
        this.rewrite();
        this.checkResult("<?php function test($tmp) {} \n ?>");
    }

    @Test
    public void methodReturnTypeSet() throws Exception {
        String str = "<?php class Test { public function test($tmp) {} }\n ?>";
        this.initialize(str);
        List<FunctionDeclaration> statements = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        Identifier identifier = this.ast.newIdentifier("MyClass");
        statements.get(0).setReturnType(identifier);
        this.rewrite();
        this.checkResult("<?php class Test { public function test($tmp): MyClass {} }\n ?>");
    }

    @Test
    public void methodReturnTypeUnset() throws Exception {
        String str = "<?php class Test { public function test($tmp): MyClass {} }\n ?>";
        this.initialize(str);
        List<FunctionDeclaration> statements = this.getAllOfType(this.program, FunctionDeclaration.class);
        Assert.assertTrue((String)"Unexpected list size.", (statements.size() == 1 ? 1 : 0) != 0);
        statements.get(0).setReturnType(null);
        this.rewrite();
        this.checkResult("<?php class Test { public function test($tmp) {} }\n ?>");
    }

    @Override
    @Ignore
    public void referenceInstanciation() throws Exception {
    }

    @RunWith(value=org.junit.runners.Suite.class)
    @Suite.SuiteClasses(value={ASTRewriteTestsPHP7.class, NodeDeletionTestsPHP7.class})
    public static class Suite {
    }
}

