/* The following code was generated by JFlex 1.6.1 */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php55;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import java_cup.sym;
import org.eclipse.php.internal.core.ast.nodes.AST;
import java_cup.runtime.Symbol;
import org.eclipse.php.internal.core.ast.scanner.StateStack;
import org.eclipse.php.internal.core.PHPVersion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>ast_scanner.flex</tt>
 */
public class PhpAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SCRIPTING = 2;
  public static final int ST_DOUBLE_QUOTES = 4;
  public static final int ST_SINGLE_QUOTE = 6;
  public static final int ST_BACKQUOTE = 8;
  public static final int ST_HEREDOC = 10;
  public static final int ST_NOWDOC = 12;
  public static final int ST_START_HEREDOC = 14;
  public static final int ST_START_NOWDOC = 16;
  public static final int ST_END_HEREDOC = 18;
  public static final int ST_LOOKING_FOR_PROPERTY = 20;
  public static final int ST_LOOKING_FOR_VARNAME = 22;
  public static final int ST_VAR_OFFSET = 24;
  public static final int ST_COMMENT = 26;
  public static final int ST_DOCBLOCK = 28;
  public static final int ST_ONE_LINE_COMMENT = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\14\1\13\2\0\1\15\22\0\1\14\1\60\1\17\1\101"+
    "\1\16\1\64\1\65\1\100\1\52\1\53\1\62\1\4\1\70\1\46"+
    "\1\2\1\63\1\5\1\11\10\1\1\50\1\23\1\61\1\57\1\47"+
    "\1\74\1\75\1\7\1\10\1\32\1\26\1\3\1\27\1\43\1\40"+
    "\1\24\1\54\1\42\1\37\1\45\1\31\1\33\1\44\1\56\1\35"+
    "\1\34\1\25\1\30\1\51\1\41\1\6\1\36\1\12\1\71\1\20"+
    "\1\72\1\67\1\55\1\21\1\7\1\10\1\32\1\26\1\3\1\27"+
    "\1\43\1\40\1\24\1\54\1\42\1\37\1\45\1\31\1\33\1\44"+
    "\1\56\1\35\1\77\1\25\1\30\1\51\1\41\1\6\1\36\1\12"+
    "\1\22\1\66\1\76\1\73\261\12\2\24\115\12\1\34\u1faa\12\1\42"+
    "\uded5\12\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\20\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\5\0\1\1\12\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\4\4\6\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\17\6\1\17\1\20\1\21\1\6\1\22"+
    "\1\23\1\6\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\44\1\45\1\1\1\3\1\46\2\3"+
    "\1\47\1\3\1\50\1\1\2\3\1\51\1\3\2\1"+
    "\5\3\2\52\2\53\1\54\1\55\1\56\1\55\1\57"+
    "\1\60\1\61\1\5\1\7\1\61\1\62\1\63\1\64"+
    "\1\65\1\17\1\20\1\21\1\22\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\66\1\41"+
    "\1\67\1\10\1\70\3\10\3\71\2\70\1\0\1\72"+
    "\1\73\1\2\1\74\1\0\1\75\6\6\1\76\1\77"+
    "\2\0\3\6\1\100\2\6\2\0\1\101\2\0\1\102"+
    "\2\0\1\103\7\6\1\104\12\6\1\105\12\6\1\106"+
    "\1\107\1\110\1\111\1\112\1\113\1\6\12\0\1\6"+
    "\1\114\1\115\2\116\1\117\1\120\1\0\1\121\1\122"+
    "\1\123\1\124\1\125\1\126\1\127\1\130\1\131\1\132"+
    "\1\133\4\0\1\101\2\134\1\135\1\136\1\134\1\0"+
    "\1\137\3\0\3\140\3\0\1\1\2\134\4\0\1\141"+
    "\2\0\1\142\1\0\1\143\1\144\2\0\1\145\1\146"+
    "\1\147\1\150\2\0\1\74\1\0\7\6\1\74\1\151"+
    "\1\152\1\6\1\153\2\6\1\0\6\6\1\154\3\6"+
    "\1\155\2\6\1\156\1\6\1\157\1\160\23\6\1\161"+
    "\1\162\12\0\7\6\1\163\1\164\1\165\3\0\1\166"+
    "\1\0\2\124\2\133\1\0\1\167\1\170\1\1\1\171"+
    "\1\0\2\144\2\0\6\6\1\172\1\173\1\6\1\174"+
    "\23\6\1\175\12\6\1\176\1\6\1\177\5\6\12\0"+
    "\10\6\4\0\1\200\4\0\1\6\1\201\5\6\1\202"+
    "\1\6\1\203\1\204\4\6\1\205\1\6\1\206\1\207"+
    "\3\6\1\210\2\6\1\211\1\6\1\212\2\6\1\213"+
    "\1\214\1\215\4\6\1\216\1\217\2\6\1\220\2\6"+
    "\5\0\1\221\6\0\10\6\2\222\4\0\1\223\2\224"+
    "\1\0\2\6\1\225\2\6\1\226\7\6\1\227\7\6"+
    "\1\230\1\231\1\232\1\6\1\233\1\234\2\6\4\0"+
    "\1\235\5\0\1\236\10\6\4\0\1\237\6\6\1\240"+
    "\3\6\1\241\1\242\1\243\1\6\1\244\3\6\1\245"+
    "\1\246\1\6\1\247\3\0\1\250\1\0\1\251\7\6"+
    "\3\0\3\6\1\252\1\253\5\6\1\254\1\6\1\255"+
    "\1\256\2\6\1\257\1\260\1\261\3\6\1\262\2\6"+
    "\4\0\2\6\1\263\1\264\1\6\1\265\2\6\1\266"+
    "\1\6\1\267\2\6\1\270\2\6\2\0\1\271\1\272"+
    "\1\6\1\273\1\274\4\6\1\275\4\0\5\6\2\0"+
    "\1\276\1\0\1\277\1\300\1\301\2\6\1\0\1\302"+
    "\1\6\1\0\1\6\1\0\1\303\14\0\1\73\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[709];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\102\0\204\0\306\0\u0108\0\u014a\0\u018c\0\u01ce"+
    "\0\u0210\0\u0252\0\u0294\0\u02d6\0\u0318\0\u035a\0\u039c\0\u03de"+
    "\0\u0420\0\u0462\0\u04a4\0\u04e6\0\u0528\0\u056a\0\u05ac\0\u05ee"+
    "\0\u0630\0\u0672\0\u06b4\0\u06f6\0\u0738\0\u077a\0\u07bc\0\u04a4"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u07fe\0\u0840\0\u0882\0\u08c4\0\u0906"+
    "\0\u0948\0\u098a\0\u09cc\0\u0a0e\0\u0a50\0\u0a92\0\u0ad4\0\u0b16"+
    "\0\u0b58\0\u0b9a\0\u0bdc\0\u0c1e\0\u0c60\0\u0ca2\0\u0ce4\0\u04a4"+
    "\0\u0d26\0\u0d68\0\u0daa\0\u0dec\0\u0e2e\0\u0e70\0\u0eb2\0\u0ef4"+
    "\0\u0f36\0\u0f78\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u0fba\0\u04a4"+
    "\0\u04a4\0\u0ffc\0\u04a4\0\u103e\0\u1080\0\u04a4\0\u10c2\0\u1104"+
    "\0\u1146\0\u1188\0\u04a4\0\u11ca\0\u120c\0\u124e\0\u04a4\0\u1290"+
    "\0\u12d2\0\u1314\0\u1356\0\u1398\0\u13da\0\u141c\0\u145e\0\u04a4"+
    "\0\u14a0\0\u04a4\0\u14e2\0\u04a4\0\u04a4\0\u1524\0\u1566\0\u04a4"+
    "\0\u15a8\0\u15ea\0\u04a4\0\u04a4\0\u162c\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u04a4\0\u166e\0\u16b0\0\u04a4\0\u16f2\0\u1734\0\u1776\0\u04a4"+
    "\0\u17b8\0\u04a4\0\u17fa\0\u183c\0\u187e\0\u18c0\0\u1902\0\u1944"+
    "\0\u1986\0\u04a4\0\u19c8\0\u1a0a\0\u1a4c\0\u1a8e\0\u1ad0\0\u1b12"+
    "\0\u04a4\0\u04a4\0\u1b54\0\u1b96\0\u1bd8\0\u1c1a\0\u1c5c\0\u06f6"+
    "\0\u1c9e\0\u1ce0\0\u1d22\0\u0ffc\0\u1d64\0\u07bc\0\u1da6\0\u04a4"+
    "\0\u1de8\0\u1e2a\0\u06f6\0\u1e6c\0\u1eae\0\u1ef0\0\u1f32\0\u1f74"+
    "\0\u1fb6\0\u1ff8\0\u06f6\0\u203a\0\u207c\0\u20be\0\u2100\0\u2142"+
    "\0\u2184\0\u21c6\0\u2208\0\u224a\0\u228c\0\u06f6\0\u22ce\0\u2310"+
    "\0\u2352\0\u2394\0\u23d6\0\u2418\0\u245a\0\u249c\0\u24de\0\u2520"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u2562\0\u04a4\0\u04a4\0\u25a4\0\u25e6"+
    "\0\u2628\0\u0ce4\0\u266a\0\u26ac\0\u26ee\0\u2730\0\u2772\0\u27b4"+
    "\0\u27f6\0\u2838\0\u04a4\0\u287a\0\u28bc\0\u04a4\0\u04a4\0\u28fe"+
    "\0\u2940\0\u04a4\0\u04a4\0\u2982\0\u29c4\0\u04a4\0\u04a4\0\u04a4"+
    "\0\u04a4\0\u04a4\0\u04a4\0\u2a06\0\u2a48\0\u2a8a\0\u10c2\0\u2acc"+
    "\0\u2b0e\0\u2a8a\0\u04a4\0\u04a4\0\u04a4\0\u2acc\0\u2b50\0\u04a4"+
    "\0\u2b92\0\u124e\0\u2bd4\0\u2b92\0\u04a4\0\u2bd4\0\u2c16\0\u1398"+
    "\0\u2c58\0\u2c9a\0\u2c16\0\u2c58\0\u141c\0\u145e\0\u2cdc\0\u14a0"+
    "\0\u04a4\0\u2d1e\0\u14e2\0\u04a4\0\u2d60\0\u04a4\0\u2da2\0\u2de4"+
    "\0\u2e26\0\u04a4\0\u04a4\0\u04a4\0\u04a4\0\u2e68\0\u2eaa\0\u2eec"+
    "\0\u2eec\0\u2f2e\0\u2f70\0\u2fb2\0\u2ff4\0\u3036\0\u3078\0\u30ba"+
    "\0\u1b54\0\u1b96\0\u06f6\0\u30fc\0\u06f6\0\u313e\0\u3180\0\u31c2"+
    "\0\u3204\0\u3246\0\u3288\0\u32ca\0\u330c\0\u334e\0\u06f6\0\u3390"+
    "\0\u33d2\0\u3414\0\u06f6\0\u3456\0\u3498\0\u34da\0\u351c\0\u06f6"+
    "\0\u06f6\0\u355e\0\u35a0\0\u35e2\0\u3624\0\u3666\0\u36a8\0\u36ea"+
    "\0\u372c\0\u376e\0\u37b0\0\u37f2\0\u3834\0\u3876\0\u38b8\0\u38fa"+
    "\0\u393c\0\u397e\0\u39c0\0\u3a02\0\u04a4\0\u06f6\0\u3a44\0\u3a86"+
    "\0\u3ac8\0\u3b0a\0\u3b4c\0\u3b8e\0\u3bd0\0\u3c12\0\u3c54\0\u3c96"+
    "\0\u3cd8\0\u3d1a\0\u3d5c\0\u3d9e\0\u3de0\0\u3e22\0\u3e64\0\u04a4"+
    "\0\u04a4\0\u04a4\0\u3ea6\0\u3ee8\0\u3f2a\0\u3f6c\0\u3fae\0\u04a4"+
    "\0\u3ff0\0\u04a4\0\u4032\0\u4074\0\u04a4\0\u04a4\0\u40b6\0\u04a4"+
    "\0\u40f8\0\u2de4\0\u2e26\0\u413a\0\u417c\0\u41be\0\u4200\0\u4242"+
    "\0\u4284\0\u42c6\0\u4308\0\u06f6\0\u434a\0\u438c\0\u06f6\0\u43ce"+
    "\0\u4410\0\u4452\0\u4494\0\u44d6\0\u4518\0\u455a\0\u459c\0\u45de"+
    "\0\u4620\0\u4662\0\u46a4\0\u46e6\0\u4728\0\u476a\0\u47ac\0\u47ee"+
    "\0\u4830\0\u4872\0\u06f6\0\u48b4\0\u48f6\0\u4938\0\u497a\0\u49bc"+
    "\0\u49fe\0\u4a40\0\u4a82\0\u4ac4\0\u4b06\0\u06f6\0\u4b48\0\u06f6"+
    "\0\u4b8a\0\u4bcc\0\u4c0e\0\u4c50\0\u4c92\0\u4cd4\0\u4d16\0\u4d58"+
    "\0\u4d9a\0\u4ddc\0\u4e1e\0\u4e60\0\u4ea2\0\u4ee4\0\u4f26\0\u4f68"+
    "\0\u4faa\0\u4fec\0\u502e\0\u5070\0\u50b2\0\u50f4\0\u5136\0\u5178"+
    "\0\u51ba\0\u51fc\0\u523e\0\u04a4\0\u5280\0\u52c2\0\u5304\0\u5346"+
    "\0\u5388\0\u06f6\0\u53ca\0\u540c\0\u544e\0\u5490\0\u54d2\0\u06f6"+
    "\0\u5514\0\u06f6\0\u06f6\0\u5556\0\u5598\0\u55da\0\u561c\0\u06f6"+
    "\0\u565e\0\u06f6\0\u06f6\0\u56a0\0\u56e2\0\u5724\0\u5766\0\u57a8"+
    "\0\u57ea\0\u06f6\0\u582c\0\u06f6\0\u586e\0\u58b0\0\u06f6\0\u06f6"+
    "\0\u06f6\0\u58f2\0\u5934\0\u5976\0\u59b8\0\u06f6\0\u06f6\0\u59fa"+
    "\0\u5a3c\0\u06f6\0\u5a7e\0\u5ac0\0\u5b02\0\u5b44\0\u5b86\0\u5bc8"+
    "\0\u5c0a\0\u04a4\0\u5c4c\0\u5c8e\0\u5cd0\0\u5d12\0\u5d54\0\u5d96"+
    "\0\u5dd8\0\u5e1a\0\u5e5c\0\u5e9e\0\u5ee0\0\u5f22\0\u5f64\0\u5fa6"+
    "\0\u04a4\0\u5fe8\0\u602a\0\u606c\0\u60ae\0\u60f0\0\u04a4\0\u04a4"+
    "\0\u6132\0\u6174\0\u61b6\0\u61f8\0\u623a\0\u627c\0\u62be\0\u06f6"+
    "\0\u6300\0\u6342\0\u6384\0\u63c6\0\u6408\0\u644a\0\u648c\0\u06f6"+
    "\0\u64ce\0\u6510\0\u6552\0\u6594\0\u65d6\0\u6618\0\u665a\0\u06f6"+
    "\0\u06f6\0\u06f6\0\u669c\0\u06f6\0\u06f6\0\u66de\0\u6720\0\u6762"+
    "\0\u67a4\0\u67e6\0\u6828\0\u04a4\0\u686a\0\u68ac\0\u68ee\0\u6930"+
    "\0\u6972\0\u04a4\0\u69b4\0\u69f6\0\u6a38\0\u6a7a\0\u6abc\0\u6afe"+
    "\0\u6b40\0\u6b82\0\u6bc4\0\u6c06\0\u6c48\0\u6c8a\0\u06f6\0\u6ccc"+
    "\0\u6d0e\0\u6d50\0\u6d92\0\u6dd4\0\u6e16\0\u6e58\0\u6e9a\0\u6edc"+
    "\0\u6f1e\0\u06f6\0\u06f6\0\u06f6\0\u6f60\0\u06f6\0\u6fa2\0\u6fe4"+
    "\0\u7026\0\u7068\0\u06f6\0\u70aa\0\u04a4\0\u70ec\0\u712e\0\u7170"+
    "\0\u04a4\0\u71b2\0\u06f6\0\u71f4\0\u7236\0\u7278\0\u72ba\0\u72fc"+
    "\0\u733e\0\u7380\0\u73c2\0\u7404\0\u7446\0\u7488\0\u74ca\0\u750c"+
    "\0\u06f6\0\u06f6\0\u754e\0\u7590\0\u75d2\0\u7614\0\u7656\0\u06f6"+
    "\0\u7698\0\u06f6\0\u06f6\0\u76da\0\u771c\0\u04a4\0\u04a4\0\u06f6"+
    "\0\u775e\0\u77a0\0\u77e2\0\u06f6\0\u7824\0\u7866\0\u78a8\0\u78ea"+
    "\0\u792c\0\u796e\0\u79b0\0\u79f2\0\u06f6\0\u06f6\0\u7a34\0\u06f6"+
    "\0\u7a76\0\u7ab8\0\u06f6\0\u7afa\0\u06f6\0\u7b3c\0\u7b7e\0\u06f6"+
    "\0\u7bc0\0\u7c02\0\u7c44\0\u7c86\0\u06f6\0\u06f6\0\u7cc8\0\u06f6"+
    "\0\u06f6\0\u7d0a\0\u7d4c\0\u7d8e\0\u7dd0\0\u06f6\0\u7e12\0\u7e54"+
    "\0\u7e96\0\u7ed8\0\u7f1a\0\u7f5c\0\u7f9e\0\u7fe0\0\u8022\0\u8064"+
    "\0\u80a6\0\u04a4\0\u80e8\0\u06f6\0\u06f6\0\u06f6\0\u812a\0\u816c"+
    "\0\u81ae\0\u06f6\0\u81f0\0\u8232\0\u8274\0\u82b6\0\u06f6\0\u82f8"+
    "\0\u833a\0\u837c\0\u83be\0\u8400\0\u8442\0\u8484\0\u84c6\0\u8508"+
    "\0\u854a\0\u858c\0\u85ce\0\u04a4\0\u8610";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[709];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\61\21\1\22\20\21\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\1\31\1\32\1\33\1\24\1\34\3\35\1\36"+
    "\1\37\1\40\1\41\1\42\1\43\1\44\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\1\34\1\60\1\34\1\61\1\62\1\34\1\63"+
    "\1\64\1\65\1\66\1\67\1\70\1\34\1\71\1\34"+
    "\1\72\1\73\1\74\1\75\1\76\1\77\1\100\1\101"+
    "\1\102\1\103\1\104\1\105\1\106\1\107\1\110\1\111"+
    "\1\54\1\112\1\113\16\114\1\115\1\116\1\117\1\114"+
    "\1\120\57\114\20\121\1\122\57\121\1\123\1\121\16\124"+
    "\1\125\1\124\1\126\1\127\1\130\57\124\13\131\1\132"+
    "\1\131\1\132\1\133\1\131\1\134\1\131\1\135\57\131"+
    "\13\136\1\137\1\136\1\137\64\136\3\140\1\141\2\140"+
    "\3\141\1\140\1\141\11\140\22\141\3\140\1\141\2\140"+
    "\3\141\20\140\1\141\2\140\3\142\1\143\2\142\3\143"+
    "\1\142\1\143\11\142\22\143\3\142\1\143\2\142\3\143"+
    "\20\142\1\143\2\142\102\144\3\145\1\146\2\145\3\146"+
    "\1\145\1\146\3\35\6\145\22\146\1\147\2\145\1\146"+
    "\2\145\3\146\20\145\1\146\2\145\3\150\1\151\2\150"+
    "\3\151\1\150\1\151\11\150\22\151\3\150\1\151\2\150"+
    "\3\151\20\150\1\151\2\150\1\23\1\152\1\153\1\34"+
    "\1\154\1\155\3\34\1\152\1\34\3\156\1\36\1\157"+
    "\1\156\1\160\1\161\1\43\22\34\1\162\1\163\1\164"+
    "\1\34\1\165\1\70\3\34\1\166\1\167\1\170\1\171"+
    "\1\172\1\173\1\174\1\175\1\176\1\103\1\104\1\177"+
    "\1\106\1\200\1\110\1\201\1\34\2\156\62\202\1\203"+
    "\17\202\15\204\1\205\44\204\1\206\17\204\13\207\1\210"+
    "\1\207\1\211\31\207\1\212\14\207\1\213\7\207\1\213"+
    "\5\207\61\21\1\214\101\21\1\0\2\21\1\215\7\21"+
    "\1\216\2\21\1\217\2\21\103\0\1\24\1\220\1\221"+
    "\1\0\1\24\3\0\1\24\71\0\1\220\3\0\1\220"+
    "\3\0\1\220\45\0\1\222\23\0\1\34\1\0\1\34"+
    "\1\0\1\34\1\223\4\34\11\0\5\34\1\224\1\225"+
    "\4\34\1\226\5\34\1\227\3\0\1\230\2\0\3\34"+
    "\20\0\1\34\6\0\1\231\52\0\1\232\23\0\1\24"+
    "\1\220\1\221\1\0\1\24\1\233\1\0\1\234\1\24"+
    "\71\0\1\34\1\0\1\34\1\0\6\34\11\0\7\34"+
    "\1\235\12\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\3\34\1\236\2\34"+
    "\11\0\5\34\1\237\2\34\1\240\1\241\10\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\240\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\4\0\1\37\4\0\11\34\1\242"+
    "\10\34\3\0\1\34\2\0\3\34\2\0\1\243\15\0"+
    "\1\34\1\244\2\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\22\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\15\0\3\35\67\0\1\245\2\0\3\245\1\0\1\245"+
    "\11\0\22\245\3\0\1\245\2\0\3\245\20\0\1\245"+
    "\2\0\16\246\1\247\1\250\1\251\1\246\1\252\57\246"+
    "\1\0\1\34\1\0\1\34\1\0\6\34\11\0\3\34"+
    "\1\253\1\34\1\254\2\34\1\255\10\34\1\256\3\0"+
    "\1\34\2\0\3\34\20\0\1\255\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\11\34\1\257\2\34\1\260"+
    "\5\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\261\1\0\6\34\11\0\1\262\6\34"+
    "\1\263\12\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\1\264"+
    "\3\34\1\265\2\34\1\266\12\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\5\34\1\267\2\34\1\270\11\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\270\3\0\1\34\1\0"+
    "\1\271\1\0\2\34\1\272\3\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\2\34\1\273\3\34\11\0\7\34\1\274"+
    "\3\34\1\275\6\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\11\34\1\276\10\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\1\34\1\277\13\34\1\300\4\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\301\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\1\302\21\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\1\303"+
    "\21\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\14\34\1\304"+
    "\5\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\7\34\1\305"+
    "\3\34\1\306\6\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\4\34\1\307\4\34\1\310\10\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\50\0\1\311\1\312\7\0\1\313"+
    "\71\0\1\314\7\0\1\315\72\0\1\316\32\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\317\3\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\11\0\1\320"+
    "\1\321\3\0\1\322\7\0\1\323\1\0\1\324\1\325"+
    "\1\326\2\0\1\327\1\330\1\331\41\0\1\330\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\22\34\3\0"+
    "\1\34\2\0\1\34\1\332\1\34\20\0\1\34\51\0"+
    "\1\333\7\0\1\334\101\0\1\335\71\0\1\336\7\0"+
    "\1\337\1\0\1\340\1\0\1\341\75\0\1\342\101\0"+
    "\1\343\2\0\1\344\1\113\65\0\1\345\7\0\1\346"+
    "\101\0\1\347\5\0\1\350\73\0\1\351\6\0\1\352"+
    "\72\0\1\353\71\0\1\354\32\0\20\244\1\355\57\244"+
    "\1\250\1\244\16\114\1\356\1\0\1\357\1\114\1\360"+
    "\62\114\1\361\2\114\3\361\1\114\1\361\3\114\1\362"+
    "\1\363\1\357\1\114\1\364\1\114\22\361\3\114\1\361"+
    "\2\114\3\361\20\114\1\361\122\114\1\365\1\363\1\357"+
    "\1\114\1\366\57\114\20\121\1\367\57\121\1\0\21\121"+
    "\1\370\57\121\1\370\1\121\16\124\1\371\1\124\1\372"+
    "\1\0\1\373\62\124\1\361\2\124\3\361\1\124\1\361"+
    "\3\124\1\374\1\124\1\372\1\375\1\364\1\124\22\361"+
    "\3\124\1\361\2\124\3\361\20\124\1\361\122\124\1\365"+
    "\1\124\1\372\1\375\1\376\57\124\13\131\1\132\1\131"+
    "\1\132\1\377\1\131\1\u0100\1\131\1\u0101\62\131\1\u0102"+
    "\2\131\3\u0102\1\131\1\u0102\1\132\1\131\1\132\1\377"+
    "\1\131\1\u0100\1\131\1\u0101\1\131\22\u0102\3\131\1\u0102"+
    "\2\131\3\u0102\20\131\1\u0102\5\131\1\361\2\131\3\361"+
    "\1\131\1\361\1\132\1\131\1\132\1\u0103\1\131\1\u0100"+
    "\1\131\1\364\1\131\22\361\3\131\1\361\2\131\3\361"+
    "\20\131\1\361\15\131\1\132\1\131\1\132\77\131\1\132"+
    "\1\131\1\132\1\365\1\131\1\u0100\1\131\1\u0104\57\131"+
    "\13\u0105\1\u0106\1\u0105\1\u0106\67\u0105\1\u0107\2\u0105\3\u0107"+
    "\1\u0105\1\u0107\1\u0106\1\u0105\1\u0106\6\u0105\22\u0107\3\u0105"+
    "\1\u0107\2\u0105\3\u0107\20\u0105\1\u0107\2\u0105\1\0\1\u0108"+
    "\1\0\1\u0108\1\0\6\u0108\1\u0109\1\0\1\u0109\5\0"+
    "\1\u010a\22\u0108\3\0\1\u0108\2\0\3\u0108\20\0\1\u0108"+
    "\3\0\1\u010b\1\0\1\u010b\1\0\6\u010b\1\u010c\1\0"+
    "\1\u010c\5\0\1\u010d\22\u010b\3\0\1\u010b\2\0\3\u010b"+
    "\20\0\1\u010b\3\0\1\146\1\0\1\146\1\0\6\146"+
    "\11\0\22\146\3\0\1\146\2\0\3\146\20\0\1\146"+
    "\51\0\1\u010e\33\0\1\151\1\0\1\151\1\0\6\151"+
    "\11\0\22\151\3\0\1\151\2\0\3\151\20\0\1\151"+
    "\3\0\1\152\3\0\1\152\3\0\1\152\71\0\1\u010f"+
    "\3\0\1\u010f\1\u0110\1\0\1\u0111\1\u010f\70\0\62\202"+
    "\1\0\17\202\63\0\1\u0112\31\0\1\204\151\0\1\u0113"+
    "\16\0\13\207\1\210\1\207\1\211\31\207\1\210\14\207"+
    "\1\210\7\207\1\210\5\207\13\0\1\210\135\0\1\u0114"+
    "\32\0\61\21\1\0\2\21\1\0\7\21\1\0\2\21"+
    "\1\0\2\21\57\0\1\u0115\66\0\1\u0116\12\0\1\u0115"+
    "\54\0\1\u0117\50\0\1\220\1\0\1\221\1\0\1\220"+
    "\3\0\1\220\71\0\1\u0118\2\0\1\u0119\1\u0118\3\0"+
    "\1\u0118\34\0\1\u0119\34\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\u011a\1\u011b\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\2\34\1\u011c\17\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\14\34\1\u011d\5\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\10\34\1\u011e\11\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\u011e\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\20\34\1\u011f\1\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u0120\3\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\u0121\1\0\1\u0121\1\0"+
    "\1\u0121\1\0\3\u0121\14\0\2\u0121\2\0\1\u0121\54\0"+
    "\1\u0122\3\0\1\u0122\71\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\11\34\1\u0123\10\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\10\34\1\u0124\11\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\u0124\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\2\34\1\u0125\17\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\11\34\1\u0126\10\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\u0127\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\63\0\1\u0128\21\0\1\245\1\0\1\245\1\0"+
    "\6\245\11\0\22\245\3\0\1\245\2\0\3\245\20\0"+
    "\1\245\2\0\3\246\1\0\2\246\3\0\1\246\1\0"+
    "\3\246\1\247\1\250\1\251\1\246\1\0\1\246\22\0"+
    "\3\246\1\0\2\246\3\0\20\246\1\0\122\246\1\0"+
    "\1\250\1\251\1\246\1\252\57\246\1\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\1\34\1\u0129\4\34\1\u012a"+
    "\1\34\1\u012b\11\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\u012b\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\10\34\1\u012c\11\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\u012c\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\20\34\1\u012d\1\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\2\34\1\u012e"+
    "\3\34\11\0\12\34\1\u012f\7\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\11\34\1\u0130\10\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\3\34\1\u0131\2\34\1\u0132\13\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\u0133\1\0\6\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\5\34\1\u0134\14\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\5\34\1\u0135\14\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\11\34\1\u0136\10\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\10\34\1\u0137\11\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\u0137\3\0\1\34\1\0\1\u0138\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\15\34\1\u0139\4\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\21\34\1\u013a\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\1\34"+
    "\1\u013b\6\34\1\u013c\2\34\1\u013d\6\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\u013c\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\5\34\1\u013e\14\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u013f\3\34\11\0\7\34\1\u0140\12\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u0141\3\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\u0142\21\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\1\34\1\u0143\20\34\3\0"+
    "\1\34\2\0\2\34\1\u0144\20\0\1\34\3\0\1\34"+
    "\1\0\1\u0145\1\0\6\34\11\0\22\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\10\34\1\u0146\11\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\u0146\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\1\u0147\21\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\34\1\u0148\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\7\34\1\u0149\12\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\3\34\1\u014a\2\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\u014b\6\34\1\u014c\12\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\61\0\1\u014d\23\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\11\34\1\u014e\10\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\37\0\1\u014f"+
    "\70\0\1\u0150\6\0\1\u0151\77\0\1\u0152\103\0\1\u0153"+
    "\105\0\1\u0154\73\0\1\u0155\60\0\1\u0156\116\0\1\u0157"+
    "\57\0\1\u0158\77\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\2\34\1\u0159\1\u015a\1\34\1\u015b\1\u015c\4\34"+
    "\1\u015d\1\u015e\4\34\1\u015f\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\61\0\1\u0160\101\0\1\u0161\101\0\1\u0162"+
    "\1\0\1\u0163\54\0\1\u0164\42\0\1\u0164\15\0\3\u0165"+
    "\44\0\1\u0166\12\0\1\u0167\17\0\1\u0168\1\0\1\u0169"+
    "\77\0\1\u016a\1\0\1\u016b\64\0\102\244\3\114\1\0"+
    "\2\114\3\0\1\114\1\0\3\114\1\362\1\363\1\357"+
    "\1\114\1\0\1\114\22\0\3\114\1\0\2\114\3\0"+
    "\20\114\1\0\20\114\1\0\1\363\1\357\1\114\1\366"+
    "\57\114\1\0\1\361\1\0\1\361\1\0\6\361\11\0"+
    "\22\361\1\u016c\2\0\1\361\2\0\3\361\12\0\1\u016d"+
    "\5\0\1\361\2\0\20\121\1\0\57\121\1\0\1\121"+
    "\3\124\1\0\2\124\3\0\1\124\1\0\3\124\1\374"+
    "\1\124\1\372\1\375\1\0\1\124\22\0\3\124\1\0"+
    "\2\124\3\0\20\124\1\0\20\124\1\0\1\124\1\372"+
    "\1\375\1\376\57\124\3\131\1\0\2\131\3\0\1\131"+
    "\1\0\1\132\1\131\1\132\1\u0103\1\131\1\u0100\1\131"+
    "\1\0\1\131\22\0\3\131\1\0\2\131\3\0\20\131"+
    "\1\0\15\131\1\132\1\131\1\132\1\0\1\131\1\u0100"+
    "\1\131\1\u0104\60\131\1\u0102\1\131\1\u0102\1\131\6\u0102"+
    "\1\u016e\1\131\1\u016e\1\377\1\131\1\u0100\1\131\1\u0101"+
    "\1\u016f\22\u0102\3\131\1\u0102\2\131\3\u0102\20\131\1\u0102"+
    "\2\131\1\u0105\1\u0107\1\u0105\1\u0107\1\u0105\6\u0107\1\u0170"+
    "\1\u0105\1\u0170\5\u0105\1\u0171\22\u0107\3\u0105\1\u0107\2\u0105"+
    "\3\u0107\20\u0105\1\u0107\2\u0105\13\0\1\u0109\1\0\1\u0109"+
    "\77\0\1\u010c\1\0\1\u010c\65\0\1\u010f\3\0\1\u010f"+
    "\3\0\1\u010f\71\0\1\u0172\1\0\1\u0172\1\0\1\u0172"+
    "\1\0\3\u0172\14\0\2\u0172\2\0\1\u0172\54\0\1\u0173"+
    "\3\0\1\u0173\130\0\1\u0174\76\0\1\u0175\45\0\1\u0118"+
    "\3\0\1\u0118\3\0\1\u0118\71\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\1\34\1\u0133\20\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\u0176"+
    "\1\0\6\34\11\0\22\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\1\u0177\1\34\1\u0178\1\u0179\4\34\1\u017a\4\34"+
    "\1\u017b\4\34\3\0\1\34\2\0\3\34\20\0\1\u017a"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\7\34"+
    "\1\u017c\12\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\u017d\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u017e\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\13\34\1\u017f\6\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u0180\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u0181\3\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\2\34\1\u0182\3\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\63\0\1\u0163"+
    "\21\0\1\34\1\0\1\u0183\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\13\34\1\u0184\6\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u0185\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\u0186\1\0\6\34\11\0\22\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\13\34\1\u0187\6\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\1\u0188\21\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\7\34\1\u0189\12\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u018a\3\34\11\0\1\u018b\21\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\13\34\1\u018c\6\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u018d\3\34\11\0\22\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\6\34\1\u018e\13\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\u018f"+
    "\1\0\6\34\11\0\22\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\u0190\1\0\6\34"+
    "\11\0\22\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\u0191\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\6\34\1\u0192\13\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\u0193\1\0\6\34\11\0\22\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\13\34\1\u0194\6\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\1\34\1\u0195\6\34\1\u0196\11\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\u0196\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\10\34\1\u0197\11\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\u0197\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\5\34\1\u0198\14\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u0199\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u019a\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\4\34\1\u019b\15\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\4\34\1\u019c\15\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\13\34\1\u019d\6\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u019e\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\13\34\1\u019f\6\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\7\34\1\u01a0\12\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\3\34\1\u01a1\2\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\13\34\1\u01a2\6\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\5\34\1\u01a3\14\34"+
    "\3\0\1\u01a4\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u01a5\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\37\0\1\u01a6"+
    "\75\0\1\u01a7\103\0\1\u01a8\73\0\1\u01a9\104\0\1\u01aa"+
    "\104\0\1\u01ab\102\0\1\u01ac\42\0\1\u01ac\56\0\1\u01ad"+
    "\62\0\1\u01ae\53\0\1\u01af\73\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\1\u01b0\21\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\u01b1\3\34\1\u01b2\15\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u01b3\3\34\11\0\22\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\13\34\1\u01b4\6\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\1\u01b5\21\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u01b6\3\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\u01b7\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\5\0\1\u01b8\2\0\3\u01b8\1\0\1\u01b8\1\0"+
    "\1\u0163\2\0\1\u01b9\4\0\22\u01b8\3\0\1\u01b8\2\0"+
    "\3\u01b8\20\0\1\u01b8\1\u01ba\33\0\1\u01bb\62\0\3\u0165"+
    "\57\0\1\u0167\67\0\1\u01bc\67\0\1\u01bd\43\0\1\u0168"+
    "\101\0\1\u016a\135\0\1\u01be\32\0\13\131\1\u016e\1\131"+
    "\1\u016e\1\377\1\131\1\u0100\1\131\1\u0101\57\131\13\u0105"+
    "\1\u0170\1\u0105\1\u0170\64\u0105\44\0\1\u01bf\61\0\1\u01c0"+
    "\56\0\1\34\1\0\1\34\1\0\6\34\11\0\5\34"+
    "\1\u01c1\14\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\3\34"+
    "\1\u01c2\16\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\u01c3\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\7\34\1\u01c4\12\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\15\34\1\u01c5\4\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\14\34\1\u01c6\5\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\u01c7\21\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\12\34\1\u01c8\7\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\11\34\1\u01c9\10\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\12\34\1\u01ca\7\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\16\34\1\u01cb\3\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\11\34\1\u01cc\10\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\4\34\1\u01cd\15\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\u01ce\1\0\2\34\1\u01cf\3\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\1\34\1\u01d0\20\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\u01d1\1\0\6\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\34\1\u01d2\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\15\34\1\u01d3\4\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\4\34\1\u01d4\15\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\5\34\1\u01d5\14\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u01d6\3\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\13\34\1\u01d7\6\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\34\1\u01d8\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u01d9\3\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\34\1\u01da\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\10\34\1\u01db\11\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\u01db\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\14\34\1\u01dc\5\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u01dd\3\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\u01de\21\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\1\34\1\u01df\20\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\10\34\1\u01e0\11\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\u01e0\3\0\1\34\1\0\1\u01e1\1\0\6\34"+
    "\11\0\22\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\1\u01e2"+
    "\21\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\6\34\1\u01e3"+
    "\13\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\11\34\1\u01e4"+
    "\10\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\1\u01e5\21\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\2\34\1\u01e6\17\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\u01e7\1\0\6\34\11\0\22\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\2\34\1\u01e8\3\34\11\0\22\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\1\u01e9\21\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\34\1\u01ea\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\2\34\1\u01eb\3\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\u01ec\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\11\0\1\u01ed\101\0\1\u01ee\131\0\1\u01ef\45\0"+
    "\1\u01f0\10\0\1\u01f1\36\0\1\u01f2\36\0\1\u01f3\100\0"+
    "\1\u01f4\75\0\1\u01f5\101\0\1\u01f6\122\0\1\u01f7\114\0"+
    "\1\u01f8\43\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\11\34\1\u01f9\10\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\13\34\1\u01fa\6\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\5\34\1\u01fb\14\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\21\34\1\u01fc\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\2\34\1\u01fd\3\34"+
    "\11\0\22\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\5\34"+
    "\1\u01fe\14\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\13\34"+
    "\1\u01ff\6\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\1\34"+
    "\1\u0200\20\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\u01b8\1\0\1\u01b8\1\0\6\u01b8\1\u0201\1\0"+
    "\1\u0202\6\0\22\u01b8\3\0\1\u01b8\2\0\3\u01b8\20\0"+
    "\1\u01b8\5\0\1\u0203\2\0\3\u0203\1\0\1\u0203\11\0"+
    "\22\u0203\3\0\1\u0203\2\0\3\u0203\20\0\1\u0203\5\0"+
    "\1\u0204\2\0\3\u0204\1\0\1\u0204\11\0\22\u0204\3\0"+
    "\1\u0204\2\0\3\u0204\20\0\1\u0204\37\0\1\u0205\53\0"+
    "\1\u0206\75\0\1\u0207\2\0\3\u0207\1\0\1\u0207\11\0"+
    "\22\u0207\3\0\1\u0207\2\0\3\u0207\20\0\1\u0207\15\0"+
    "\2\u0208\1\u0209\130\0\1\u020a\36\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\2\34\1\u020b\17\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\6\34\1\u020c\13\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\11\34\1\u020d\10\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\1\u020e\21\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\u020f\21\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\3\34\1\u0210\16\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\2\34"+
    "\1\u0211\3\34\11\0\22\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\3\34\1\u0212\16\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\2\34\1\u0213\17\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\2\34"+
    "\1\u0214\3\34\11\0\22\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\5\34\1\u0215\14\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\21\34\1\u0216\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\13\34\1\u0217\6\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\u0218\1\0\6\34\11\0"+
    "\22\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\11\34\1\u0219"+
    "\10\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\13\34\1\u021a"+
    "\6\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\1\u021b\21\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\6\34\1\u021c\13\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\20\34\1\u021d\1\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\3\34\1\u021e\2\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\5\34\1\u021f\14\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\6\34\1\u0220\13\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\14\34\1\u0221\5\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\5\34\1\u0222\14\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\11\34\1\u0223\10\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\13\34\1\u0224\6\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\6\34\1\u0225\13\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u0226\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\6\34\1\u0227\13\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\40\0\1\u0228"+
    "\100\0\1\u0229\47\0\1\u022a\10\0\1\u022b\36\0\1\u022c"+
    "\71\0\1\u022d\52\0\1\u01f1\36\0\1\u01f2\65\0\1\u022e"+
    "\67\0\1\u01f8\101\0\1\u022f\106\0\1\u0230\100\0\1\u0231"+
    "\64\0\1\u01f8\36\0\1\u0232\27\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\22\34\3\0\1\34\2\0\1\34"+
    "\1\u0233\1\34\20\0\1\34\3\0\1\34\1\0\1\u0234"+
    "\1\0\6\34\11\0\22\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\6\34\1\u0235\13\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\u0236\1\0\6\34"+
    "\11\0\22\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\10\34"+
    "\1\u0237\11\34\3\0\1\34\2\0\3\34\20\0\1\u0237"+
    "\3\0\1\34\1\0\1\u0238\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\1\34\1\u0239\20\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\14\34\1\u023a\5\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\15\0\1\u0201"+
    "\67\0\1\u0203\1\0\1\u0203\1\0\6\u0203\4\0\1\u023b"+
    "\4\0\22\u0203\3\0\1\u0203\2\0\3\u0203\20\0\1\u0203"+
    "\3\0\1\u0204\1\0\1\u0204\1\0\6\u0204\11\0\22\u0204"+
    "\3\0\1\u0204\2\0\3\u0204\20\0\1\u0204\1\u023b\25\0"+
    "\1\u023c\112\0\1\u023d\57\0\1\u0208\113\0\1\u023e\55\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\10\34\1\u023f"+
    "\11\34\3\0\1\34\2\0\3\34\20\0\1\u023f\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\13\34\1\u0240"+
    "\6\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\u0241\1\0\6\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\1\34\1\u0242\20\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\13\34\1\u0243\6\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\6\34\1\u0244\13\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\2\34\1\u0245\3\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\u0246\1\0\6\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\2\34\1\u0247\17\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\6\34\1\u0248\13\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\u0249\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\1\34\1\u024a\20\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\u024b\1\0\6\34\11\0"+
    "\22\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\12\34\1\u024c"+
    "\7\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\7\34\1\u024d"+
    "\12\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\14\34\1\u024e"+
    "\5\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\2\34\1\u024f\3\34\11\0"+
    "\22\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\13\34\1\u0250"+
    "\6\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\4\34\1\u0251"+
    "\15\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\u0252\1\0\6\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\u0253\1\0\6\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\34\1\u0254\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\16\0\1\u0228\36\0\1\u0255\64\0"+
    "\1\u0256\52\0\1\u0257\106\0\1\u022b\36\0\1\u022c\31\0"+
    "\1\u0258\101\0\1\u01f8\112\0\1\u022f\36\0\1\u0259\53\0"+
    "\1\u025a\117\0\1\u0256\37\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\1\34\1\u025b"+
    "\1\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\1\34\1\u025c"+
    "\1\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\34\1\u025d\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\10\34\1\u025e\11\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\u025e\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\10\34\1\u025f\11\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\u025f\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\1\34\1\u0260"+
    "\1\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\1\34\1\u0261"+
    "\1\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\7\34\1\u0262\12\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\15\0\1\u0201\1\0\1\u0202\130\0"+
    "\1\u0263\50\0\3\u0264\77\0\3\u0265\65\0\1\34\1\0"+
    "\1\34\1\0\2\34\1\u0266\3\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\2\34\1\u0267\3\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\6\34\1\u0268\13\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\u0269\1\0\6\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\1\34\1\u026a\20\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\6\34\1\u026b\13\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\1\34\1\u026c"+
    "\1\34\20\0\1\34\3\0\1\34\1\0\1\34\1\0"+
    "\6\34\11\0\7\34\1\u026d\12\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\u026e\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\5\34\1\u026f\14\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\5\34\1\u0270\14\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\6\34\1\u0271\13\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\u0272\1\0\6\34\11\0"+
    "\22\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\u0273\1\0\6\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\22\34\3\0\1\34\2\0"+
    "\1\34\1\u0274\1\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\u0275\1\0\6\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\16\0\1\u0256\36\0\1\u0276\57\0"+
    "\1\u022b\105\0\1\u01f1\60\0\1\u025a\36\0\1\u0277\27\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\22\34\3\0"+
    "\1\34\2\0\1\34\1\u0278\1\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\1\u0279\21\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\20\34\1\u027a\1\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\22\34\3\0\1\34"+
    "\2\0\1\34\1\u027b\1\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\22\34\3\0\1\34"+
    "\2\0\1\34\1\u027c\1\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\6\34\1\u027d\13\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\3\0\1\34"+
    "\1\0\1\34\1\0\6\34\11\0\2\34\1\u027e\17\34"+
    "\3\0\1\34\2\0\3\34\20\0\1\34\27\0\1\u027f"+
    "\57\0\1\u0280\2\0\3\u0280\1\0\1\u0280\3\u0264\1\u0281"+
    "\5\0\22\u0280\3\0\1\u0280\2\0\3\u0280\20\0\1\u0280"+
    "\15\0\3\u0265\21\0\1\u0282\43\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\11\34\1\u0283\10\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\6\34\1\u0284\13\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\34"+
    "\1\0\6\34\11\0\14\34\1\u0285\5\34\3\0\1\34"+
    "\2\0\3\34\20\0\1\34\3\0\1\34\1\0\1\u0286"+
    "\1\0\6\34\11\0\22\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\7\34\1\u0287\12\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\3\34\1\u0288\16\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\7\34\1\u0289\12\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\1\34\1\u028a\20\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\3\0\1\34\1\0\1\u028b\1\0\6\34"+
    "\11\0\22\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\7\34"+
    "\1\u028c\12\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\2\34"+
    "\1\u028d\17\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\7\34"+
    "\1\u028e\12\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\2\34\1\u028f\3\34"+
    "\11\0\22\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\1\34\1\u0290\1\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\7\34"+
    "\1\u0291\12\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\1\34\1\u0292\1\34\20\0\1\34"+
    "\15\0\3\u027f\31\0\1\354\33\0\1\u0280\1\0\1\u0280"+
    "\1\0\6\u0280\3\u0293\6\0\22\u0280\3\0\1\u0280\2\0"+
    "\3\u0280\20\0\1\u0280\5\0\1\u0280\2\0\3\u0280\1\0"+
    "\1\u0280\11\0\22\u0280\3\0\1\u0280\2\0\3\u0280\20\0"+
    "\1\u0280\11\0\1\u0294\73\0\1\34\1\0\1\u0295\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\14\34\1\u0296\5\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\5\34\1\u0297\14\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\3\34\1\u0298\16\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\10\34\1\u0299\11\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\u0299\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\5\34\1\u029a\14\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\5\34\1\u029b\14\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\6\34\1\u029c\13\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\21\34\1\u029d\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\1\34\1\u029e\1\34\20\0\1\34"+
    "\5\0\1\u029f\2\0\3\u029f\1\0\1\u029f\3\u0293\2\0"+
    "\1\u02a0\3\0\22\u029f\3\0\1\u029f\2\0\3\u029f\3\0"+
    "\1\u02a1\3\0\1\u02a0\10\0\1\u029f\33\0\1\u02a2\51\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\6\34\1\u02a3"+
    "\13\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\6\34\1\u02a4"+
    "\13\34\3\0\1\34\2\0\3\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\34\1\0\6\34\11\0\22\34\3\0"+
    "\1\34\2\0\1\34\1\u02a5\1\34\20\0\1\34\3\0"+
    "\1\34\1\0\1\u02a6\1\0\6\34\11\0\22\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\34\1\0"+
    "\1\34\1\0\6\34\11\0\20\34\1\u02a7\1\34\3\0"+
    "\1\34\2\0\3\34\20\0\1\34\3\0\1\u029f\1\0"+
    "\1\u029f\1\0\6\u029f\3\u02a8\2\0\1\u02a0\3\0\22\u029f"+
    "\3\0\1\u029f\2\0\3\u029f\3\0\1\u02a1\3\0\1\u02a0"+
    "\2\0\1\u02a9\5\0\1\u029f\5\0\1\u029f\2\0\3\u029f"+
    "\1\0\1\u029f\3\u02a8\2\0\1\u02a0\3\0\22\u029f\3\0"+
    "\1\u029f\2\0\3\u029f\3\0\1\u02a1\3\0\1\u02a0\10\0"+
    "\1\u029f\65\0\1\u02aa\61\0\1\u02ab\37\0\1\34\1\0"+
    "\1\u02ac\1\0\6\34\11\0\22\34\3\0\1\34\2\0"+
    "\3\34\20\0\1\34\3\0\1\34\1\0\1\u02ad\1\0"+
    "\6\34\11\0\22\34\3\0\1\34\2\0\3\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\22\34\3\0\1\34\2\0\1\34\1\u02ae\1\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\22\34\3\0\1\34\2\0\1\34\1\u02af\1\34\20\0"+
    "\1\34\3\0\1\34\1\0\1\34\1\0\6\34\11\0"+
    "\1\u02b0\21\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\15\0\3\u02a8\44\0\1\u02a1\111\0\1\u02a0\37\0\1\u02b1"+
    "\52\0\1\34\1\0\1\34\1\0\6\34\11\0\22\34"+
    "\3\0\1\34\2\0\1\34\1\u02b2\1\34\20\0\1\34"+
    "\3\0\1\34\1\0\1\34\1\0\6\34\11\0\13\34"+
    "\1\u02b3\6\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\11\0\1\u02b4\73\0\1\34\1\0\1\u02b5\1\0\6\34"+
    "\11\0\22\34\3\0\1\34\2\0\3\34\20\0\1\34"+
    "\45\0\1\u02b6\37\0\1\34\1\0\1\34\1\0\6\34"+
    "\11\0\11\34\1\u02b7\10\34\3\0\1\34\2\0\3\34"+
    "\20\0\1\34\5\0\1\u02b8\111\0\3\u02b8\41\0\1\u02b9"+
    "\35\0\3\u02b9\1\0\1\u02ba\24\0\1\u02bb\33\0\1\u02bc"+
    "\45\0\1\u02bd\75\0\1\u02be\105\0\1\u02bf\75\0\1\u02c0"+
    "\105\0\1\u02c1\75\0\1\u02c2\105\0\1\u02c3\50\0\3\u02c1"+
    "\31\0\1\u02c4\76\0\1\u02c5\54\0\1\u02c1\162\0\1\u02c1"+
    "\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[34386];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",		//$NON-NLS-1$
    "Error: could not match input",		//$NON-NLS-1$
    "Error: pushback value was too large"		//$NON-NLS-1$
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\5\0\1\1\12\0\2\1\1\11\14\1\4\11\24\1"+
    "\1\11\12\1\4\11\1\1\2\11\1\1\1\11\2\1"+
    "\1\11\4\1\1\11\3\1\1\11\10\1\1\11\1\1"+
    "\1\11\1\1\2\11\2\1\1\11\2\1\2\11\1\1"+
    "\24\11\2\1\1\11\3\1\1\11\1\1\1\11\1\1"+
    "\1\0\4\1\1\0\1\11\6\1\2\11\2\0\6\1"+
    "\2\0\1\1\2\0\1\11\2\0\36\1\3\11\1\1"+
    "\2\11\1\1\12\0\1\1\1\11\2\1\2\11\1\1"+
    "\1\0\2\11\2\1\6\11\1\1\4\0\2\1\3\11"+
    "\1\1\1\0\1\11\3\0\1\1\1\11\1\1\3\0"+
    "\3\1\4\0\1\11\2\0\1\11\1\0\1\11\1\1"+
    "\2\0\4\11\2\0\1\1\1\0\16\1\1\0\44\1"+
    "\1\11\1\1\12\0\7\1\3\11\3\0\1\1\1\0"+
    "\1\11\1\1\1\11\1\1\1\0\2\11\1\1\1\11"+
    "\1\0\2\1\2\0\60\1\12\0\10\1\4\0\1\11"+
    "\4\0\54\1\5\0\1\11\6\0\10\1\1\11\1\1"+
    "\4\0\2\11\1\1\1\0\35\1\4\0\1\11\5\0"+
    "\1\11\10\1\4\0\26\1\1\11\3\0\1\11\1\0"+
    "\10\1\3\0\20\1\2\11\7\1\4\0\20\1\2\0"+
    "\12\1\4\0\5\1\2\0\1\11\1\0\5\1\1\0"+
    "\2\1\1\0\1\1\1\0\1\1\14\0\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[709];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
	private final LinkedList commentList = new LinkedList();
	private String heredoc = null;
	private String nowdoc = null;
    private boolean asp_tags = false;
    private boolean short_tags_allowed = true;
    private StateStack stack = new StateStack();
    protected int commentStartPosition;

	private AST ast;

    public void setAST(AST ast) {
    	this.ast = ast;
    }

	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP5_5;
	}

	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	public void resetCommentList() {
		commentList.clear();
	}

	public LinkedList getCommentList() {
		return commentList;
	}

	protected void addComment(int type) {
		int leftPosition = getTokenStartPosition();
		Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
		commentList.add(comment);
	}

	public void setUseAspTagsAsPhp(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}

	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}

    private void pushState(int state) {
        stack.pushStack(zzLexicalState);
        yybegin(state);
    }

    private void popState() {
        yybegin(stack.popStack());
    }

    public int getCurrentLine() {
        return yyline;
    }

    protected int getTokenStartPosition() {
        return zzStartRead - _zzPushbackPos;
    }

    protected int getTokenLength() {
        return zzMarkedPos - zzStartRead;
    }

    public int getLength() {
        return zzEndRead - _zzPushbackPos;
    }

    private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}

	private void handleLineCommentEnd() {
         addComment(Comment.TYPE_SINGLE_LINE);
    }

    private void handleMultilineCommentEnd() {
    	addComment(Comment.TYPE_MULTILINE);
    }

    private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
    }

    protected void handleVarComment() {
    	commentStartPosition = zzStartRead;
    	addComment(Comment.TYPE_MULTILINE);
    }

    private Symbol createFullSymbol(int symbolNumber) {
        Symbol symbol = createSymbol(symbolNumber);
        symbol.value = yytext();
        return symbol;
    }

    protected Symbol createSymbol(int symbolNumber) {
        int leftPosition = getTokenStartPosition();
        return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
    }

	public int[] getParamenters() {
		return new int[] { zzMarkedPos, _zzPushbackPos, zzCurrentPos,
				zzStartRead, zzEndRead, yyline, zzAtBOL ? 1 : 0,
				zzAtEOF ? 1 : 0, zzEOFDone ? 1 : 0, zzFinalHighSurrogate };
	}

	/**
	 * Parses a PHPDoc block comment. Underlying reader (zzReader) can be closed
	 * in the process (when EOF is reached).
	 * 
	 * @return true when PHPDoc was parsed, false otherwise (false also implies
	 *         that this scanner wasn't resetted)
	 */
	protected boolean parsePHPDoc() {
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if(documentorLexer == null) {
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParamenters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParamenters());
		return true;
	}

	protected IDocumentorLexer getDocumentorLexer(java.io.Reader  reader) {
		return null;
	}

	/**
	 * Resets the {@code PhpAstLexer} properties to previous values, but leaves
	 * the lexical state unchanged. Be careful, method {@link #next_token()}
	 * also caches those properties using internal variables (zzCurrentPosL,
	 * zzMarkedPosL, zzBufferL, zzEndReadL) that should be accordingly resetted
	 * by the lexical rules calling
	 * {@link #reset(java.io.Reader, char[], int[])}. Also be careful that those
	 * internal variables could change from one version of JFlex to another.
	 * 
	 * @param reader
	 * @param buffer
	 * @param parameters
	 */
	public void reset(java.io.Reader reader, char[] buffer, int[] parameters) {
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this._zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];
		this.yychar = this.zzStartRead - this._zzPushbackPos;
		// XXX: never used
		this.yycolumn = 0;
		this.zzAtEOF = parameters[7] != 0;
		this.zzEOFDone = parameters[8] != 0;
		this.zzFinalHighSurrogate = parameters[9];
		// XXX: check if there's no side-effect to reset zzAtBOL
		// when zzAtEOF is false and zzMarkedPos is equal to zzStartRead.
		// One possible case would be that IDocumentorLexer#parse() matches
		// no text at all without being at EOF (i.e. the document lexer returns
		// a zero-length token), which of course would be totally broken...
		this.zzAtBOL = this.zzAtEOF ? false : (parameters[6] != 0);
	}


  /** the textposition at the last state to be included in yytext */
  private int _zzPushbackPos;

  /* The following fields are added in order to support the change in zzRefill */
  private String oldString = null;
  private int startPos = 0;

  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 236) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      _zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (zzCurrentPos < zzEndRead) return zzBuffer[zzCurrentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (zzAtEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (zzRefill()) {
        return YYEOF;
    }

    return zzBuffer[zzCurrentPos++];
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = _zzPushbackPos = startPos = 0;
    oldString = null;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


	/**
	 * user method - common.sse
	 */
	private void updateStartPos() {
		startPos = zzMarkedPos;
		oldString = null;
	}


	/**
	 * user method - common.sse
	 */
	public final boolean isEOF() {
		return zzAtEOF;
	}


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            zzDoEOF();
          {     return createSymbol(sym.EOF);
 }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 196: break;
          case 2: 
            { return createSymbol(ParserConstants.T_INLINE_HTML);
            }
          case 197: break;
          case 3: 
            { // do nothing
            }
          case 198: break;
          case 4: 
            { return createFullSymbol(ParserConstants.T_LNUMBER);
            }
          case 199: break;
          case 5: 
            { return createSymbol(ParserConstants.T_NEKUDA);
            }
          case 200: break;
          case 6: 
            { return createFullSymbol(ParserConstants.T_STRING);
            }
          case 201: break;
          case 7: 
            { return createSymbol(ParserConstants.T_PLUS);
            }
          case 202: break;
          case 8: 
            { 
            }
          case 203: break;
          case 9: 
            { return createSymbol(ParserConstants.T_DOLLAR);
            }
          case 204: break;
          case 10: 
            { yybegin(ST_DOUBLE_QUOTES);
    return createSymbol(ParserConstants.T_QUATE);
            }
          case 205: break;
          case 11: 
            { return createSymbol(ParserConstants.T_NS_SEPARATOR);
            }
          case 206: break;
          case 12: 
            { yybegin(ST_BACKQUOTE);
    return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 207: break;
          case 13: 
            { pushState(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          case 208: break;
          case 14: 
            { return createSymbol(ParserConstants.T_SEMICOLON);
            }
          case 209: break;
          case 15: 
            { return createSymbol(ParserConstants.T_MINUS);
            }
          case 210: break;
          case 16: 
            { return createSymbol(ParserConstants.T_LGREATER);
            }
          case 211: break;
          case 17: 
            { return createSymbol(ParserConstants.T_NEKUDOTAIM);
            }
          case 212: break;
          case 18: 
            { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
            }
          case 213: break;
          case 19: 
            { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
            }
          case 214: break;
          case 20: 
            { return createSymbol(ParserConstants.T_EQUAL);
            }
          case 215: break;
          case 21: 
            { return createSymbol(ParserConstants.T_NOT);
            }
          case 216: break;
          case 22: 
            { return createSymbol(ParserConstants.T_RGREATER);
            }
          case 217: break;
          case 23: 
            { return createSymbol(ParserConstants.T_TIMES);
            }
          case 218: break;
          case 24: 
            { return createSymbol(ParserConstants.T_DIV);
            }
          case 219: break;
          case 25: 
            { return createSymbol(ParserConstants.T_PRECENT);
            }
          case 220: break;
          case 26: 
            { return createSymbol(ParserConstants.T_REFERENCE);
            }
          case 221: break;
          case 27: 
            { return createSymbol(ParserConstants.T_OR);
            }
          case 222: break;
          case 28: 
            { return createSymbol(ParserConstants.T_KOVA);
            }
          case 223: break;
          case 29: 
            { return createSymbol(ParserConstants.T_COMMA);
            }
          case 224: break;
          case 30: 
            { return createSymbol(ParserConstants.T_OPEN_RECT);
            }
          case 225: break;
          case 31: 
            { return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          case 226: break;
          case 32: 
            { return createSymbol(ParserConstants.T_TILDA);
            }
          case 227: break;
          case 33: 
            { return createSymbol(ParserConstants.T_QUESTION_MARK);
            }
          case 228: break;
          case 34: 
            { return createSymbol(ParserConstants.T_AT);
            }
          case 229: break;
          case 35: 
            { /* This is a temporary fix which is dependant on flex and it's implementation */
    if (!stack.isEmpty()) {
        popState();
    }
    return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          case 230: break;
          case 36: 
            { yybegin(ST_SINGLE_QUOTE);
    return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          case 231: break;
          case 37: 
            { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
//	yymore();
            }
          case 232: break;
          case 38: 
            { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_QUATE);
            }
          case 233: break;
          case 39: 
            { return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 234: break;
          case 40: 
            { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_SINGLE_QUATE);
            }
          case 235: break;
          case 41: 
            { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 236: break;
          case 42: 
            { yypushback(1);
	yybegin(ST_HEREDOC);
            }
          case 237: break;
          case 43: 
            { yypushback(1);
	yybegin(ST_NOWDOC);
            }
          case 238: break;
          case 44: 
            { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_END_HEREDOC);
            }
          case 239: break;
          case 45: 
            { yypushback(yylength());
    popState();
            }
          case 240: break;
          case 46: 
            { popState();
    return createFullSymbol(ParserConstants.T_STRING);
            }
          case 241: break;
          case 47: 
            { yypushback(yylength());
    popState();
    pushState(ST_IN_SCRIPTING);
            }
          case 242: break;
          case 48: 
            { popState();
    pushState(ST_IN_SCRIPTING);
    return createFullSymbol(ParserConstants.T_STRING_VARNAME);
            }
          case 243: break;
          case 49: 
            { /* Offset could be treated as a long */
	return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          case 244: break;
          case 50: 
            { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 245: break;
          case 51: 
            { return createSymbol(ParserConstants.T_QUATE);
            }
          case 246: break;
          case 52: 
            { return createSymbol(ParserConstants.T_BACKQUATE);
            }
          case 247: break;
          case 53: 
            { return createSymbol(ParserConstants.T_CURLY_OPEN);
            }
          case 248: break;
          case 54: 
            { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
            }
          case 249: break;
          case 55: 
            { return createSymbol(ParserConstants.T_CURLY_CLOSE);
            }
          case 250: break;
          case 56: 
            { //	yymore();
            }
          case 251: break;
          case 57: 
            { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
//	yymore();
            }
          case 252: break;
          case 58: 
            { if (asp_tags) {
        yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
            }
          case 253: break;
          case 59: 
            { if (short_tags_allowed || yylength()>2) { /* yyleng>2 means it's not <? but <script> */
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
            }
          case 254: break;
          case 60: 
            { return createFullSymbol(ParserConstants.T_DNUMBER);
            }
          case 255: break;
          case 61: 
            { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
            }
          case 256: break;
          case 62: 
            { return createSymbol(ParserConstants.T_INC);
            }
          case 257: break;
          case 63: 
            { return createSymbol(ParserConstants.T_PLUS_EQUAL);
            }
          case 258: break;
          case 64: 
            { return createSymbol(ParserConstants.T_AS);
            }
          case 259: break;
          case 65: 
            { return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 260: break;
          case 66: 
            { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
            }
          case 261: break;
          case 67: 
            { return createSymbol(ParserConstants.T_IF);
            }
          case 262: break;
          case 68: 
            { return createSymbol(ParserConstants.T_DO);
            }
          case 263: break;
          case 69: 
            { return createSymbol(ParserConstants.T_LOGICAL_OR);
            }
          case 264: break;
          case 70: 
            { return createSymbol(ParserConstants.T_DEC);
            }
          case 265: break;
          case 71: 
            { pushState(ST_LOOKING_FOR_PROPERTY);
    return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          case 266: break;
          case 72: 
            { return createSymbol(ParserConstants.T_MINUS_EQUAL);
            }
          case 267: break;
          case 73: 
            { return createSymbol(ParserConstants.T_SR);
            }
          case 268: break;
          case 74: 
            { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
            }
          case 269: break;
          case 75: 
            { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
            }
          case 270: break;
          case 76: 
            { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
            }
          case 271: break;
          case 77: 
            { return createSymbol(ParserConstants.T_IS_EQUAL);
            }
          case 272: break;
          case 78: 
            { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
            }
          case 273: break;
          case 79: 
            { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
            }
          case 274: break;
          case 80: 
            { return createSymbol(ParserConstants.T_SL);
            }
          case 275: break;
          case 81: 
            { return createSymbol(ParserConstants.T_MUL_EQUAL);
            }
          case 276: break;
          case 82: 
            { return createSymbol(ParserConstants.T_DIV_EQUAL);
            }
          case 277: break;
          case 83: 
            { handleCommentStart();
    yybegin(ST_COMMENT);
            }
          case 278: break;
          case 84: 
            { if (asp_tags) {
        yybegin(YYINITIAL);
        return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
            }
          case 279: break;
          case 85: 
            { return createSymbol(ParserConstants.T_MOD_EQUAL);
            }
          case 280: break;
          case 86: 
            { return createSymbol(ParserConstants.T_AND_EQUAL);
            }
          case 281: break;
          case 87: 
            { return createSymbol(ParserConstants.T_BOOLEAN_AND);
            }
          case 282: break;
          case 88: 
            { return createSymbol(ParserConstants.T_OR_EQUAL);
            }
          case 283: break;
          case 89: 
            { return createSymbol(ParserConstants.T_BOOLEAN_OR);
            }
          case 284: break;
          case 90: 
            { return createSymbol(ParserConstants.T_XOR_EQUAL);
            }
          case 285: break;
          case 91: 
            { yybegin(YYINITIAL);
    return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
            }
          case 286: break;
          case 92: 
            { yypushback(1);
    return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 287: break;
          case 93: 
            { pushState(ST_LOOKING_FOR_VARNAME);
    return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
            }
          case 288: break;
          case 94: 
            { pushState(ST_IN_SCRIPTING);
    yypushback(yylength()-1);
    return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
            }
          case 289: break;
          case 95: 
            { return createSymbol(ParserConstants.T_CHARACTER);
            }
          case 290: break;
          case 96: 
            { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
            }
          case 291: break;
          case 97: 
            { String text = yytext();
    int length = text.length() - 1;
    text = text.trim();

    yypushback(1);

    if (text.endsWith(";")) {
        text = text.substring(0, text.length() - 1);
        yypushback(1);
    }
    if (text.equals(heredoc)) {
        heredoc = null;
        yybegin(ST_IN_SCRIPTING);
        return createSymbol(ParserConstants.T_END_HEREDOC);
    }
    else {
    	yybegin(ST_HEREDOC);
    }
            }
          case 292: break;
          case 98: 
            { String text = yytext();
    int length = text.length() - 1;
    text = text.trim();

    yypushback(1);

    if (text.endsWith(";")) {
        text = text.substring(0, text.length() - 1);
        yypushback(1);
    }
    if (text.equals(nowdoc)) {
    	nowdoc = null;
        yybegin(ST_IN_SCRIPTING);
        return createSymbol(ParserConstants.T_END_HEREDOC);
    }
    else {
    	yybegin(ST_NOWDOC);
    }
            }
          case 293: break;
          case 99: 
            { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
            }
          case 294: break;
          case 100: 
            { /* treat numbers (almost) as strings inside encapsulated strings */
    return createFullSymbol(ParserConstants.T_NUM_STRING);
            }
          case 295: break;
          case 101: 
            { handleMultilineCommentEnd();
    yybegin(ST_IN_SCRIPTING);
            }
          case 296: break;
          case 102: 
            { handlePHPDocEnd();
     yybegin(ST_IN_SCRIPTING);
            }
          case 297: break;
          case 103: 
            { if (asp_tags || yytext().charAt(0)!='%') { /* asp comment? */
	    handleLineCommentEnd();
        yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
	}
            }
          case 298: break;
          case 104: 
            { String text = yytext();
    if ((text.charAt(1)=='%' && asp_tags)
        || (text.charAt(1)=='?')) {
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG_WITH_ECHO;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
            }
          case 299: break;
          case 105: 
            { return createFullSymbol(ParserConstants.T_BNUMBER);
            }
          case 300: break;
          case 106: 
            { return createSymbol(ParserConstants.T_LOGICAL_XOR);
            }
          case 301: break;
          case 107: 
            { return createSymbol(ParserConstants.T_LOGICAL_AND);
            }
          case 302: break;
          case 108: 
            { return createSymbol(ParserConstants.T_TRY);
            }
          case 303: break;
          case 109: 
            { return createFullSymbol(ParserConstants.T_EXIT);
            }
          case 304: break;
          case 110: 
            { return createSymbol(ParserConstants.T_FOR);
            }
          case 305: break;
          case 111: 
            { return createSymbol(ParserConstants.T_USE);
            }
          case 306: break;
          case 112: 
            { return createSymbol(ParserConstants.T_NEW);
            }
          case 307: break;
          case 113: 
            { return createSymbol(ParserConstants.T_SR_EQUAL);
            }
          case 308: break;
          case 114: 
            { return createSymbol(ParserConstants.T_VAR);
            }
          case 309: break;
          case 115: 
            { return createSymbol(ParserConstants.T_IS_IDENTICAL);
            }
          case 310: break;
          case 116: 
            { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
            }
          case 311: break;
          case 117: 
            { return createSymbol(ParserConstants.T_SL_EQUAL);
            }
          case 312: break;
          case 118: 
            { if (parsePHPDoc()) {
	// https://bugs.eclipse.org/bugs/show_bug.cgi?id=316077
	// Reset the internal variables caching the values
	// previously resetted by parsePHPDoc().
	// Actually it would be enough to only reset zzEndReadL,
	// but do it cleanly...
	// Also be careful that those internal variables could
	// change from one version of JFlex to another.
	zzCurrentPosL = zzCurrentPos;
	zzMarkedPosL = zzMarkedPos;
	zzBufferL = zzBuffer;
	zzEndReadL = zzEndRead;
} else {
	handleCommentStart();
	yybegin(ST_DOCBLOCK);
}
            }
          case 313: break;
          case 119: 
            { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 314: break;
          case 120: 
            { String text = yytext();

    if (text.charAt(text.length() - 2)== ';') {
		text = text.substring(0, text.length() - 2);
        yypushback(1);
    } else {
		text = text.substring(0, text.length() - 1);
    }

	int textLength = text.length();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && text.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		yypushback(2);
        yybegin(ST_END_HEREDOC);
        heredoc = null;
        // we need to remove the closing label from the symbol value.
        Symbol sym = createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
        String value = (String)sym.value;
        sym.value = value.substring(0, value.length() - heredocLength + 1);
	   	return sym;
	}
	yypushback(1);
            }
          case 315: break;
          case 121: 
            { String text = yytext();

 	if (text.charAt(text.length() - 2)== ';') {
		text = text.substring(0, text.length() - 2);
        yypushback(1);
    } else {
		text = text.substring(0, text.length() - 1);
    }

 	int textLength = text.length();
 	int nowdocLength = nowdoc.length();
	if (textLength > nowdocLength && text.substring(textLength - nowdocLength, textLength).equals(nowdoc)) {
		yypushback(2);
       	yybegin(ST_END_HEREDOC);
       	nowdoc = null;
       	// we need to remove the closing label from the symbol value.
       	Symbol sym = createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
       	String value = (String)sym.value;
       	sym.value = value.substring(0, value.length() - nowdocLength + 1);
	   	return sym;
	}
	yypushback(1);
            }
          case 316: break;
          case 122: 
            { return createSymbol(ParserConstants.T_ECHO);
            }
          case 317: break;
          case 123: 
            { return createSymbol(ParserConstants.T_ELSE);
            }
          case 318: break;
          case 124: 
            { return createSymbol(ParserConstants.T_EVAL);
            }
          case 319: break;
          case 125: 
            { return createSymbol(ParserConstants.T_CASE);
            }
          case 320: break;
          case 126: 
            { return createSymbol(ParserConstants.T_LIST);
            }
          case 321: break;
          case 127: 
            { return createSymbol(ParserConstants.T_GOTO);
            }
          case 322: break;
          case 128: 
            { handleCommentStart();
            }
          case 323: break;
          case 129: 
            { return createSymbol(ParserConstants.T_ENDIF);
            }
          case 324: break;
          case 130: 
            { return createSymbol(ParserConstants.T_EMPTY);
            }
          case 325: break;
          case 131: 
            { return createSymbol(ParserConstants.T_ARRAY);
            }
          case 326: break;
          case 132: 
            { return createSymbol(ParserConstants.T_BREAK);
            }
          case 327: break;
          case 133: 
            { return createSymbol(ParserConstants.T_ISSET);
            }
          case 328: break;
          case 134: 
            { return createSymbol(ParserConstants.T_TRAIT);
            }
          case 329: break;
          case 135: 
            { return createSymbol(ParserConstants.T_THROW);
            }
          case 330: break;
          case 136: 
            { return createSymbol(ParserConstants.T_FINAL);
            }
          case 331: break;
          case 137: 
            { return createSymbol(ParserConstants.T_UNSET);
            }
          case 332: break;
          case 138: 
            { return createSymbol(ParserConstants.T_CATCH);
            }
          case 333: break;
          case 139: 
            { return createSymbol(ParserConstants.T_CONST);
            }
          case 334: break;
          case 140: 
            { return createSymbol(ParserConstants.T_CLASS);
            }
          case 335: break;
          case 141: 
            { return createSymbol(ParserConstants.T_CLONE);
            }
          case 336: break;
          case 142: 
            { return createSymbol(ParserConstants.T_YIELD);
            }
          case 337: break;
          case 143: 
            { return createSymbol(ParserConstants.T_WHILE);
            }
          case 338: break;
          case 144: 
            { return createSymbol(ParserConstants.T_PRINT);
            }
          case 339: break;
          case 145: 
            { return createSymbol(ParserConstants.T_INT_CAST);
            }
          case 340: break;
          case 146: 
            { int removeChars = (yytext().charAt(0) == 'b') ? 4 : 3;
    String hereOrNowDoc = yytext().substring(removeChars).trim();    // for 'b<<<' or '<<<'
    int heredoc_len = hereOrNowDoc.length();

	Symbol sym = createFullSymbol(ParserConstants.T_START_HEREDOC);

    if (hereOrNowDoc.charAt(0) == '\'') {
    	nowdoc = hereOrNowDoc.substring(1, heredoc_len-1);
    	sym.value = nowdoc;
    	heredoc_len -= 2;
    	yybegin(ST_START_NOWDOC);
    }
    else if (hereOrNowDoc.charAt(0) == '"') {
    	heredoc = hereOrNowDoc.substring(1, heredoc_len-1);
    	sym.value = heredoc;
    	heredoc_len -= 2;
    	yybegin(ST_START_HEREDOC);
    } else {
    	heredoc = hereOrNowDoc;
    	sym.value = heredoc;
    	yybegin(ST_START_HEREDOC);
    }
    return sym;
            }
          case 341: break;
          case 147: 
            { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
            }
          case 342: break;
          case 148: 
            { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
            }
          case 343: break;
          case 149: 
            { return createSymbol(ParserConstants.T_ENDFOR);
            }
          case 344: break;
          case 150: 
            { return createSymbol(ParserConstants.T_ELSEIF);
            }
          case 345: break;
          case 151: 
            { /* not a keyword, hust for recognize constans.*/
    return createFullSymbol(ParserConstants.T_DEFINE);
            }
          case 346: break;
          case 152: 
            { return createSymbol(ParserConstants.T_STATIC);
            }
          case 347: break;
          case 153: 
            { return createSymbol(ParserConstants.T_SWITCH);
            }
          case 348: break;
          case 154: 
            { return createSymbol(ParserConstants.T_RETURN);
            }
          case 349: break;
          case 155: 
            { return createSymbol(ParserConstants.T_GLOBAL);
            }
          case 350: break;
          case 156: 
            { return createSymbol(ParserConstants.T_PUBLIC);
            }
          case 351: break;
          case 157: 
            { return createSymbol(ParserConstants.T_BOOL_CAST);
            }
          case 352: break;
          case 158: 
            { return createSymbol(ParserConstants.T_DOUBLE_CAST);
            }
          case 353: break;
          case 159: 
            { return createSymbol(ParserConstants.T_EXTENDS);
            }
          case 354: break;
          case 160: 
            { return createSymbol(ParserConstants.T_INCLUDE);
            }
          case 355: break;
          case 161: 
            { return createSymbol(ParserConstants.T_DEFAULT);
            }
          case 356: break;
          case 162: 
            { return createSymbol(ParserConstants.T_DECLARE);
            }
          case 357: break;
          case 163: 
            { return createSymbol(ParserConstants.T_FINALLY);
            }
          case 358: break;
          case 164: 
            { return createSymbol(ParserConstants.T_FOREACH);
            }
          case 359: break;
          case 165: 
            { return createSymbol(ParserConstants.T_REQUIRE);
            }
          case 360: break;
          case 166: 
            { return createSymbol(ParserConstants.T_PRIVATE);
            }
          case 361: break;
          case 167: 
            { return createSymbol(ParserConstants.T_ARRAY_CAST);
            }
          case 362: break;
          case 168: 
            { return createSymbol(ParserConstants.T_UNSET_CAST);
            }
          case 363: break;
          case 169: 
            { return createSymbol(ParserConstants.T_DIR);
            }
          case 364: break;
          case 170: 
            { return createSymbol(ParserConstants.T_ENDWHILE);
            }
          case 365: break;
          case 171: 
            { return createSymbol(ParserConstants.T_ABSTRACT);
            }
          case 366: break;
          case 172: 
            { return createSymbol(ParserConstants.T_FUNCTION);
            }
          case 367: break;
          case 173: 
            { return createSymbol(ParserConstants.T_CALLABLE);
            }
          case 368: break;
          case 174: 
            { return createSymbol(ParserConstants.T_CONTINUE);
            }
          case 369: break;
          case 175: 
            { return createSymbol(ParserConstants.T_STRING_CAST);
            }
          case 370: break;
          case 176: 
            { return createSymbol(ParserConstants.T_OBJECT_CAST);
            }
          case 371: break;
          case 177: 
            { return createSymbol(ParserConstants.T_FILE);
            }
          case 372: break;
          case 178: 
            { return createSymbol(ParserConstants.T_LINE);
            }
          case 373: break;
          case 179: 
            { return createSymbol(ParserConstants.T_ENDSWITCH);
            }
          case 374: break;
          case 180: 
            { return createSymbol(ParserConstants.T_INTERFACE);
            }
          case 375: break;
          case 181: 
            { return createSymbol(ParserConstants.T_INSTEADOF);
            }
          case 376: break;
          case 182: 
            { return createSymbol(ParserConstants.T_NAMESPACE);
            }
          case 377: break;
          case 183: 
            { return createSymbol(ParserConstants.T_PROTECTED);
            }
          case 378: break;
          case 184: 
            { return createSymbol(ParserConstants.T_CLASS_C);
            }
          case 379: break;
          case 185: 
            { return createSymbol(ParserConstants.T_ENDDECLARE);
            }
          case 380: break;
          case 186: 
            { return createSymbol(ParserConstants.T_ENDFOREACH);
            }
          case 381: break;
          case 187: 
            { return createSymbol(ParserConstants.T_INSTANCEOF);
            }
          case 382: break;
          case 188: 
            { return createSymbol(ParserConstants.T_IMPLEMENTS);
            }
          case 383: break;
          case 189: 
            { return createSymbol(ParserConstants.T_METHOD_C);
            }
          case 384: break;
          case 190: 
            { handleVarComment();
    //return createFullSymbol(ParserConstants.T_VAR_COMMENT);
            }
          case 385: break;
          case 191: 
            { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
            }
          case 386: break;
          case 192: 
            { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
            }
          case 387: break;
          case 193: 
            { return createSymbol(ParserConstants.T_FUNC_C);
            }
          case 388: break;
          case 194: 
            { return createSymbol(ParserConstants.T_NS_C);
            }
          case 389: break;
          case 195: 
            { return createSymbol(ParserConstants.T_HALT_COMPILER);
            }
          case 390: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java PhpAstLexer [ --encoding <name> ] <inputfile(s)>");
    }
    else {
      int firstFilePos = 0;
      String encodingName = "UTF-8";
      if (argv[0].equals("--encoding")) {
        firstFilePos = 2;
        encodingName = argv[1];
        try {
          java.nio.charset.Charset.forName(encodingName); // Side-effect: is encodingName valid? 
        } catch (Exception e) {
          System.out.println("Invalid encoding '" + encodingName + "'");
          return;
        }
      }
      for (int i = firstFilePos; i < argv.length; i++) {
        PhpAstLexer scanner = null;
        try {
          java.io.FileInputStream stream = new java.io.FileInputStream(argv[i]);
          java.io.Reader reader = new java.io.InputStreamReader(stream, encodingName);
          scanner = new PhpAstLexer(reader);
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
