/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPValue;
import org.eclipse.php.internal.debug.core.zend.model.WatchExpressionFactoryAdapter;

public class PHPVariable
extends PHPDebugElement
implements IVariable {
    private Expression variable;
    private PHPValue value;
    private boolean hasChanged = false;
    private boolean global = false;
    private String name = null;

    public PHPVariable(PHPDebugTarget target, Expression variable) {
        super(target);
        this.variable = variable;
        this.global = false;
        this.value = new PHPValue(target, variable);
        this.hasChanged = target.storeValue(variable);
    }

    public PHPVariable(PHPDebugTarget target, Expression variable, boolean global) {
        super(target);
        this.variable = variable;
        this.global = global;
        this.value = new PHPValue(target, variable, global);
        this.hasChanged = target.storeValue(variable);
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public String getName() throws DebugException {
        if (this.name == null) {
            String endName = this.variable.getLastName();
            if (this.variable.hasFacet(IVariableFacet.Facet.KIND_OBJECT_MEMBER)) {
                int idx = endName.lastIndexOf(58);
                if (idx != -1) {
                    endName = endName.substring(idx + 1);
                }
            } else if (this.variable.hasFacet(IVariableFacet.Facet.KIND_ARRAY_MEMBER)) {
                endName = String.valueOf('[') + endName + ']';
            }
            this.name = endName;
        }
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.value.getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.hasChanged;
    }

    public void setValue(String expression) throws DebugException {
        boolean status;
        PHPDebugTarget debugTarget = (PHPDebugTarget)this.getDebugTarget();
        DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
        Expression changeVar = this.variable;
        if (this.global) {
            String exp = "$GLOBALS[\"" + this.variable.getFullName().substring(1) + "\"]";
            changeVar = new DefaultExpression(exp);
        }
        if (!(status = expressionManager.assignValue(changeVar, expression, 1))) {
            Logger.debugMSG("[" + (Object)((Object)this) + "] PHPValue: Problem changing variable value");
        }
        expressionManager.update(changeVar, 1);
        this.value.updateValue(changeVar.getValue());
        this.fireChangeEvent(512);
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return !this.variable.hasFacet(IVariableFacet.Facet.MOD_STATIC) && !this.variable.hasFacet(IVariableFacet.Facet.VIRTUAL_CLASS);
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWatchExpressionFactoryAdapter.class) {
            return new WatchExpressionFactoryAdapter();
        }
        if (adapter == Expression.class || adapter == IVariableFacet.class) {
            return this.variable;
        }
        return super.getAdapter(adapter);
    }
}

