/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.VirtualPartition;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.SimpleByteValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.SimpleVariable;

public class SimpleByteArrayValue
extends DBGpElement
implements IValue {
    private byte[] value;
    private int start;
    private int end;
    private IVariable[] elements;

    public SimpleByteArrayValue(byte[] value, int start, int end, IDebugTarget debugTarget) {
        super(debugTarget);
        this.value = value;
        this.start = start;
        this.end = end;
    }

    public String getReferenceTypeName() throws DebugException {
        return "byte[]";
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.elements == null) {
            this.elements = SimpleByteArrayValue.createVariables(this.value, this.start, this.end - this.start + 1, 0, this.getDebugTarget());
        }
        return this.elements;
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public static IVariable[] createVariables(byte[] bytes, int bytePos, int byteCount, int startOffset, IDebugTarget debugTarget) {
        IVariable[] childVariables = null;
        if (byteCount > 100) {
            int split = 100;
            int children = byteCount / split;
            if (byteCount % split != 0) {
                ++children;
            }
            while (children > 100) {
                children = byteCount / (split *= 10);
                if (byteCount % split == 0) continue;
                ++children;
            }
            childVariables = new IVariable[children + startOffset];
            int rangeStart = bytePos;
            int rangeEnd = 0;
            int j = 0;
            while (j < children) {
                rangeEnd = j == children - 1 ? bytePos + byteCount - 1 : rangeStart + split - 1;
                if (rangeStart <= rangeEnd) {
                    final SimpleByteArrayValue value = new SimpleByteArrayValue(bytes, rangeStart, rangeEnd, debugTarget);
                    VirtualPartition partition = new VirtualPartition((IDebugElement)debugTarget, new VirtualPartition.IVariableProvider(){

                        @Override
                        public IVariable[] getVariables() throws DebugException {
                            return value.getVariables();
                        }
                    }, rangeStart, rangeEnd);
                    childVariables[j + startOffset] = partition;
                    rangeStart += split;
                }
                ++j;
            }
        } else {
            childVariables = new SimpleVariable[byteCount + startOffset];
            int i = 0;
            while (i < byteCount) {
                SimpleByteValue iv2 = new SimpleByteValue(bytes[bytePos + i], debugTarget);
                childVariables[i + startOffset] = new SimpleVariable(Integer.toString(bytePos + i), iv2, debugTarget, IVariableFacet.Facet.KIND_ARRAY_MEMBER);
                ++i;
            }
        }
        return childVariables;
    }
}

