/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.php.debug.ui.DebugServerConnectionTestRegistry;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsWorkingCopy;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.zend.communication.DebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.ui.wizards.IDebuggerSettingsSection;
import org.eclipse.php.internal.debug.ui.wizards.Messages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ZendDebuggerServerSettingsSection
implements IDebuggerSettingsSection {
    protected IDebuggerSettingsWorkingCopy settingsWorkingCopy;
    protected CompositeFragment compositeFragment;
    protected Composite settingsComposite;

    public ZendDebuggerServerSettingsSection(CompositeFragment compositeFragment, Composite debuggerSettingsComposite, IDebuggerSettingsWorkingCopy settingsWorkingCopy) {
        this.settingsWorkingCopy = settingsWorkingCopy;
        this.compositeFragment = compositeFragment;
        this.settingsComposite = debuggerSettingsComposite;
        this.createContents();
    }

    @Override
    public boolean performOK() {
        return true;
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public void validate() {
        this.compositeFragment.setMessage(this.compositeFragment.getDescription(), 0);
        String clientIp = this.settingsWorkingCopy.getAttribute("clientIp");
        if (clientIp == null || clientIp.isEmpty()) {
            this.compositeFragment.setMessage(Messages.ZendDebuggerServerSettingsSection_Client_IP_is_missing, 3);
            return;
        }
        String clientPort = this.settingsWorkingCopy.getAttribute("clientPort");
        if (clientPort == null || clientPort.isEmpty()) {
            this.compositeFragment.setMessage(Messages.ZendDebuggerServerSettingsSection_Client_port_is_missing, 3);
            return;
        }
        String responseTimeout = this.settingsWorkingCopy.getAttribute("responseTimeout");
        if (responseTimeout == null || responseTimeout.isEmpty()) {
            this.compositeFragment.setMessage(Messages.ZendDebuggerServerSettingsSection_Response_timeout_is_missing, 3);
            return;
        }
        int port = Integer.valueOf(clientPort);
        if (!PHPLaunchUtilities.isPortAvailable((int)port) && !PHPLaunchUtilities.isDebugDaemonActive((int)port, (String)"org.eclipse.php.debug.core.zendDebugger")) {
            this.compositeFragment.setMessage(MessageFormat.format(Messages.DebuggerCommonSettingsSection_Port_is_already_in_use, clientPort), 2);
            return;
        }
    }

    @Override
    public boolean canTest() {
        return true;
    }

    @Override
    public void performTest() {
        IDebugServerConnectionTest[] tests = DebugServerConnectionTestRegistry.getTests("org.eclipse.php.debug.core.zendDebugger");
        Server server = (Server)this.compositeFragment.getData();
        int port = ZendDebuggerSettingsUtil.getDebugPort((String)this.settingsWorkingCopy.getOwnerId());
        Set allDebugPorts = PHPDebugUtil.getDebugPorts((String)"org.eclipse.php.debug.core.zendDebugger");
        AbstractDebuggerCommunicationDaemon tmpDaemon = null;
        if (!allDebugPorts.contains(port)) {
            tmpDaemon = DebuggerCommunicationDaemon.createDaemon((int)port);
        }
        IDebugServerConnectionTest[] iDebugServerConnectionTestArray = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugServerConnectionTest test = iDebugServerConnectionTestArray[n2];
            test.testConnection(server, PlatformUI.getWorkbench().getDisplay().getActiveShell());
            ++n2;
        }
        if (tmpDaemon != null) {
            tmpDaemon.stopListen();
        }
    }

    protected void createContents() {
        Group connectionGroup = new Group(this.settingsComposite, 0);
        connectionGroup.setFont(this.compositeFragment.getFont());
        GridLayout cgLayout = new GridLayout(2, false);
        cgLayout.marginTop = 5;
        connectionGroup.setLayout((Layout)cgLayout);
        GridData cgGridData = new GridData(768);
        connectionGroup.setLayoutData((Object)cgGridData);
        connectionGroup.setText(Messages.ZendDebuggerServerSettingsSection_Connection_settings);
        Label clientIpLabel = new Label((Composite)connectionGroup, 0);
        clientIpLabel.setText(Messages.ZendDebuggerServerSettingsSection_Client_IPs);
        final Text clientIpText = new Text((Composite)connectionGroup, 2048);
        GridData citLayoutData = new GridData(768);
        clientIpText.setLayoutData((Object)citLayoutData);
        clientIpText.setText(this.settingsWorkingCopy.getAttribute("clientIp"));
        clientIpText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String clientIp = clientIpText.getText();
                ZendDebuggerServerSettingsSection.this.settingsWorkingCopy.setAttribute("clientIp", clientIp);
                ZendDebuggerServerSettingsSection.this.validate();
            }
        });
        Label clientPortLabel = new Label((Composite)connectionGroup, 0);
        clientPortLabel.setText(Messages.ZendDebuggerServerSettingsSection_Client_port);
        final Text clientPortText = new Text((Composite)connectionGroup, 2048);
        GridData cptLayoutData = new GridData(768);
        clientPortText.setLayoutData((Object)cptLayoutData);
        clientPortText.setText(this.settingsWorkingCopy.getAttribute("clientPort"));
        clientPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String port = clientPortText.getText();
                ZendDebuggerServerSettingsSection.this.settingsWorkingCopy.setAttribute("clientPort", port);
                ZendDebuggerServerSettingsSection.this.validate();
            }
        });
        Label responseTimeoutLabel = new Label((Composite)connectionGroup, 0);
        responseTimeoutLabel.setText(Messages.ZendDebuggerServerSettingsSection_Response_timeout);
        final Text responseTimeoutText = new Text((Composite)connectionGroup, 2048);
        GridData rttLayoutData = new GridData(768);
        responseTimeoutText.setLayoutData((Object)rttLayoutData);
        responseTimeoutText.setText(this.settingsWorkingCopy.getAttribute("responseTimeout"));
        responseTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String responseTimeout = responseTimeoutText.getText();
                ZendDebuggerServerSettingsSection.this.settingsWorkingCopy.setAttribute("responseTimeout", responseTimeout);
                ZendDebuggerServerSettingsSection.this.validate();
            }
        });
        this.validate();
    }
}

