/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.corext.util.Resources;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.extract.NameSuggestVisitor;

public class RefactoringUtility {
    public static Program getProgramForFile(IProject project, IFile file) throws Exception {
        ISourceModule source = DLTKCore.createSourceModuleFrom((IFile)file);
        return ASTParser.newParser((ISourceModule)source).createAST((IProgressMonitor)new NullProgressMonitor());
    }

    public static Program getProgramForFile(IFile file) throws Exception {
        return RefactoringUtility.getProgramForFile(file.getProject(), file);
    }

    public static String[] getVariableNameSuggestions(Expression assignedExpression) {
        List<Object> res = new ArrayList();
        NameSuggestVisitor visitor = new NameSuggestVisitor();
        assignedExpression.accept((Visitor)visitor);
        res = visitor.getSuggestions();
        return res.toArray(new String[res.size()]);
    }

    public static RefactoringStatus checkNewElementName(String newName) {
        if (!RefactoringUtility.isValidIdentifier(newName)) {
            return RefactoringUtility.getFatalError(newName);
        }
        return new RefactoringStatus();
    }

    public static final RefactoringStatus getFatalError(String newName) {
        return RefactoringStatus.createFatalErrorStatus((String)PhpRefactoringCoreMessages.format("RefactoringUtility.0", new Object[]{newName}));
    }

    public static final boolean isValidIdentifier(String newName) {
        if (newName == null || newName.length() == 0 || !Character.isLetter(newName.charAt(0)) && newName.charAt(0) != '_') {
            return false;
        }
        int length = newName.length();
        int i = 1;
        while (i < length) {
            if (!Character.isJavaIdentifierPart(newName.charAt(i))) {
                return false;
            }
            if (newName.charAt(i) == '$') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static RefactoringStatus validateModifiesFiles(IResource[] iResources, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])iResources);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])iResources, (Object)context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(PhpRefactoringCoreMessages.getString("ExtractVariableRefactoring.1"));
            }
        }
        return result;
    }

    public static IResource getResource(Object element) {
        if (element instanceof IPath) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)element);
        }
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof ISourceModule) {
            return ((ISourceModule)element).getPrimary().getResource();
        }
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getResource();
        }
        if (element instanceof IAdaptable) {
            return (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }

    public static IBuildpathEntry createNewBuildpathEntry(int bpeSource, IPath path) {
        switch (bpeSource) {
            case 1: {
                return DLTKCore.newLibraryEntry((IPath)path);
            }
            case 2: {
                return DLTKCore.newProjectEntry((IPath)path);
            }
            case 3: {
                return DLTKCore.newSourceEntry((IPath)path);
            }
            case 5: {
                return DLTKCore.newContainerEntry((IPath)path);
            }
            case 4: {
                return DLTKCore.newVariableEntry((IPath)path);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IBuildpathEntry createNewBuildpathEntry(IBuildpathEntry fEntryToChange, IPath path, IPath filePath, String newName) {
        switch (fEntryToChange.getEntryKind()) {
            case 1: {
                return DLTKCore.newLibraryEntry((IPath)path, (IAccessRule[])fEntryToChange.getAccessRules(), (IBuildpathAttribute[])fEntryToChange.getExtraAttributes(), (boolean)fEntryToChange.isExported(), (boolean)fEntryToChange.isExternal());
            }
            case 2: {
                return DLTKCore.newProjectEntry((IPath)path, (IAccessRule[])fEntryToChange.getAccessRules(), (boolean)fEntryToChange.combineAccessRules(), (IBuildpathAttribute[])fEntryToChange.getExtraAttributes(), (boolean)fEntryToChange.isExported());
            }
            case 3: {
                IPath[] excludes = RefactoringUtility.updatePathPatternes(fEntryToChange.getExclusionPatterns(), fEntryToChange.getPath(), filePath, newName);
                IPath[] includes = RefactoringUtility.updatePathPatternes(fEntryToChange.getInclusionPatterns(), fEntryToChange.getPath(), filePath, newName);
                return DLTKCore.newSourceEntry((IPath)path, (IPath[])includes, (IPath[])excludes, (IBuildpathAttribute[])fEntryToChange.getExtraAttributes());
            }
            case 5: {
                return DLTKCore.newContainerEntry((IPath)path, (IAccessRule[])fEntryToChange.getAccessRules(), (IBuildpathAttribute[])fEntryToChange.getExtraAttributes(), (boolean)fEntryToChange.isExported());
            }
            case 4: {
                return DLTKCore.newVariableEntry((IPath)path, (IAccessRule[])fEntryToChange.getAccessRules(), (IBuildpathAttribute[])fEntryToChange.getExtraAttributes(), (boolean)fEntryToChange.isExported());
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static IPath[] updatePathPatternes(IPath[] updatingPaths, IPath entryPath, IPath filePath, String newName) {
        IPath[] paths = updatingPaths;
        IPath relativePath = filePath.makeRelativeTo(entryPath);
        ArrayList<IPath> excludeList = new ArrayList<IPath>();
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (!relativePath.isEmpty() && relativePath.isPrefixOf(path)) {
                int mattchedPath = path.matchingFirstSegments(relativePath);
                IPath truncatedPath = path.uptoSegment(mattchedPath);
                IPath remaingPath = path.removeFirstSegments(mattchedPath);
                if (mattchedPath == 0) {
                    excludeList.add(truncatedPath.removeLastSegments(1).append(String.valueOf(newName) + "/"));
                } else {
                    excludeList.add(truncatedPath.removeLastSegments(1).append(String.valueOf(newName) + "/").append(remaingPath.toString()));
                }
            } else {
                excludeList.add(path);
            }
            ++n2;
        }
        return excludeList.toArray(new IPath[excludeList.size()]);
    }

    public static TypeDeclaration getType(ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode model = node;
        while (!(model instanceof TypeDeclaration)) {
            if (node == null) {
                return null;
            }
            ASTNode parent = model.getParent();
            if (parent == model) {
                return null;
            }
            model = parent;
            if (!(model instanceof Program)) continue;
            return null;
        }
        return (TypeDeclaration)model;
    }

    public static ISourceModule getSourceModule(IModelElement type) {
        IModelElement root = null;
        root = type;
        while (root != null && !(root instanceof ISourceModule)) {
            root = root.getParent();
        }
        if (root != null) {
            return (ISourceModule)root;
        }
        return null;
    }

    public static ASTNode getTypeOrClassInstance(ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode model = node;
        while (!(model instanceof TypeDeclaration) && !(model instanceof ClassInstanceCreation)) {
            if (node == null) {
                return null;
            }
            ASTNode parent = model.getParent();
            if (parent == model) {
                return null;
            }
            if (parent instanceof TraitUseStatement) {
                return null;
            }
            model = parent;
            if (!(model instanceof Program)) continue;
            return null;
        }
        return model;
    }
}

