/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.util.collections.BucketMap;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.changes.ProgramFileChange;
import org.eclipse.php.refactoring.core.changes.RenameBreackpointChange;
import org.eclipse.php.refactoring.core.changes.RenameConfigurationChange;
import org.eclipse.php.refactoring.core.rename.AbstraceRenameResourceProcessor;
import org.eclipse.php.refactoring.core.rename.IReferenceUpdating;
import org.eclipse.php.refactoring.core.rename.RenameClassProcessor;
import org.eclipse.php.refactoring.core.rename.logic.RenameIncludeAndClassName;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameFileProcessor
extends AbstraceRenameResourceProcessor
implements IReferenceUpdating {
    private static final String ID_RENAME_FILE = "php.refactoring.ui.rename.file";
    public static final String RENAME_FILE_PROCESSOR_NAME = PhpRefactoringCoreMessages.getString("RenameResourceProcessor.0");
    private Map<String, String> attributes = new HashMap<String, String>();
    private boolean isUpdateTextualMatches;
    private Program program;

    public RenameFileProcessor(IResource file, Program locateNode) {
        super(file);
        this.program = locateNode;
        this.attributes.put("org.eclipse.php.refactoring.core.rename.resource.needclassname", Boolean.TRUE.toString());
    }

    @Override
    public RefactoringStatus getRefactoringStatus(IFile key, Program program) {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange rootChange = new CompositeChange(RENAME_FILE_PROCESSOR_NAME);
        rootChange.markAsSynthetic();
        try {
            pm.beginTask(PhpRefactoringCoreMessages.getString("RenameFileProcessor.RenamingFile"), 100);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.getUpdateClassName() || this.getUpdateReferences()) {
                this.createRenameTextChanges(pm, rootChange);
            }
            this.createFileRenameChange(rootChange);
            if (this.getUpdateReferences()) {
                this.createRenameReferenceChanges(pm, rootChange);
                pm.worked(80);
            }
            pm.worked(20);
        }
        finally {
            pm.done();
        }
        return rootChange;
    }

    private void createRenameReferenceChanges(IProgressMonitor pm, CompositeChange rootChange) throws CoreException, OperationCanceledException {
        IPath dest = this.getNewContainerPath();
        IPath source = this.resource.getParent().getFullPath();
        String oldName = this.resource.getName();
        this.collectBrakePoint();
        if (this.fBreakpoints.getKeys().size() > 0) {
            RenameBreackpointChange breakePointchange = new RenameBreackpointChange(source, dest, oldName, this.fNewElementName, (BucketMap<IResource, IBreakpoint>)this.fBreakpoints, this.fBreakpointAttributes);
            rootChange.add((Change)breakePointchange);
        }
        RenameConfigurationChange confChange = new RenameConfigurationChange(source, dest, oldName, this.fNewElementName);
        rootChange.add((Change)confChange);
    }

    private IPath getNewContainerPath() {
        return this.resource.getFullPath().removeLastSegments(1);
    }

    private void createRenameTextChanges(IProgressMonitor pm, CompositeChange rootChange) throws CoreException, OperationCanceledException {
        String fileName = this.program.getSourceModule().getResource().getName();
        String extension = this.program.getSourceModule().getResource().getFileExtension();
        int index = fileName.indexOf("." + extension);
        String className = null;
        if (index > 0) {
            className = fileName.substring(0, index);
        }
        if (className == null) {
            return;
        }
        try {
            pm.beginTask(RenameClassProcessor.RENAME_IS_PROCESSING, 1);
            pm.setTaskName(RenameClassProcessor.CREATING_MODIFICATIONS_LABEL);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            String newElementName = this.getNewElementName();
            index = newElementName.indexOf("." + extension);
            if (index > 0) {
                newElementName = newElementName.substring(0, index);
            }
            for (Map.Entry entry : this.participantFiles.entrySet()) {
                IFile file = (IFile)entry.getKey();
                Program program = (Program)entry.getValue();
                RenameIncludeAndClassName rename = new RenameIncludeAndClassName(file, className, newElementName, this.getUpdateTextualMatches(), this.getUpdateClassName(), this.getUpdateReferences(), this.resource);
                program.accept((Visitor)rename);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                pm.worked(1);
                if (!rename.hasChanges()) continue;
                ProgramFileChange change = new ProgramFileChange(file.getName(), file, program);
                change.setEdit((TextEdit)new MultiTextEdit());
                change.setTextType("php");
                rootChange.add((Change)change);
                rename.updateChange(change);
            }
        }
        finally {
            pm.done();
        }
    }

    private void createFileRenameChange(CompositeChange rootChange) {
        RenameResourceChange rmChange = new RenameResourceChange(this.resource.getFullPath(), this.fNewElementName);
        rootChange.add((Change)rmChange);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        RefactoringStatus status = new RefactoringStatus();
        if (!this.checkReadOnlyAndNull(this.resource)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)PhpRefactoringCoreMessages.getString("RenameFileProcessor.7"), (Object)this.resource)));
        }
        super.checkInitialConditions(pm);
        return status;
    }

    private boolean checkReadOnlyAndNull(IResource currentResource) {
        if (currentResource == null) {
            return false;
        }
        return !currentResource.getResourceAttributes().isReadOnly();
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IPath sourcePath = this.resource.getFullPath().removeLastSegments(1);
        String newFilePath = String.valueOf(sourcePath.toOSString()) + File.separatorChar + this.getNewElementName();
        Object dest = sourcePath.segmentCount() < 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.getNewElementName()) : ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(newFilePath));
        if (dest.exists()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)PhpRefactoringCoreMessages.getString("RenameFileProcessor.8"), (Object)this.getNewElementName(), (Object)sourcePath.toOSString())));
        }
        return status;
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.resource};
    }

    public String getIdentifier() {
        return ID_RENAME_FILE;
    }

    public String getProcessorName() {
        return RENAME_FILE_PROCESSOR_NAME;
    }

    @Override
    public String getCurrentElementName() {
        return this.resource.getName();
    }

    @Override
    public void setUpdateRefernces(boolean update) {
        this.isUpdateReferences = update;
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public String getCurrentElementQualifier() {
        return this.resource.getName();
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.isUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.isUpdateTextualMatches = update;
    }

    @Override
    public Object getNewElement() throws CoreException {
        return null;
    }

    @Override
    public String getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    private boolean getUpdateClassName() {
        String update = this.attributes.get("org.eclipse.php.refactoring.core.rename.resource.classname");
        if (update != null) {
            return Boolean.valueOf(update);
        }
        return false;
    }

    @Override
    public void setAttribute(String attribute, String value) {
        this.attributes.put(attribute, value);
    }
}

