/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.move;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.internal.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.util.collections.BucketMap;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.RefactoringPlugin;

public class MoveUtils {
    private static final String phpunitFramework = "PHPUnit/Framework";

    private MoveUtils() {
    }

    public static String getMovedIncludedString(IFile sourceFile, IPath destinationDirectoryPath, String value, IResource[] selectedResource) {
        if (!MoveUtils.isRelativeAndExistingResource(sourceFile.getParent(), value)) {
            return value;
        }
        IPath projectPath = sourceFile.getProject().getFullPath();
        if (projectPath.isPrefixOf(destinationDirectoryPath)) {
            IPath destPath = destinationDirectoryPath;
            String destFile = sourceFile.getName();
            IResource[] iResourceArray = selectedResource;
            int n = selectedResource.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resouce = iResourceArray[n2];
                if (resouce instanceof IFolder && resouce.getProjectRelativePath().isPrefixOf(sourceFile.getProjectRelativePath())) {
                    destFile = String.valueOf(resouce.getName()) + "/" + destFile;
                    break;
                }
                ++n2;
            }
            destPath = destPath.append(destFile).removeLastSegments(1);
            Path includingPath = new Path(value);
            IPath destIncludedFilePath = sourceFile.getParent().getFullPath().append(value);
            IResource[] iResourceArray2 = selectedResource;
            int n3 = selectedResource.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resouce = iResourceArray2[n4];
                if (resouce instanceof IFile && resouce.getFullPath().equals((Object)destIncludedFilePath)) {
                    destIncludedFilePath = destPath.append(resouce.getName());
                    break;
                }
                ++n4;
            }
            String fileName = includingPath.lastSegment();
            IResource[] iResourceArray3 = selectedResource;
            int n5 = selectedResource.length;
            n3 = 0;
            while (n3 < n5) {
                IResource resouce = iResourceArray3[n3];
                if (resouce instanceof IFolder && resouce.getProjectRelativePath().isPrefixOf((IPath)includingPath)) {
                    destIncludedFilePath = destinationDirectoryPath.append(resouce.getName()).append(fileName);
                    break;
                }
                ++n3;
            }
            return destIncludedFilePath.makeRelativeTo(destPath).toString();
        }
        return value;
    }

    private static boolean isRelativeAndExistingResource(IContainer container, String value) {
        if (container != null && value != null) {
            if (!new Path(value).isAbsolute()) {
                IResource resource = container.findMember(value);
                return resource != null && resource.exists();
            }
            return false;
        }
        return false;
    }

    public static IPath getDirectoryPath(IPath filePath) {
        return filePath.removeLastSegments(1);
    }

    public static String getMovedIncludingString(IFile sourceFile, IPath destinationDirectoryPath, IFile includingFile, String value, IResource[] selectedResource) {
        return MoveUtils.getMovedIncludingString(sourceFile, MoveUtils.getDirectoryPath(sourceFile.getFullPath()), destinationDirectoryPath, includingFile, value, selectedResource);
    }

    public static String getMovedIncludingString(IFile sourceFile, IPath oldDirectoryPath, IPath destinationDirectoryPath, IFile includingFile, String value, IResource[] selectedResource) {
        IPath path;
        IPath destPath;
        IPath projectPath = sourceFile.getProject().getFullPath();
        boolean isInSaveProject = false;
        if (includingFile.getProject() == sourceFile.getProject()) {
            isInSaveProject = true;
        }
        if (projectPath.isPrefixOf(destinationDirectoryPath)) {
            Path includePath = new Path(value);
            String fileName = value;
            if (includePath.segmentCount() > 1) {
                fileName = includePath.lastSegment();
            }
            IPath includeFilePath = includingFile.getParent().getProjectRelativePath().append((IPath)includePath);
            IResource[] iResourceArray = selectedResource;
            int n = selectedResource.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resouce = iResourceArray[n2];
                if (resouce instanceof IFolder && (resouce.getProjectRelativePath().isPrefixOf((IPath)includePath) || resouce.getProjectRelativePath().isPrefixOf(includeFilePath))) {
                    fileName = String.valueOf(resouce.getName()) + "/" + fileName;
                    break;
                }
                ++n2;
            }
            IPath path2 = destinationDirectoryPath.append(fileName);
            IPath includingPath = includingFile.getParent().getFullPath();
            IResource[] iResourceArray2 = selectedResource;
            int n3 = selectedResource.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resouce = iResourceArray2[n4];
                if (resouce.getProjectRelativePath().isPrefixOf(includingPath)) {
                    includePath = destinationDirectoryPath.append(includePath.makeRelativeTo(resouce.getProjectRelativePath()));
                    break;
                }
                if (resouce.equals((Object)includingFile)) {
                    includePath = destinationDirectoryPath;
                    break;
                }
                ++n4;
            }
            if (value.startsWith("..") || value.startsWith(".")) {
                return path2.makeRelativeTo(includingPath).toOSString().replaceAll("\\\\", "/");
            }
            if (isInSaveProject) {
                return path2.makeRelativeTo(includingPath).toOSString().replaceAll("\\\\", "/");
            }
            return path2.makeRelativeTo(projectPath).toOSString().replaceAll("\\\\", "/");
        }
        IPath oldDirectory = oldDirectoryPath.removeFirstSegments(1);
        String fileName = value;
        Path includePath = new Path(value);
        if (includePath.segmentCount() > 1) {
            fileName = includePath.lastSegment();
        }
        if ((destPath = destinationDirectoryPath).isPrefixOf(path = destinationDirectoryPath.append(oldDirectory).append(fileName))) {
            if (value.startsWith("..") || value.startsWith(".")) {
                IPath includingPath = includingFile.getParent().getProjectRelativePath();
                return path.makeRelativeTo(destPath.append(includingPath)).toString().replaceAll("\\\\", "/");
            }
            return path.makeRelativeTo(destPath).toOSString().replaceAll("\\\\", "/");
        }
        return path.removeFirstSegments(1).toOSString();
    }

    public static void getAllPHPFiles(IResource[] sourceResources, Set<IFile> phpFilesSet) {
        IResource[] iResourceArray = sourceResources;
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IFile file;
                IResource current = iResourceArray[n2];
                if (current instanceof IFolder) {
                    IResource[] fldChildrens;
                    IFolder fld = (IFolder)current;
                    try {
                        fldChildrens = fld.members();
                    }
                    catch (CoreException e) {
                        RefactoringPlugin.logException("Failed getting folder children in move operation", (Exception)((Object)e));
                        break block6;
                    }
                    MoveUtils.getAllPHPFiles(fldChildrens, phpFilesSet);
                } else if (current instanceof IFile && PHPToolkitUtil.isPhpFile((IFile)(file = (IFile)current))) {
                    phpFilesSet.add(file);
                }
            }
            ++n2;
        }
    }

    public static RefactoringStatus checkMove(Collection<IFile> files, IProject srcProject, IContainer destination) {
        RefactoringStatus status = new RefactoringStatus();
        BucketMap errors = new BucketMap();
        for (IFile file : files) {
            Collection<ReferenceTree.Node> allIncludedNodes = MoveUtils.getReferencedFiles(file);
            if (allIncludedNodes == null) continue;
            for (ReferenceTree.Node node : allIncludedNodes) {
                IFile includedFile = (IFile)node.getFile().getResource();
                if (node.getFile().getParent().getElementName().equals(phpunitFramework) || files.contains(includedFile) || destination.findMember(includedFile.getProjectRelativePath()) != null) continue;
                errors.add((Object)file, (Object)includedFile);
            }
        }
        for (IFile node : errors.getKeys()) {
            status.addWarning(MessageFormat.format(PhpRefactoringCoreMessages.getString("MoveUtils.8"), node.getName()));
            for (IFile value : errors.get((Object)node)) {
                status.addWarning(MessageFormat.format(PhpRefactoringCoreMessages.getString("MoveUtils.9"), node.getProjectRelativePath().toString(), value.getProjectRelativePath().toString()));
            }
        }
        errors = new BucketMap();
        for (IFile file : files) {
            Collection<ReferenceTree.Node> allIncludingNodes = MoveUtils.getReferencingFiles(file);
            if (allIncludingNodes == null) continue;
            for (ReferenceTree.Node node : allIncludingNodes) {
                IFile includingFile = (IFile)node.getFile().getResource();
                if (files.contains(includingFile)) continue;
                errors.add((Object)file, (Object)includingFile);
            }
        }
        for (IFile node : errors.getKeys()) {
            status.addWarning(MessageFormat.format(PhpRefactoringCoreMessages.getString("MoveUtils.10"), node.getName()));
            for (IFile includingNode : errors.get((Object)node)) {
                status.addWarning(MessageFormat.format(PhpRefactoringCoreMessages.getString("MoveUtils.11"), node.getProjectRelativePath().toString(), includingNode.getProjectRelativePath().toString()));
            }
        }
        return status;
    }

    public static Collection<ReferenceTree.Node> getReferencingFiles(IFile file) {
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        return MoveUtils.getReferencingFiles(sourceModule);
    }

    public static Collection<ReferenceTree.Node> getReferencingFiles(ISourceModule sourceModule) {
        ReferenceTree tree;
        if (sourceModule != null && (tree = FileNetworkUtility.buildReferencingFilesTree((ISourceModule)sourceModule, null)) != null && tree.getRoot() != null) {
            return tree.getRoot().getChildren();
        }
        return Collections.emptyList();
    }

    public static Collection<ReferenceTree.Node> getReferencedFiles(IFile file) {
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        return MoveUtils.getReferencedFiles(sourceModule);
    }

    public static Collection<ReferenceTree.Node> getReferencedFiles(ISourceModule sourceModule) {
        ReferenceTree tree;
        if (sourceModule != null && (tree = FileNetworkUtility.buildReferencedFilesTree((ISourceModule)sourceModule, null)) != null && tree.getRoot() != null) {
            return tree.getRoot().getChildren();
        }
        return Collections.emptyList();
    }
}

