/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.ast.locator.AbstraceConciliatorTest;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PhpElementConciliatorTest
extends AbstraceConciliatorTest {
    private IProject project1;

    @Before
    public void setUp() throws Exception {
        System.setProperty("disableStartupRunner", "true");
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = this.createProject("project1");
    }

    private IFile setFileContent(String content) throws CoreException {
        IFile file = this.project1.getFile("test1.php");
        ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
        if (!file.exists()) {
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        return file;
    }

    @Test
    public void concileClassName() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class TestRenameClass{}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 13;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 7;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileClassName1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class TestRenameClass{} class TestExtendedClass extends TestRenameClass{}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 63;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileClassName2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class A{function foo(){}} class B{function bar(){}} $a = new A();$a->foo(); A::foo(); $b = new B();$b->bar();B::bar();?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 68;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 83;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileInterface() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php interface iTemplate{public function setVariable($name, $var);}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 17;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileInterface1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php interface iTemplate{public function setVariable($name, $var);} class Template implements iTemplate{  public function setVariable($name, $var){}}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 96;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)4L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileProgram() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class TestRenameClass{}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        Assert.assertEquals((long)7L, (long)PhpElementConciliator.concile((ASTNode)program));
    }

    @Test
    public void concileGlobalVar() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){  global $a; echo $a;} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 7;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 41;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 50;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileGlobalVar1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 48;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileGlobalVar2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){  global $a; echo $a;} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 41;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)1L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileFunc() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 16;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 25;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileFunc1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php function a($n){return ($n * $n);}echo a(5);?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 45;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)2L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public static function bar(){return 'bar in a class called';}}$strFN2 = foo::bar;echo bar();?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 91;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';}}$strFN2 = new foo(); $strFN2->bar()?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 99;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod3() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 96;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileMethod4() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public function bar(){return 'bar in a class called';} public function f(){$this->bar();}}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 30;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 14;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 45;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField2() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}} $cls= new foo(); $cls->f;?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 78;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileField3() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {var $f; public function f(){$this->$f;}} $cls= new foo(); $cls->f;?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 18;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileStaticField1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public static $my_static = 'foo';} echo Foo::$my_static; echo $foo->my_static?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 28;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 59;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 82;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)6L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void localVar() {
        IFile file = null;
        try {
            file = this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 46;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 33;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void localVar1() {
        IFile file = null;
        try {
            file = this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 33;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)3L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php define(\"CONSTANT\", \"Hello world.\"); echo CONSTANT; echo Constant; ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 15;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 48;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
        start = 63;
        selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstant1() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php define (\"TEST\", 1234);");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 6;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertEquals((long)5L, (long)PhpElementConciliator.concile((ASTNode)selectedNode));
    }

    @Test
    public void concileConstantExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php define (\"TEST\", 1234);");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        Assert.assertTrue((boolean)PhpElementConciliator.constantAlreadyExists((Program)program, (String)"TEST"));
    }

    @Test
    public void concileClsMemberExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<?class foo {public static function bar(){return 'bar in a class called';}}$strFN2 = foo::bar;echo bar();?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 8;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        Assert.assertTrue((boolean)(selectedNode instanceof TypeDeclaration));
        Assert.assertTrue((boolean)PhpElementConciliator.classMemeberAlreadyExists((TypeDeclaration)((TypeDeclaration)selectedNode), (String)"bar", (int)29));
    }

    @Test
    public void concileClassNameExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php class TestRenameClass{}?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        PhpElementConciliator.classNameAlreadyExists((Program)program, (String)"TestRenameClass");
    }

    @Test
    public void localVarExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = 21;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        selectedNode = selectedNode.getParent();
        Assert.assertNotNull((Object)selectedNode);
        PhpElementConciliator.localVariableAlreadyExists((FunctionDeclaration)((FunctionDeclaration)selectedNode), (String)"x");
    }

    @Test
    public void funExists1() {
        IFile file = null;
        try {
            file = this.setFileContent("<? $x = 4; function assignx () {$x = 0; echo $x;} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        PhpElementConciliator.functionAlreadyExists((Program)program, (String)"assignx");
    }

    @Test
    public void concileGlobalExists() {
        IFile file = null;
        try {
            file = this.setFileContent("<?php $a = 1;  function test(){ echo $GLOBALS['a'];} ?>");
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)file);
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        Assert.assertTrue((boolean)PhpElementConciliator.globalVariableAlreadyExists((Program)program, (String)"a"));
    }
}

