/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.typeinference;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.ContextFinder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class TypeInferenceTests {
    protected static final int ENGINE_TIMEOUT = 100000;
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private PHPTypeInferencer typeInferenceEngine;
    private IProject project;
    private PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/typeinference/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/typeinference/php5"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/typeinference/php5", "/workspace/typeinference/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/typeinference/php5", "/workspace/typeinference/php54", "/workspace/typeinference/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/typeinference/php5", "/workspace/typeinference/php54", "/workspace/typeinference/php55", "/workspace/typeinference/php56"});
    }

    public TypeInferenceTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("TypeInferenceTests_" + this.version.toString());
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        PHPCoreTests.setProjectPhpVersion(this.project, this.version);
        this.typeInferenceEngine = new PHPTypeInferencer();
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
        this.typeInferenceEngine = null;
    }

    @Test
    public void inference(String fileName) throws Exception {
        PdttFile pdttFile = new PdttFile(fileName);
        String pruner = TypeInferenceTests.getPrunerType(pdttFile);
        String criteriaFunction = new File(fileName).getName().replaceAll("\\.pdtt", "");
        String code = pdttFile.getFile();
        IEvaluatedType evaluatedType = this.findEvaluatedType(code, criteriaFunction, pruner);
        Assert.assertNotNull((String)("Can't evaluate type for: " + code), (Object)evaluatedType);
        Assert.assertEquals((Object)pdttFile.getExpected().trim(), (Object)evaluatedType.getTypeName().trim());
    }

    private static String getPrunerType(PdttFile pdttFile) {
        Map<String, String> config = pdttFile.getConfig();
        return config.get("prune");
    }

    protected IEvaluatedType findEvaluatedType(String code, String criteriaFunction, String pruner) throws Exception {
        ExpressionTypeGoal goal;
        IFile file;
        block15: {
            block14: {
                IEvaluatedType iEvaluatedType;
                file = this.project.getFile("dummy.php");
                if (file.exists()) {
                    file.setContents((InputStream)new ByteArrayInputStream(code.getBytes()), true, false, null);
                } else {
                    file.create((InputStream)new ByteArrayInputStream(code.getBytes()), true, null);
                }
                try {
                    this.project.build(6, null);
                    PHPCoreTests.waitForIndexer();
                    PHPCoreTests.waitForAutoBuild();
                    ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
                    ModuleDeclaration moduleDecl = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                    ASTNodeSearcher searcher = new ASTNodeSearcher(sourceModule, criteriaFunction);
                    moduleDecl.traverse((ASTVisitor)searcher);
                    Assert.assertNotNull((String)("Method call " + criteriaFunction + "() in code: " + code), (Object)searcher.getResult());
                    Assert.assertNotNull((String)("Can't find context for " + criteriaFunction + "() in code: " + code), (Object)searcher.getContext());
                    goal = new ExpressionTypeGoal(searcher.getContext(), searcher.getResult());
                    if (!"phpdocGoals".equals(pruner)) break block14;
                    iEvaluatedType = this.typeInferenceEngine.evaluateTypeHeavy((AbstractTypeGoal)goal, 100000);
                }
                catch (Throwable throwable) {
                    try {
                        file.delete(true, null);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    file.delete(true, null);
                }
                catch (Exception exception) {}
                return iEvaluatedType;
            }
            if (!"heavyGoals".equals(pruner)) break block15;
            IEvaluatedType iEvaluatedType = this.typeInferenceEngine.evaluateTypePHPDoc((AbstractTypeGoal)goal, 100000);
            try {
                file.delete(true, null);
            }
            catch (Exception exception) {}
            return iEvaluatedType;
        }
        IEvaluatedType iEvaluatedType = this.typeInferenceEngine.evaluateType((AbstractTypeGoal)goal, 100000);
        try {
            file.delete(true, null);
        }
        catch (Exception exception) {}
        return iEvaluatedType;
    }

    class ASTNodeSearcher
    extends ContextFinder {
        private IContext context;
        private ASTNode result;
        private String criteriaFunction;

        public ASTNodeSearcher(ISourceModule sourceModule, String criteriaFunction) {
            super(sourceModule);
            this.criteriaFunction = criteriaFunction;
        }

        public boolean visit(Expression node) throws Exception {
            CallExpression callExpression;
            if (node instanceof CallExpression && this.criteriaFunction.equals((callExpression = (CallExpression)node).getName())) {
                this.result = (ASTNode)callExpression.getArgs().getChilds().get(0);
                this.context = (IContext)this.contextStack.peek();
                return false;
            }
            return true;
        }

        public ASTNode getResult() {
            return this.result;
        }

        public IContext getContext() {
            return this.context;
        }
    }
}

