/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.runner;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.php.core.tests.runner.AbstractPDTTRunner;
import org.eclipse.php.internal.core.PHPVersion;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;

public class PDTTList
extends AbstractPDTTRunner {
    private Map<PHPVersion, String[]> parameters;
    private String[] dirs;
    private boolean isRecursive = false;
    private boolean isArray = false;
    private FakeFlatRunner flatRunner = null;

    public PDTTList(Class<?> klass) throws Throwable {
        super(klass);
        this.readParameters();
        if (this.isArray) {
            this.buildFlatRunners();
        } else {
            this.buildRunners();
        }
    }

    private void buildFlatRunners() throws Throwable {
        String[] fileList = this.buildFileList(this.dirs);
        this.flatRunner = new FakeFlatRunner(this.getTestClass().getJavaClass(), fileList);
        String[] stringArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String fName = stringArray[n2];
            this.runners.add(new SimpleFileRunner(this.flatRunner, fName));
            ++n2;
        }
    }

    private void buildRunners() throws Throwable {
        for (Map.Entry<PHPVersion, String[]> entry : this.parameters.entrySet()) {
            this.runners.add(new PHPVersionRunner(this.getTestClass().getJavaClass(), entry.getKey(), entry.getValue()));
        }
    }

    private void readParameters() throws Exception {
        for (FrameworkField field : this.getTestClass().getAnnotatedFields(Parameters.class)) {
            if (!field.isPublic() || !field.isPublic()) continue;
            if (field.getType().isAssignableFrom(Map.class)) {
                this.parameters = (Map)field.getField().get(null);
            } else {
                if (!field.getType().isAssignableFrom(String[].class)) continue;
                this.dirs = (String[])field.getField().get(null);
                this.isArray = true;
            }
            Annotation[] annotationArray = field.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                if (ann instanceof Parameters) {
                    this.isRecursive = ((Parameters)ann).recursive();
                }
                ++n2;
            }
            return;
        }
        throw new Exception(String.valueOf(this.getTestClass().getName()) + ": Public static Map<PHPVersion, String[]>|String[] field with @Parameters is required");
    }

    protected Statement withAfterClasses(Statement statement) {
        if (this.flatRunner != null) {
            return this.flatRunner.withAfterClasses(statement);
        }
        return super.withAfterClasses(statement);
    }

    protected Statement withBeforeClasses(Statement statement) {
        if (this.flatRunner != null) {
            return this.flatRunner.withBeforeClasses(statement);
        }
        return super.withBeforeClasses(statement);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface AfterList {
    }

    public class AfterStatement
    extends Statement {
        private final Statement fBefore;
        private final List<FrameworkMethod> fAfters;
        private final Object fTest;

        public AfterStatement(Statement before, List<FrameworkMethod> afters, Object test) {
            this.fBefore = before;
            this.fAfters = afters;
            this.fTest = test;
        }

        /*
         * Unable to fully structure code
         */
        public void evaluate() throws Throwable {
            block14: {
                block13: {
                    errors = new LinkedList<Throwable>();
                    try {
                        try {
                            this.fBefore.evaluate();
                            break block13;
                        }
                        catch (Throwable e) {
                            errors.add(e);
                            ** for (after : this.fAfters)
                        }
                    }
                    catch (Throwable var3_12) {
                        ** for (after : this.fAfters)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            after.invokeExplosively(this.fTest, new Object[0]);
                        }
                        catch (Throwable e) {
                            errors.add(e);
                        }
                        continue;
lbl18:
                        // 1 sources

                        break block14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            after.invokeExplosively(this.fTest, new Object[0]);
                        }
                        catch (Throwable e) {
                            errors.add(e);
                        }
                        continue;
                    }
lbl29:
                    // 1 sources

                    throw var3_12;
                }
                for (FrameworkMethod after : this.fAfters) {
                    try {
                        after.invokeExplosively(this.fTest, new Object[0]);
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                }
            }
            MultipleFailureException.assertEmpty(errors);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BeforeList {
    }

    public class BeforeStatement
    extends Statement {
        private final Statement fNext;
        private final List<FrameworkMethod> fBefores;
        private final Object fTest;

        public BeforeStatement(Statement next, List<FrameworkMethod> befores, Object test) {
            this.fNext = next;
            this.fBefores = befores;
            this.fTest = test;
        }

        public void evaluate() throws Throwable {
            for (FrameworkMethod before : this.fBefores) {
                before.invokeExplosively(this.fTest, new Object[0]);
            }
            this.fNext.evaluate();
        }
    }

    private class DirRunner
    extends ParentRunner {
        private final String fTestName;
        private final PHPVersion fPHPVersion;

        public DirRunner(Class<?> klass, PHPVersion phpVersion, String dir, String testName) throws Throwable {
            super(klass);
            this.fTestName = testName;
            this.fPHPVersion = phpVersion;
            String[] stringArray = this.fFileList = PDTTList.this.buildFileList(new String[]{dir});
            int n = this.fFileList.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                this.runners.add(new FileTestClassRunner(this, fileName));
                ++n2;
            }
            Enumeration entryPaths = PDTTList.this.getBundle().getEntryPaths(dir);
            Bundle bundle = PDTTList.this.getBundle();
            if (entryPaths != null) {
                while (entryPaths.hasMoreElements()) {
                    String path = (String)entryPaths.nextElement();
                    if (!path.endsWith("/")) continue;
                    String namePath = path.substring(0, path.length() - 1);
                    int pos = namePath.lastIndexOf(47);
                    String name = pos >= 0 ? namePath.substring(pos + 1) : namePath;
                    try {
                        bundle.getEntry(path);
                        this.runners.add(new DirRunner(klass, phpVersion, path, name));
                    }
                    catch (Exception exception) {}
                }
            }
        }

        protected String getName() {
            return this.fTestName;
        }

        @Override
        protected Object[] getConstructorArgs() {
            return new Object[]{this.fPHPVersion, this.fFileList};
        }
    }

    private class FakeFlatRunner
    extends ParentRunner {
        public FakeFlatRunner(Class<?> klass, String[] fileList) throws Exception {
            super(klass);
            this.fFileList = fileList;
        }

        @Override
        protected Object[] getConstructorArgs() {
            return new Object[]{this.fFileList};
        }
    }

    private class FileTestClassRunner
    extends BlockJUnit4ClassRunner {
        private final String fName;
        private final int fIndex;
        private final ParentRunner fParentRunner;

        public FileTestClassRunner(ParentRunner parentRunner, String name) throws InitializationError {
            super(parentRunner.getTestClass().getJavaClass());
            this.fName = name;
            this.fIndex = PDTTList.this.counter++;
            this.fParentRunner = parentRunner;
        }

        protected String getName() {
            return this.fName;
        }

        protected String testName(FrameworkMethod method) {
            return String.valueOf(method.getName()) + '[' + this.fIndex + ']';
        }

        protected void validateConstructor(List<Throwable> errors) {
            Class javaClass = this.getTestClass().getJavaClass();
            if (javaClass.getConstructors().length != 1) {
                errors.add(new Exception("Only one constructor is allowed!"));
                return;
            }
            Constructor<?> constructor = javaClass.getConstructors()[0];
            if (constructor.getParameterTypes().length != 2 || !constructor.getParameterTypes()[0].isAssignableFrom(PHPVersion.class) || !constructor.getParameterTypes()[1].isAssignableFrom(String[].class)) {
                errors.add(new Exception("Public constructor with phpVersion and String[] argument is required"));
            }
        }

        protected Object createTest() throws Exception {
            return this.fParentRunner.createTestInstance();
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }

        protected void validateTestMethods(List<Throwable> errors) {
            for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(Test.class)) {
                method.validatePublicVoid(false, errors);
                Class<?>[] types = method.getMethod().getParameterTypes();
                if (types.length == 0 || types.length == 1 && types[0].isAssignableFrom(String.class)) continue;
                errors.add(new Exception(String.valueOf(method.toString()) + ": Dirs list must by empty or one string"));
            }
        }

        protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    if (method.getMethod().getParameterTypes().length == 0) {
                        method.invokeExplosively(test, new Object[0]);
                    } else {
                        method.invokeExplosively(test, new Object[]{FileTestClassRunner.this.fName});
                    }
                }
            };
        }

        protected Description describeChild(FrameworkMethod method) {
            return Description.createTestDescription((String)this.getTestClass().getName(), (String)(String.valueOf(method.getName()) + '[' + this.fName + ']'), (Serializable)((Object)(String.valueOf(this.getTestClass().getName()) + '#' + this.fName + this.fIndex)));
        }
    }

    private class PHPVersionRunner
    extends ParentRunner {
        private final PHPVersion fPHPVersion;

        public PHPVersionRunner(Class<?> klass, PHPVersion phpVersion, String[] dirs) throws Throwable {
            super(klass);
            this.fPHPVersion = phpVersion;
            if (PDTTList.this.isRecursive) {
                String[] stringArray = dirs;
                int n = dirs.length;
                int n2 = 0;
                while (n2 < n) {
                    String dirName = stringArray[n2];
                    this.runners.add(new DirRunner(klass, phpVersion, dirName, dirName));
                    ++n2;
                }
            } else {
                String[] stringArray = this.fFileList = PDTTList.this.buildFileList(dirs);
                int n = this.fFileList.length;
                int n3 = 0;
                while (n3 < n) {
                    String fileName = stringArray[n3];
                    this.runners.add(new FileTestClassRunner(this, fileName));
                    ++n3;
                }
            }
        }

        protected String getName() {
            return this.fPHPVersion.toString();
        }

        protected Statement classBlock(RunNotifier notifier) {
            Statement statement = this.childrenInvoker(notifier);
            if (!PDTTList.this.isRecursive) {
                statement = this.withBeforeClasses(statement);
                statement = this.withAfterClasses(statement);
            }
            return statement;
        }

        protected void collectInitializationErrors(List<Throwable> errors) {
            super.collectInitializationErrors(errors);
            this.validatePublicVoidWithNoArguments(BeforeList.class, errors);
            this.validatePublicVoidWithNoArguments(AfterList.class, errors);
        }

        protected void validatePublicVoidWithNoArguments(Class<? extends Annotation> clazz, List<Throwable> errors) {
            for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(clazz)) {
                if (!method.isPublic() || method.isStatic()) {
                    errors.add(new Exception("Method have to be public not static"));
                }
                if (method.getMethod().getParameterTypes().length == 0) continue;
                errors.add(new Exception("Method must be without arguments"));
            }
        }

        @Override
        protected Object[] getConstructorArgs() {
            return new Object[]{this.fPHPVersion, this.fFileList};
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameters {
        public boolean recursive() default false;
    }

    private abstract class ParentRunner
    extends Suite {
        protected final List<Runner> runners;
        protected Object testInstance;
        protected String[] fFileList;

        public ParentRunner(Class<?> klass) throws Exception {
            super(klass, EMPTY_RUNNERS);
            this.runners = new LinkedList<Runner>();
            this.fFileList = new String[0];
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }

        protected abstract Object[] getConstructorArgs();

        protected Object createTestInstance() {
            if (this.testInstance == null) {
                try {
                    this.testInstance = this.getTestClass().getOnlyConstructor().newInstance(this.getConstructorArgs());
                }
                catch (Exception exception) {
                    System.out.println("This is not possible!");
                }
            }
            return this.testInstance;
        }

        protected List<Runner> getChildren() {
            return this.runners;
        }

        protected Statement withBeforeClasses(Statement statement) {
            List annotatedMethods = this.getTestClass().getAnnotatedMethods(BeforeList.class);
            if (this.fFileList.length > 0 && !annotatedMethods.isEmpty()) {
                statement = new BeforeStatement(statement, annotatedMethods, this.createTestInstance());
            }
            return super.withBeforeClasses(statement);
        }

        protected Statement withAfterClasses(Statement statement) {
            statement = super.withAfterClasses(statement);
            List annotatedMethods = this.getTestClass().getAnnotatedMethods(AfterList.class);
            if (this.fFileList.length > 0 && !annotatedMethods.isEmpty()) {
                statement = new AfterStatement(statement, annotatedMethods, this.createTestInstance());
            }
            return statement;
        }
    }

    private class SimpleFileRunner
    extends FileTestClassRunner {
        public SimpleFileRunner(ParentRunner parentRunner, String name) throws InitializationError {
            super(parentRunner, name);
        }

        @Override
        protected void validateConstructor(List<Throwable> errors) {
            Class javaClass = this.getTestClass().getJavaClass();
            if (javaClass.getConstructors().length != 1) {
                errors.add(new Exception("Only one constructor is allowed!"));
                return;
            }
            Constructor<?> constructor = javaClass.getConstructors()[0];
            if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].isAssignableFrom(String[].class)) {
                errors.add(new Exception("Public constructor with String[] argument is required"));
            }
        }
    }
}

