/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.codeassist;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.codeassist.CodeAssistPdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class CodeAssistTests {
    protected static final char OFFSET_CHAR = '|';
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile;
    protected List<IFile> otherFiles = null;
    protected PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/codeassist/php5/exclusive", "/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive", "/workspace/codeassist/php53/exclusive", "/workspace/codeassist/php53/classExclusive", "/workspace/codeassist/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php5/classExclusive", "/workspace/codeassist/php53", "/workspace/codeassist/php53/classExclusive", "/workspace/codeassist/php54", "/workspace/codeassist/php54/classExclusive"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/codeassist/php5", "/workspace/codeassist/php53", "/workspace/codeassist/php54", "/workspace/codeassist/php55", "/workspace/codeassist/php56"});
    }

    public CodeAssistTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("CodeAssistTests_" + this.version.toString());
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        PHPCoreTests.setProjectPhpVersion(this.project, this.version);
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            ResourcesPlugin.getWorkspace().getDescription().setAutoBuilding(false);
        }
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            ResourcesPlugin.getWorkspace().getDescription().setAutoBuilding(true);
        }
    }

    @Test
    public void assist(String fileName) throws Exception {
        CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(fileName);
        pdttFile.applyPreferences();
        CompletionProposal[] proposals = this.getProposals(pdttFile.getFile(), pdttFile.getOtherFiles());
        CodeAssistTests.compareProposals(proposals, pdttFile);
    }

    @After
    public void after() throws Exception {
        if (this.testFile != null) {
            this.testFile.delete(true, null);
            this.testFile = null;
        }
        if (this.otherFiles != null) {
            for (IFile file : this.otherFiles) {
                if (file == null) continue;
                file.delete(true, null);
            }
            this.otherFiles = null;
        }
    }

    protected int createFile(String data, String[] otherFiles) throws Exception {
        int offset = data.lastIndexOf(124);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        this.testFile = this.project.getFile("test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.otherFiles = new ArrayList<IFile>(otherFiles.length);
        int i = 0;
        String[] stringArray = otherFiles;
        int n = otherFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String otherFileContent = stringArray[n2];
            IFile tmp = this.project.getFile(String.format("test%s.php", i));
            tmp.create((InputStream)new ByteArrayInputStream(otherFileContent.getBytes()), true, null);
            this.otherFiles.add(i, tmp);
            ++i;
            ++n2;
        }
        this.project.refreshLocal(2, null);
        this.testFile.touch((IProgressMonitor)new NullProgressMonitor());
        this.project.build(10, null);
        PHPCoreTests.waitForIndexer();
        return offset;
    }

    protected ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }

    public CompletionProposal[] getProposals(String data, String[] otherFiles) throws Exception {
        int offset = this.createFile(data, otherFiles);
        return this.getProposals(offset);
    }

    public CompletionProposal[] getProposals(int offset) throws ModelException {
        return CodeAssistTests.getProposals(this.getSourceModule(), offset);
    }

    public static CompletionProposal[] getProposals(ISourceModule sourceModule, int offset) throws ModelException {
        final LinkedList proposals = new LinkedList();
        sourceModule.codeComplete(offset, new CompletionRequestor(){

            public void accept(CompletionProposal proposal) {
                proposals.add(proposal);
            }
        });
        return proposals.toArray(new CompletionProposal[proposals.size()]);
    }

    public static void compareProposals(CompletionProposal[] proposals, CodeAssistPdttFile pdttFile) throws Exception {
        int n;
        CodeAssistPdttFile.ExpectedProposal[] expectedProposals = pdttFile.getExpectedProposals();
        boolean proposalsEqual = true;
        if (proposals.length == expectedProposals.length) {
            CodeAssistPdttFile.ExpectedProposal[] expectedProposalArray = pdttFile.getExpectedProposals();
            n = expectedProposalArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeAssistPdttFile.ExpectedProposal expectedProposal = expectedProposalArray[n2];
                boolean found = false;
                CompletionProposal[] completionProposalArray = proposals;
                int n3 = proposals.length;
                int n4 = 0;
                while (n4 < n3) {
                    CompletionProposal proposal = completionProposalArray[n4];
                    IModelElement modelElement = proposal.getModelElement();
                    if (modelElement == null) {
                        if (new String(proposal.getName()).equalsIgnoreCase(expectedProposal.name)) {
                            found = true;
                            break;
                        }
                    } else if (modelElement.getElementType() == expectedProposal.type) {
                        if (modelElement instanceof AliasType) {
                            if (((AliasType)modelElement).getAlias().equals(expectedProposal.name)) {
                                found = true;
                                break;
                            }
                        } else if (modelElement instanceof FakeConstructor && modelElement.getParent() instanceof AliasType) {
                            if (((AliasType)modelElement.getParent()).getAlias().equals(expectedProposal.name)) {
                                found = true;
                                break;
                            }
                        } else if (modelElement.getElementName().equalsIgnoreCase(expectedProposal.name)) {
                            found = true;
                            break;
                        }
                    } else if (modelElement.getElementType() == expectedProposal.type && new String(proposal.getName()).equalsIgnoreCase(expectedProposal.name)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    proposalsEqual = false;
                    break;
                }
                ++n2;
            }
        } else {
            proposalsEqual = false;
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
            errorBuf.append(pdttFile.getExpected());
            errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
            CompletionProposal[] completionProposalArray = proposals;
            int n5 = proposals.length;
            n = 0;
            while (n < n5) {
                CompletionProposal p = completionProposalArray[n];
                IModelElement modelElement = p.getModelElement();
                if (modelElement == null || modelElement.getElementName() == null) {
                    errorBuf.append("keyword(").append(p.getName()).append(")\n");
                } else {
                    switch (modelElement.getElementType()) {
                        case 8: {
                            errorBuf.append("field");
                            break;
                        }
                        case 9: {
                            errorBuf.append("method");
                            break;
                        }
                        case 7: {
                            errorBuf.append("type");
                        }
                    }
                    if (modelElement instanceof AliasType) {
                        errorBuf.append('(').append(((AliasType)modelElement).getAlias()).append(")\n");
                    } else {
                        errorBuf.append('(').append(modelElement.getElementName()).append(")\n");
                    }
                }
                ++n;
            }
            Assert.fail((String)errorBuf.toString());
        }
    }
}

