/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.codeassist;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.tests.AbstractProjectSuite;
import org.eclipse.php.core.tests.codeassist.CodeAssistPdttFile;
import org.eclipse.php.core.tests.codeassist.CodeAssistTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class CodeAssistProjectTests
extends AbstractProjectSuite {
    private static final String PROJECT_BASE = "codeassist_prj";
    protected static final Map<String, PHPVersion> TEST_DIRS = new HashMap<String, PHPVersion>();
    private String projectName;
    private PHPVersion phpVersion;

    static {
        TEST_DIRS.put("php5", PHPVersion.PHP5);
        TEST_DIRS.put("php53", PHPVersion.PHP5_3);
    }

    public CodeAssistProjectTests(String projectName, PHPVersion phpVersion) {
        super(projectName);
        this.projectName = projectName;
        this.phpVersion = phpVersion;
    }

    @Override
    public File getSourceWorkspacePath() {
        return new File(super.getSourceWorkspacePath(), PROJECT_BASE);
    }

    public void run(final TestResult result) {
        Protectable p = new Protectable(){

            public void protect() throws Exception {
                CodeAssistProjectTests.this.setUpSuite();
                CodeAssistProjectTests.super.run(result);
                CodeAssistProjectTests.this.tearDownSuite();
            }
        };
        result.runProtected((Test)this, p);
    }

    public void setUpSuite() throws Exception {
        this.deleteProject(this.projectName);
        IScriptProject project = this.setUpScriptProject(this.projectName);
        ProjectOptions.setPhpVersion((PHPVersion)this.phpVersion, (IProject)project.getProject());
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(this.projectName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Code Assist Project Tests");
        for (final String testProject : TEST_DIRS.keySet()) {
            PHPVersion phpVersion = TEST_DIRS.get(testProject);
            CodeAssistProjectTests projectTests = new CodeAssistProjectTests(testProject, phpVersion);
            File[] fileArray = new File(projectTests.getSourceWorkspacePath(), testProject).listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                final File file = fileArray[n2];
                String baseName = file.getName();
                if (baseName.toLowerCase().endsWith(".pdtt")) {
                    try {
                        projectTests.addTest((Test)new TestCase("/" + testProject + "/" + baseName){

                            protected void runTest() throws Throwable {
                                CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(file.getAbsolutePath());
                                String data = pdttFile.getFile();
                                int offset = data.lastIndexOf(124);
                                if (offset == -1) {
                                    throw new IllegalArgumentException("Offset character is not set");
                                }
                                data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
                                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(testProject);
                                IFile workspaceFile = project.getFile("test.php");
                                if (workspaceFile.exists()) {
                                    workspaceFile.setContents((InputStream)new ByteArrayInputStream(data.getBytes()), 1, null);
                                } else {
                                    workspaceFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
                                }
                                CodeAssistProjectTests.waitUntilIndexesReady();
                                ISourceModule sourceModule = (ISourceModule)DLTKCore.create((IFile)workspaceFile);
                                CompletionProposal[] proposals = CodeAssistTests.getProposals(sourceModule, offset);
                                CodeAssistTests.compareProposals(proposals, pdttFile);
                            }
                        });
                    }
                    catch (Exception e) {
                        projectTests.addTest((Test)new TestCase(baseName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                }
                ++n2;
            }
            suite.addTest((Test)projectTests);
        }
        return suite;
    }
}

