/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.format;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Node;

public class PHPFormatProcessorProxy
implements IStructuredFormatProcessor {
    private static final String FORMATTER_POINT = "org.eclipse.php.ui.phpFormatterProcessor";
    private static final String FORMATTER_PROCESSOR = "processor";
    private static final String CLASS_ATTR = "class";
    private static final String PHP_FORMATTER_PROCESSORS_POINT = "org.eclipse.php.ui.phpFormatterProcessor";
    private static IConfigurationElement phpFormatterElement;
    private static String phpFormatterClassName;
    private static IContentFormatter phpFormatter;

    static {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui.phpFormatterProcessor");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            if (FORMATTER_PROCESSOR.equals(name)) {
                phpFormatterClassName = element.getAttribute(CLASS_ATTR);
                phpFormatterElement = element;
            }
            ++n2;
        }
    }

    public static IContentFormatter getFormatter() {
        if (phpFormatter == null && phpFormatterElement != null) {
            try {
                phpFormatter = (IContentFormatter)phpFormatterElement.createExecutableExtension(CLASS_ATTR);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (phpFormatter == null) {
            phpFormatter = new MultiPassContentFormatter("org.eclipse.wst.sse.core.default_structured_text_partitioning", "org.eclipse.wst.html.HTML_DEFAULT");
        }
        return phpFormatter;
    }

    public void formatDocument(IDocument document, int start, int length) throws IOException, CoreException {
        Region region = new Region(start, length);
        PHPFormatProcessorProxy.getFormatter().format(document, (IRegion)region);
    }

    public void formatFile(IFile file) throws IOException, CoreException {
        IStructuredDocument document = null;
        IStructuredModel structuredModel = null;
        try {
            try {
                if (file != null && file.exists()) {
                    structuredModel = StructuredModelManager.getModelManager().getModelForRead(file);
                    document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                }
                if (document != null) {
                    Region region = new Region(0, document.getLength());
                    IContentFormatter formatter = PHPFormatProcessorProxy.getFormatter();
                    if (formatter != null) {
                        formatter.format((IDocument)document, (IRegion)region);
                    }
                }
            }
            catch (Exception e) {
                PHPCorePlugin.log((Throwable)e);
                if (structuredModel != null) {
                    structuredModel.save();
                    structuredModel.releaseFromRead();
                }
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.save();
                structuredModel.releaseFromRead();
            }
        }
    }

    public void formatModel(IStructuredModel structuredModel) {
        IStructuredDocument document = structuredModel.getStructuredDocument();
        IContentFormatter formatter = PHPFormatProcessorProxy.getFormatter();
        if (formatter != null) {
            formatter.format((IDocument)document, (IRegion)new Region(0, document.getLength()));
        }
    }

    public void formatModel(IStructuredModel structuredModel, int start, int length) {
        IStructuredDocument document = structuredModel.getStructuredDocument();
        Region region = new Region(start, length);
        IContentFormatter formatter = PHPFormatProcessorProxy.getFormatter();
        if (formatter != null) {
            formatter.format((IDocument)document, (IRegion)region);
        }
    }

    public void formatNode(Node node) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

