/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.wizards.FragmentedWizard;
import org.eclipse.php.internal.ui.wizards.IWizardHandle;
import org.eclipse.php.internal.ui.wizards.Messages;
import org.eclipse.php.internal.ui.wizards.WizardFragment;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FragmentedWizardPage
extends WizardPage
implements IWizardHandle {
    protected WizardFragment fragment;
    protected boolean isEmptyError = false;

    public FragmentedWizardPage(WizardFragment fragment) {
        super(fragment.toString());
        this.fragment = fragment;
    }

    public void createControl(Composite parentComp) {
        Composite comp = null;
        try {
            comp = this.fragment.createComposite(parentComp, this);
        }
        catch (Exception e) {
            PHPUiPlugin.log((IStatus)new Status(2, "org.eclipse.php.ui", 0, "Could not create wizard page composite", (Throwable)e));
        }
        if (comp == null) {
            comp = new Composite(parentComp, 0);
            comp.setLayout((Layout)new FillLayout(512));
            Label label = new Label(comp, 0);
            label.setText(Messages.FragmentedWizardPage_0);
        }
        GridData data = new GridData(256);
        data.widthHint = this.convertHorizontalDLUsToPixels(150);
        comp.setLayoutData((Object)data);
        this.setControl((Control)comp);
    }

    public boolean isPageComplete() {
        try {
            return this.fragment.isComplete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canFlipToNextPage() {
        if (this.getNextPage() == null) {
            return false;
        }
        try {
            return this.fragment.isComplete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            FragmentedWizard wizard = (FragmentedWizard)this.getWizard();
            wizard.switchWizardFragment(this.fragment);
            if (this.getContainer().getCurrentPage() != null) {
                this.getContainer().updateButtons();
            }
        }
    }

    @Override
    public void setMessage(String message, int type) {
        if (type == 3 && "".equals(message)) {
            this.isEmptyError = true;
            message = null;
        } else {
            this.isEmptyError = false;
        }
        super.setMessage(message, type);
        WizardFragment frag = ((FragmentedWizard)this.getWizard()).getCurrentWizardFragment();
        if (!this.fragment.equals(frag)) {
            return;
        }
        this.getContainer().updateButtons();
    }

    @Override
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InterruptedException, InvocationTargetException {
        this.getWizard().getContainer().run(fork, cancelable, runnable);
    }

    @Override
    public void update() {
        this.fragment.updateChildFragments();
        ((FragmentedWizard)this.getWizard()).updatePages();
        final IWizardContainer container = this.getContainer();
        if (container.getCurrentPage() != null) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    container.updateButtons();
                }
            });
        }
    }
}

