/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class StatusLineMessageTimerManager {
    static String message;
    static boolean isError;
    static IStatusLineManager statusLineManager;

    static {
        statusLineManager = null;
    }

    static IStatusLineManager getStatusLineManager() {
        return PHPUiPlugin.getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager();
    }

    static void setMessage(String newMessage, boolean newIsError) {
        message = newMessage;
        isError = newIsError;
        if (isError) {
            statusLineManager.setErrorMessage(message);
            Display.getCurrent().beep();
        } else {
            statusLineManager.setMessage(message);
        }
    }

    public static void setErrorMessage(String message, long timeout, boolean isError) {
        statusLineManager = StatusLineMessageTimerManager.getStatusLineManager();
        StatusLineMessageTimerManager.setMessage(message, isError);
        MessageTimerTask task = new MessageTimerTask(statusLineManager, message, isError);
        new Timer().schedule((TimerTask)task, timeout);
    }

    static class MessageTimerTask
    extends TimerTask {
        String message;
        boolean isError;
        IStatusLineManager statusLineManager;

        public MessageTimerTask(IStatusLineManager statusLineManager, String message, boolean isError) {
            this.message = message;
            this.isError = isError;
            this.statusLineManager = statusLineManager;
        }

        @Override
        public void run() {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (StatusLineMessageTimerManager.statusLineManager == MessageTimerTask.this.statusLineManager && MessageTimerTask.this.message == StatusLineMessageTimerManager.message) {
                        if (MessageTimerTask.this.isError) {
                            StatusLineMessageTimerManager.statusLineManager.setErrorMessage("");
                        } else {
                            StatusLineMessageTimerManager.statusLineManager.setMessage("");
                        }
                    }
                }
            });
        }
    }
}

