/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.internal.ui.util.ScrolledPageContent;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class TypingConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private final PreferencePage fMainPreferencePage;
    private String autoIndentDetails = "";
    private Link formatterPageLink;
    private final Map<Button, String> fCheckBoxes = new HashMap<Button, String>();
    private final SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            TypingConfigurationBlock.this.fStore.setValue((String)TypingConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private final ArrayList<SelectionListener> fMasterSlaveListeners = new ArrayList();
    protected static final int INDENT = 20;
    private final Map<Text, String> fTextFields = new HashMap<Text, String>();

    public TypingConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        Assert.isNotNull((Object)mainPreferencePage);
        Assert.isNotNull((Object)store);
        this.fMainPreferencePage = mainPreferencePage;
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fStore = store;
    }

    @Override
    public void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        for (Map.Entry<Button, String> entry : this.fCheckBoxes.entrySet()) {
            entry.getKey().setSelection(this.fStore.getBoolean(entry.getValue()));
        }
        for (Map.Entry<Button, String> entry : this.fTextFields.entrySet()) {
            ((Text)entry.getKey()).setText(this.fStore.getString(entry.getValue()));
        }
        for (SelectionListener selectionListener : this.fMasterSlaveListeners) {
            selectionListener.widgetSelected(null);
        }
        this.updateStatus(new StatusInfo());
    }

    protected void updateStatus(IStatus status) {
        if (this.fMainPreferencePage == null) {
            return;
        }
        this.fMainPreferencePage.setValid(status.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, status);
    }

    @Override
    public void performOk() {
    }

    @Override
    public void performDefaults() {
        this.initializeFields();
    }

    @Override
    public void dispose() {
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "closeStrings"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "closeBraces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "closeBrackets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "closePhpDocsAndComments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "autoAddPhpDocTags"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "smart_tab"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "autoAddPhpCloseTags"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "autoAddPhpForPhpStartTags"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "smartPaste"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    @Override
    public Control createControl(Composite parent) {
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite control = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout();
        control.setLayout((Layout)layout);
        Composite autoCloseComposite = this.createSubsection(control, PHPUIMessages.typingPage_autoClose_title);
        this.addAutoclosingSection(autoCloseComposite);
        Composite smartPasteSection = this.createSubsection(control, PHPUIMessages.typingPage_smartPaste_title);
        this.addSmartPasteSection(smartPasteSection);
        Composite smartTabSection = this.createSubsection(control, PHPUIMessages.typingPage_smartTab_title);
        this.addSmartTabSection(smartTabSection);
        scrolled.setContent((Control)control);
        Point size = control.computeSize(-1, -1);
        scrolled.setMinSize(size.x, size.y);
        return scrolled;
    }

    private void addSmartPasteSection(Composite smartPasteComposite) {
        GridLayout layout = new GridLayout();
        smartPasteComposite.setLayout((Layout)layout);
        String label = PHPUIMessages.PHPEditorPreferencePage_typing_smartPaste;
        this.addCheckBox(smartPasteComposite, label, "smartPaste", 0);
    }

    private void addSmartTabSection(Composite smartTabComposite) {
        GridLayout layout = new GridLayout();
        smartTabComposite.setLayout((Layout)layout);
        String label = PHPUIMessages.PHPEditorPreferencePage_typing_smartTab;
        this.addCheckBox(smartTabComposite, label, "smart_tab", 0);
        this.createAutoIndentMessage(smartTabComposite);
    }

    private void createAutoIndentMessage(Composite composite) {
        String linkTooltip = PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_tooltip;
        char indentChar = FormatterUtils.getFormatterCommonPrferences().getIndentationChar(null);
        if (indentChar == '\t') {
            this.autoIndentDetails = Messages.format(PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_tab_text, new String[]{Integer.toString(4)});
        } else {
            int indentSize = FormatterUtils.getFormatterCommonPrferences().getIndentationSize(null);
            this.autoIndentDetails = Messages.format(PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_others_text, new String[]{Integer.toString(4), Integer.toString(indentSize), "space"});
        }
        this.formatterPageLink = new Link(composite, 0);
        this.formatterPageLink.setText(this.autoIndentDetails);
        this.formatterPageLink.setToolTipText(linkTooltip);
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 300;
        this.formatterPageLink.setLayoutData((Object)gd);
        this.formatterPageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)TypingConfigurationBlock.this.formatterPageLink.getShell(), (String)"org.eclipse.php.ui.preferences.PHPFormatterPreferencePage", null, null);
            }
        });
    }

    private Composite createSubsection(Composite parent, String label) {
        Group group = new Group(parent, 32);
        group.setText(label);
        GridData data = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)data);
        return group;
    }

    private void addAutoclosingSection(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        String label = PHPUIMessages.typingPage_autoClose_string;
        this.addCheckBox(composite, label, "closeStrings", 0);
        label = PHPUIMessages.typingPage_autoClose_brackets;
        this.addCheckBox(composite, label, "closeBrackets", 0);
        label = PHPUIMessages.typingPage_autoClose_braces;
        this.addCheckBox(composite, label, "closeBraces", 0);
        label = PHPUIMessages.typingPage_autoClose_phpDoc_and_commens;
        Button master = this.addCheckBox(composite, label, "closePhpDocsAndComments", 0);
        label = PHPUIMessages.typingPage_autoAdd_phpDoc_tags;
        Button slave = this.addCheckBox(composite, label, "autoAddPhpDocTags", 0);
        label = PHPUIMessages.typingPage_autoAdd_phpClose_tags;
        this.addCheckBox(composite, label, "autoAddPhpCloseTags", 0);
        label = PHPUIMessages.typingPage_autoAdd_php_for_phpstart_tags;
        this.addCheckBox(composite, label, "autoAddPhpForPhpStartTags", 0);
        this.createDependency(master, (Control)slave);
    }

    protected Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.makeScrollableCompositeAware((Control)checkBox);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected final ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected void createDependency(Button master, Control slave) {
        this.createDependency(master, new Control[]{slave});
    }

    protected void createDependency(final Button master, final Control[] slaves) {
        Assert.isTrue((slaves.length > 0 ? 1 : 0) != 0);
        TypingConfigurationBlock.indent(slaves[0]);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = master.getSelection();
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(state);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    protected static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    public void refreshValues() {
        char indentChar = FormatterUtils.getFormatterCommonPrferences().getIndentationChar(null);
        if (indentChar == '\t') {
            this.autoIndentDetails = Messages.format(PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_tab_text, new String[]{Integer.toString(4)});
        } else {
            int indentSize = FormatterUtils.getFormatterCommonPrferences().getIndentationSize(null);
            this.autoIndentDetails = Messages.format(PHPUIMessages.SmartTypingConfigurationBlock_tabs_message_others_text, new String[]{Integer.toString(4), Integer.toString(indentSize), "space"});
        }
        this.formatterPageLink.setText(this.autoIndentDetails);
    }
}

