/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.NewPHPManualSiteDialog;
import org.eclipse.php.internal.ui.preferences.PHPManualConfig;
import org.eclipse.php.internal.ui.preferences.PHPManualConfigSerializer;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.php.internal.ui.util.PHPManualSiteDescriptor;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class PHPManualConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_DEFAULT = 4;
    public static final String PREFERENCES_DELIMITER = new String(new char[]{'\u0005'});
    private IStatus fPHPManualStatus;
    private ListDialogField<PHPManualConfig> fPHPManualButtonsList;
    private PreferencePage fMainPreferencePage;
    private OverlayPreferenceStore fStore;
    private Map<Button, String> fCheckBoxes = new HashMap<Button, String>();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            PHPManualConfigurationBlock.this.fStore.setValue((String)PHPManualConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            PHPManualConfigurationBlock.this.fStore.setValue((String)PHPManualConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    protected boolean isDefault(PHPManualConfig element) {
        return this.fPHPManualButtonsList.getIndexOfElement(element) == 0;
    }

    protected void setToDefault(PHPManualConfig element) {
        List<PHPManualConfig> elements = this.fPHPManualButtonsList.getElements();
        elements.remove(element);
        elements.add(0, element);
        this.fPHPManualButtonsList.setElements(elements);
        this.fPHPManualButtonsList.enableButton(4, false);
    }

    public PHPManualConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        Assert.isNotNull((Object)mainPreferencePage);
        Assert.isNotNull((Object)store);
        this.fMainPreferencePage = mainPreferencePage;
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "phpManualSite"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "phpManualSites"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "phpManualOpenInNewBrowser"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    @Override
    public Control createControl(Composite parent) {
        PHPManualAdapter adapter = new PHPManualAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = PHPUIMessages.PHPManualConfigurationBlock_new;
        stringArray[1] = PHPUIMessages.PHPManualConfigurationBlock_edit;
        stringArray[2] = PHPUIMessages.PHPManualConfigurationBlock_remove;
        stringArray[4] = PHPUIMessages.PHPManualConfigurationBlock_default;
        String[] buttons = stringArray;
        this.fPHPManualButtonsList = new ListDialogField(adapter, buttons, (ILabelProvider)new PHPManualLabelProvider());
        this.fPHPManualButtonsList.setDialogFieldListener(adapter);
        this.fPHPManualButtonsList.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{PHPUIMessages.PHPManualConfigurationBlock_siteName, PHPUIMessages.PHPManualConfigurationBlock_url, PHPUIMessages.PHPManualConfigurationBlock_fileExtension};
        this.fPHPManualButtonsList.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.fPHPManualButtonsList.setViewerSorter(new PHPManualSorter());
        if (this.fPHPManualButtonsList.getSize() > 0) {
            this.fPHPManualButtonsList.selectFirstElement();
        } else {
            this.fPHPManualButtonsList.enableButton(1, false);
            this.fPHPManualButtonsList.enableButton(4, false);
        }
        this.fPHPManualStatus = new StatusInfo();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)parent);
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(parent, 768);
        Composite composite = new Composite((Composite)scrolledCompositeImpl, 0);
        composite.setLayout((Layout)layout);
        scrolledCompositeImpl.setContent((Control)composite);
        scrolledCompositeImpl.setLayout((Layout)layout);
        scrolledCompositeImpl.setFont(parent.getFont());
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.fPHPManualButtonsList.getListControl(composite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.fPHPManualButtonsList.getButtonBox(composite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        this.addCheckBox(composite, PHPUIMessages.PHPManualConfigurationBlock_openInNewBrowser, "phpManualOpenInNewBrowser", 0);
        this.addFiller(composite);
        Point size = composite.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(size.x, size.y);
        return scrolledCompositeImpl;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        checkBox.setSelection(this.fStore.getBoolean(key));
        return checkBox;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    protected void sideButtonPressed(int index) {
        if (index == 0) {
            NewPHPManualSiteDialog dialog = new NewPHPManualSiteDialog(this.fMainPreferencePage.getShell(), null, this.fPHPManualButtonsList.getElements());
            if (dialog.open() == 0) {
                this.fPHPManualButtonsList.addElement(dialog.getResult());
            }
        } else if (index == 1) {
            PHPManualConfig edited = this.fPHPManualButtonsList.getSelectedElements().get(0);
            NewPHPManualSiteDialog dialog = new NewPHPManualSiteDialog(this.fMainPreferencePage.getShell(), edited, this.fPHPManualButtonsList.getElements());
            if (dialog.open() == 0 && dialog.getResult() != null) {
                this.fPHPManualButtonsList.replaceElement(edited, dialog.getResult());
            }
        } else if (index == 4) {
            this.setToDefault(this.fPHPManualButtonsList.getSelectedElements().get(0));
        }
    }

    protected void updateStatus() {
        this.fMainPreferencePage.setValid(this.fPHPManualStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, this.fPHPManualStatus);
    }

    @Override
    public void initialize() {
        ArrayList<PHPManualConfig> configs = new ArrayList<PHPManualConfig>();
        PHPManualConfigurationBlock.initFromExtensions(configs);
        PHPManualConfigurationBlock.initFromPreferences((IPreferenceStore)this.fStore, configs);
        this.fPHPManualButtonsList.setElements(configs);
        PHPManualConfig defaultConfig = PHPManualConfigurationBlock.getActiveManualSite((IPreferenceStore)this.fStore, configs);
        if (defaultConfig != null) {
            this.setToDefault(defaultConfig);
        }
        for (Map.Entry<Button, String> entry : this.fCheckBoxes.entrySet()) {
            entry.getKey().setSelection(this.fStore.getBoolean(entry.getValue()));
        }
    }

    public static void initFromExtensions(List<PHPManualConfig> configs) {
        PHPManualSiteDescriptor[] descs = PHPUiPlugin.getDefault().getPHPManualSiteDescriptors();
        int i = 0;
        while (i < descs.length) {
            configs.add(new PHPManualConfig(descs[i].getLabel(), descs[i].getURL(), descs[i].getExtension(), true));
            ++i;
        }
    }

    public static void initFromPreferences(IPreferenceStore store, List<PHPManualConfig> configs) {
        String storedConfigsString = store.getString("phpManualSites");
        if (storedConfigsString != null && !"".equals(storedConfigsString)) {
            PHPManualConfig config;
            StringTokenizer sitesTokenizer = new StringTokenizer(storedConfigsString, PREFERENCES_DELIMITER);
            while ((config = PHPManualConfigSerializer.fromStringTokenizer(sitesTokenizer)) != null) {
                boolean alreadyExists = false;
                int i = 0;
                while (i < configs.size()) {
                    PHPManualConfig existing = configs.get(i);
                    if (existing.equals(config)) {
                        alreadyExists = true;
                    }
                    ++i;
                }
                if (alreadyExists) continue;
                configs.add(config);
            }
        }
    }

    public static PHPManualConfig getActiveManualSite(IPreferenceStore store, List<PHPManualConfig> configs) {
        String storedConfigString = store.getString("phpManualSite");
        if (storedConfigString != null && !"".equals(storedConfigString)) {
            PHPManualConfig config = PHPManualConfigSerializer.fromString(storedConfigString);
            for (PHPManualConfig other : configs) {
                if (!config.equals(other)) continue;
                return other;
            }
            return config;
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void performDefaults() {
        this.initialize();
        this.updateStatus();
    }

    @Override
    public void performOk() {
        StringBuffer sitesBuffer = new StringBuffer();
        List<PHPManualConfig> elements = this.fPHPManualButtonsList.getElements();
        if (elements != null && elements.size() > 0) {
            for (PHPManualConfig config : elements) {
                if (config.isContributed()) continue;
                if (sitesBuffer.length() != 0) {
                    sitesBuffer.append(PREFERENCES_DELIMITER);
                }
                sitesBuffer.append(PHPManualConfigSerializer.toString(config));
            }
            this.fStore.setValue("phpManualSites", sitesBuffer.toString());
            this.fStore.setValue("phpManualSite", PHPManualConfigSerializer.toString(elements.get(0)));
        }
    }

    private class PHPManualAdapter
    implements IListAdapter<PHPManualConfig>,
    IDialogFieldListener {
        private PHPManualAdapter() {
        }

        private boolean canEdit(List<PHPManualConfig> selectedElements) {
            return selectedElements.size() == 1 && !selectedElements.get(0).isContributed();
        }

        private boolean canRemove(List<PHPManualConfig> selectedElements) {
            for (PHPManualConfig element : selectedElements) {
                if (!element.isContributed()) continue;
                return false;
            }
            return true;
        }

        private boolean canSetToDefault(List<PHPManualConfig> selectedElements) {
            return selectedElements.size() == 1 && !PHPManualConfigurationBlock.this.isDefault(selectedElements.get(0));
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField<PHPManualConfig> field, int index) {
            PHPManualConfigurationBlock.this.sideButtonPressed(index);
        }

        @Override
        public void doubleClicked(ListDialogField<PHPManualConfig> field) {
            if (this.canEdit(field.getSelectedElements())) {
                PHPManualConfigurationBlock.this.sideButtonPressed(1);
            }
        }

        @Override
        public void selectionChanged(ListDialogField<PHPManualConfig> field) {
            List<PHPManualConfig> selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
            field.enableButton(4, this.canSetToDefault(selectedElements));
            field.enableButton(2, this.canRemove(selectedElements));
        }
    }

    private class PHPManualLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private PHPManualLabelProvider() {
        }

        public Font getFont(Object element) {
            if (PHPManualConfigurationBlock.this.isDefault((PHPManualConfig)element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((PHPManualConfig)element).getLabel();
            }
            if (columnIndex == 1) {
                return ((PHPManualConfig)element).getUrl();
            }
            if (columnIndex == 2) {
                return ((PHPManualConfig)element).getExtension();
            }
            return null;
        }
    }

    private class PHPManualSorter
    extends ViewerSorter {
        private PHPManualSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.collator.compare(((PHPManualConfig)e1).getLabel(), ((PHPManualConfig)e2).getLabel());
        }
    }
}

