/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.phar.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.phar.wizard.IPharBuilder;
import org.eclipse.php.internal.ui.phar.wizard.IPharExportRunnable;
import org.eclipse.php.internal.ui.phar.wizard.PharExportHelper;
import org.eclipse.php.internal.ui.phar.wizard.PharPackagerMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class PharFileExportOperation
extends WorkspaceModifyOperation
implements IPharExportRunnable {
    private IPharBuilder fJarBuilder;
    private PharPackage fJarPackage;
    private PharPackage[] fJarPackages;
    private Shell fParentShell;
    private MessageMultiStatus fStatus;
    private Set<IResource> resourceSet = new HashSet<IResource>();

    public PharFileExportOperation(PharPackage jarPackage, Shell parent) {
        this(new PharPackage[]{jarPackage}, parent);
    }

    public PharFileExportOperation(PharPackage[] jarPackages, Shell parent) {
        this(parent);
        this.fJarPackages = jarPackages;
    }

    private PharFileExportOperation(Shell parent) {
        this.fParentShell = parent;
        this.fStatus = new MessageMultiStatus(PHPUiPlugin.getPluginId(), 0, "", null);
    }

    private void addToStatus(CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            message = "";
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), message, (Throwable)ex);
        }
        this.fStatus.add(status);
    }

    protected void addInfo(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(1, PHPUiPlugin.getPluginId(), 10001, message, error));
    }

    private void addWarning(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(2, PHPUiPlugin.getPluginId(), 10001, message, error));
    }

    private void addError(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 10001, message, error));
    }

    private int countSelectedElements() {
        HashSet<IScriptProject> enclosingJavaProjects = new HashSet<IScriptProject>(10);
        int count = 0;
        int n = this.fJarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            block6: {
                IResource resource;
                block5: {
                    Object element;
                    block4: {
                        element = this.fJarPackage.getElements()[i];
                        IScriptProject javaProject = this.getEnclosingJavaProject(element);
                        if (javaProject != null) {
                            enclosingJavaProjects.add(javaProject);
                        }
                        resource = null;
                        if (!(element instanceof IModelElement)) break block4;
                        IModelElement je = (IModelElement)element;
                        resource = je.getResource();
                        if (resource != null) break block5;
                        break block6;
                    }
                    if (element instanceof IResource) {
                        resource = (IResource)element;
                    }
                }
                if (resource != null) {
                    count = resource.getType() == 1 ? ++count : (count += this.getTotalChildCount((IContainer)resource));
                }
            }
            ++i;
        }
        return count;
    }

    private int getTotalChildCount(IContainer container) {
        IResource[] members;
        try {
            members = container.members();
        }
        catch (CoreException coreException) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < members.length) {
            count = members[i].getType() == 1 ? ++count : (count += this.getTotalChildCount((IContainer)members[i]));
            ++i;
        }
        return count;
    }

    private void exportElement(Object element, IProgressMonitor progressMonitor) throws InterruptedException {
        int leadSegmentsToRemove = 1;
        IProjectFragment pkgRoot = null;
        boolean isInJavaProject = false;
        IResource resource = null;
        IScriptProject jProject = null;
        if (element instanceof IModelElement) {
            isInJavaProject = true;
            IModelElement je = (IModelElement)element;
            jProject = je.getScriptProject();
            try {
                pkgRoot = jProject.getProjectFragment(je.getCorrespondingResource());
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            resource = je.getResource();
        } else if (element instanceof IResource) {
            resource = (IResource)element;
        } else {
            return;
        }
        if (!resource.isAccessible()) {
            this.addWarning("", null);
            return;
        }
        if (!isInJavaProject) {
            try {
                isInJavaProject = resource.getProject().hasNature("org.eclipse.php.core.PHPNature");
            }
            catch (CoreException ex) {
                this.addWarning("", ex);
                return;
            }
            if (isInJavaProject) {
                jProject = DLTKCore.create((IProject)resource.getProject());
                try {
                    IProjectFragment pkgFragment = jProject.findProjectFragment(resource.getFullPath().removeLastSegments(1));
                    pkgRoot = pkgFragment != null ? pkgFragment : this.findPackageFragmentRoot(jProject, resource.getFullPath().removeLastSegments(1));
                }
                catch (ModelException ex) {
                    this.addWarning("", ex);
                    return;
                }
            }
        }
        if (pkgRoot != null && jProject != null) {
            leadSegmentsToRemove = pkgRoot.getPath().segmentCount();
            boolean isOnBuildPath = jProject.isOnBuildpath(resource);
            if (!isOnBuildPath || !pkgRoot.getElementName().equals("")) {
                --leadSegmentsToRemove;
            }
        }
        IPath destinationPath = resource.getFullPath().removeFirstSegments(leadSegmentsToRemove);
        if (resource.getType() == 1) {
            this.exportResource(progressMonitor, resource, destinationPath);
            progressMonitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
        } else {
            if (this.fJarPackage.areDirectoryEntriesIncluded()) {
                this.exportResource(progressMonitor, resource, destinationPath.append(File.separator));
                progressMonitor.worked(1);
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
            }
            this.exportContainer(progressMonitor, (IContainer)resource);
        }
    }

    private void exportContainer(IProgressMonitor progressMonitor, IContainer container) throws InterruptedException {
        IResource[] children = null;
        try {
            children = container.members();
        }
        catch (CoreException exception) {
            this.addWarning("", exception);
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                this.exportElement(child, progressMonitor);
                ++i;
            }
        }
    }

    private IProjectFragment findPackageFragmentRoot(IScriptProject jProject, IPath path) throws ModelException {
        if (jProject == null || path == null || path.segmentCount() <= 0) {
            return null;
        }
        IProjectFragment pkgRoot = jProject.findProjectFragment(path);
        if (pkgRoot != null) {
            return pkgRoot;
        }
        return this.findPackageFragmentRoot(jProject, path.removeLastSegments(1));
    }

    private void exportResource(IProgressMonitor progressMonitor, IResource resource, IPath destinationPath) {
        try {
            if (resource instanceof IFile) {
                progressMonitor.subTask("");
                this.fJarBuilder.writeFile((IFile)resource, destinationPath);
            } else {
                progressMonitor.subTask("");
                this.fJarBuilder.writeFile((IFolder)resource, destinationPath);
            }
        }
        catch (CoreException ex) {
            this.handleCoreExceptionOnExport(ex);
        }
    }

    private void exportSelectedElements(IProgressMonitor progressMonitor) throws InterruptedException {
        int n = this.fJarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            Object element = this.fJarPackage.getElements()[i];
            this.exportElement(element, progressMonitor);
            ++i;
        }
    }

    private IScriptProject getEnclosingJavaProject(Object element) {
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getScriptProject();
        }
        if (element instanceof IResource) {
            IProject project = ((IResource)element).getProject();
            try {
                if (project.hasNature("org.eclipse.php.core.PHPNature")) {
                    return DLTKCore.create((IProject)project);
                }
            }
            catch (CoreException ex) {
                this.addWarning("", ex);
            }
        }
        return null;
    }

    private void handleCoreExceptionOnExport(CoreException ex) {
        Throwable realEx = ex.getStatus().getException();
        if (realEx instanceof IOException && realEx.getMessage() != null && realEx.getMessage().startsWith("duplicate entry:")) {
            this.addWarning(ex.getMessage(), realEx);
        } else {
            this.addToStatus(ex);
        }
    }

    @Override
    public IStatus getStatus() {
        String message = null;
        switch (this.fStatus.getSeverity()) {
            case 0: {
                message = PharPackagerMessages.PharFileExportOperation_10;
                break;
            }
            case 1: {
                message = PharPackagerMessages.PharFileExportOperation_11;
                break;
            }
            case 2: {
                message = PharPackagerMessages.PharFileExportOperation_12;
                break;
            }
            case 4: {
                if (this.fJarPackages.length > 1) {
                    message = PharPackagerMessages.PharFileExportOperation_13;
                    break;
                }
                message = PharPackagerMessages.PharFileExportOperation_13;
                break;
            }
            default: {
                message = "";
            }
        }
        this.fStatus.setMessage(message);
        return this.fStatus;
    }

    protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        int count = this.fJarPackages.length;
        progressMonitor.beginTask("", count);
        try {
            int i = 0;
            while (i < count) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 1, 4);
                this.fJarPackage = this.fJarPackages[i];
                if (this.fJarPackage != null) {
                    this.singleRun((IProgressMonitor)subProgressMonitor);
                }
                ++i;
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private void singleRun(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                if (!this.preconditionsOK()) {
                    throw new InvocationTargetException(null, "");
                }
                int totalWork = this.countSelectedElements();
                progressMonitor.beginTask("", totalWork);
                this.fJarBuilder = PharExportHelper.createPlainPharBuilder(this.fJarPackage);
                this.fJarBuilder.open(this.fJarPackage, this.fParentShell, this.fStatus);
                this.fJarBuilder.writeStub(this.fJarBuilder.getStubProvider().create(this.fJarPackage), progressMonitor);
                this.exportSelectedElements(progressMonitor);
                this.fJarBuilder.writeSignature(progressMonitor);
            }
            catch (CoreException ex) {
                this.addToStatus(ex);
                try {
                    if (this.fJarBuilder != null) {
                        this.fJarBuilder.close();
                    }
                }
                catch (CoreException ex2) {
                    this.addToStatus(ex2);
                }
                progressMonitor.done();
            }
        }
        finally {
            try {
                if (this.fJarBuilder != null) {
                    this.fJarBuilder.close();
                }
            }
            catch (CoreException ex) {
                this.addToStatus(ex);
            }
            progressMonitor.done();
        }
    }

    private boolean preconditionsOK() {
        if (this.fJarPackage.getElements() == null || this.fJarPackage.getElements().length == 0) {
            this.addError(PharPackagerMessages.JarFileExportOperation_noResourcesSelected, null);
            return false;
        }
        if (this.fJarPackage.getAbsolutePharLocation() == null) {
            this.addError(PharPackagerMessages.JarFileExportOperation_invalidJarLocation, null);
            return false;
        }
        File targetFile = this.fJarPackage.getAbsolutePharLocation().toFile();
        if (targetFile.exists() && !targetFile.canWrite()) {
            this.addError(PharPackagerMessages.JarFileExportOperation_jarFileExistsAndNotWritable, null);
            return false;
        }
        if (!this.fJarPackage.isStubAccessible()) {
            this.addError(PharPackagerMessages.JarFileExportOperation_manifestDoesNotExist, null);
            return false;
        }
        return true;
    }

    private static class MessageMultiStatus
    extends MultiStatus {
        MessageMultiStatus(String pluginId, int code, String message, Throwable exception) {
            super(pluginId, code, message, exception);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }
    }
}

