/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.php.internal.core.ast.match.PHPASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.ui.corext.dom.fragments.ASTFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.php.internal.ui.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.php.internal.ui.corext.dom.fragments.IASTFragment;
import org.eclipse.text.edits.TextEditGroup;

class SimpleFragment
extends ASTFragment {
    private final ASTNode fNode;

    SimpleFragment(ASTNode node) {
        Assert.isNotNull((Object)node);
        this.fNode = node;
    }

    @Override
    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode node) {
        if (!PHPASTMatcher.doNodesMatch((ASTNode)this.getAssociatedNode(), (ASTNode)node)) {
            return new IASTFragment[0];
        }
        IASTFragment match = ASTFragmentFactory.createFragmentForFullSubtree(node, this);
        Assert.isTrue((match.matches(this) || this.matches(match) ? 1 : 0) != 0);
        return new IASTFragment[]{match};
    }

    @Override
    public boolean matches(IASTFragment other) {
        return other.getClass().equals(this.getClass()) && PHPASTMatcher.doNodesMatch((ASTNode)other.getAssociatedNode(), (ASTNode)this.getAssociatedNode());
    }

    @Override
    public IASTFragment[] getSubFragmentsMatching(IASTFragment toMatch) {
        return ASTMatchingFragmentFinder.findMatchingFragments(this.getAssociatedNode(), (ASTFragment)toMatch);
    }

    @Override
    public int getStartPosition() {
        return this.fNode.getStart();
    }

    @Override
    public int getLength() {
        return this.fNode.getLength();
    }

    @Override
    public ASTNode getAssociatedNode() {
        return this.fNode;
    }

    @Override
    public void replace(ASTRewrite rewrite, ASTNode replacement, TextEditGroup textEditGroup) {
        if (replacement instanceof Identifier && this.fNode.getParent() instanceof ParenthesisExpression) {
            rewrite.replace(this.fNode.getParent(), replacement, textEditGroup);
        } else {
            rewrite.replace(this.fNode, replacement, textEditGroup);
        }
    }

    public int hashCode() {
        return this.fNode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleFragment other = (SimpleFragment)obj;
        return this.fNode.equals(other.fNode);
    }
}

