/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.visitor.HierarchicalVisitor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.ui.corext.dom.fragments.AssociativeInfixExpressionFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.IASTFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.IExpressionFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.SimpleExpressionFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.SimpleFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.Util;

public class ASTFragmentFactory {
    public static IASTFragment createFragmentForSourceRange(SourceRange range, ASTNode scope, IDocument document) throws Exception {
        SelectionAnalyzer sa = new SelectionAnalyzer(Selection.createFromStartLength((int)range.getOffset(), (int)range.getLength()), false);
        scope.accept((Visitor)sa);
        if (ASTFragmentFactory.isSingleNodeSelected(sa, (ISourceRange)range, document, scope)) {
            return ASTFragmentFactory.createFragmentForFullSubtree(sa.getFirstSelectedNode(), null);
        }
        if (ASTFragmentFactory.isEmptySelectionCoveredByANode((ISourceRange)range, sa)) {
            return ASTFragmentFactory.createFragmentForFullSubtree(sa.getLastCoveringNode(), null);
        }
        return ASTFragmentFactory.createFragmentForSubPartBySourceRange(sa.getLastCoveringNode(), (ISourceRange)range, scope, document);
    }

    private static IASTFragment createFragmentForSubPartBySourceRange(ASTNode node, ISourceRange range, ASTNode scope, IDocument document) throws Exception {
        return FragmentForSubPartBySourceRangeFactory.createFragmentFor(node, range, scope, document);
    }

    private static boolean isEmptySelectionCoveredByANode(ISourceRange range, SelectionAnalyzer sa) {
        return range.getLength() == 0 && sa.getFirstSelectedNode() == null && sa.getLastCoveringNode() != null;
    }

    private static boolean isSingleNodeSelected(SelectionAnalyzer sa, ISourceRange range, IDocument document, ASTNode scope) throws BadLocationException {
        return sa.getSelectedNodes().length == 1 && !ASTFragmentFactory.rangeIncludesNonWhitespaceOutsideNode(range, sa.getFirstSelectedNode(), document, scope);
    }

    private static boolean rangeIncludesNonWhitespaceOutsideNode(ISourceRange range, ASTNode node, IDocument document, ASTNode scope) throws BadLocationException {
        return Util.rangeIncludesNonWhitespaceOutsideRange(range, (ISourceRange)new SourceRange(node.getStart(), node.getLength()), document);
    }

    public static IASTFragment createFragmentForFullSubtree(ASTNode node, IASTFragment astFragment) {
        IASTFragment result = FragmentForFullSubtreeFactory.createFragmentFor(node, astFragment);
        Assert.isNotNull((Object)result);
        return result;
    }

    public static IASTFragment createFragmentForFullSubtree(ASTNode node) {
        return ASTFragmentFactory.createFragmentForFullSubtree(node, null);
    }

    private static abstract class FragmentFactory
    extends HierarchicalVisitor {
        private IASTFragment fFragment;
        protected IASTFragment oldFragment;

        private FragmentFactory() {
        }

        protected IASTFragment createFragment(ASTNode node, IASTFragment astFragment) {
            this.oldFragment = astFragment;
            this.fFragment = null;
            node.accept((Visitor)this);
            return this.fFragment;
        }

        protected final IASTFragment getFragment() {
            return this.fFragment;
        }

        protected final void setFragment(IASTFragment fragment) {
            Assert.isTrue((!this.isFragmentSet() ? 1 : 0) != 0);
            this.fFragment = fragment;
        }

        protected final void clearFragment() {
            this.fFragment = null;
        }

        protected final boolean isFragmentSet() {
            return this.getFragment() != null;
        }
    }

    private static class FragmentForFullSubtreeFactory
    extends FragmentFactory {
        private FragmentForFullSubtreeFactory() {
        }

        public static IASTFragment createFragmentFor(ASTNode node, IASTFragment astFragment) {
            return new FragmentForFullSubtreeFactory().createFragment(node, astFragment);
        }

        public boolean visit(InfixExpression node) {
            IExpressionFragment fragment = AssociativeInfixExpressionFragment.createFragmentForFullSubtree(node);
            if (fragment == null) {
                return this.visit((Expression)node);
            }
            if (this.oldFragment instanceof AssociativeInfixExpressionFragment && fragment instanceof AssociativeInfixExpressionFragment) {
                AssociativeInfixExpressionFragment f1 = (AssociativeInfixExpressionFragment)this.oldFragment;
                AssociativeInfixExpressionFragment f2 = (AssociativeInfixExpressionFragment)fragment;
                if (f1.getOperands().size() != f2.getOperands().size()) {
                    return this.visit((Expression)node);
                }
            }
            this.setFragment(fragment);
            return false;
        }

        public boolean visit(Expression node) {
            this.setFragment(new SimpleExpressionFragment(node));
            return false;
        }

        public boolean visit(ASTNode node) {
            this.setFragment(new SimpleFragment(node));
            return false;
        }
    }

    private static class FragmentForSubPartBySourceRangeFactory
    extends FragmentFactory {
        private ISourceRange fRange;
        private ASTNode fScope;
        private Exception modelException = null;
        private IDocument fDocument;

        private FragmentForSubPartBySourceRangeFactory() {
        }

        public static IASTFragment createFragmentFor(ASTNode node, ISourceRange range, ASTNode scope, IDocument document) throws Exception {
            return new FragmentForSubPartBySourceRangeFactory().createFragment(node, range, scope, document);
        }

        public boolean visit(InfixExpression node) {
            try {
                this.setFragment(FragmentForSubPartBySourceRangeFactory.createInfixExpressionSubPartFragmentBySourceRange(node, this.fRange, this.fScope, this.fDocument));
            }
            catch (Exception e) {
                this.modelException = e;
            }
            return false;
        }

        public boolean visit(ASTNode node) {
            return false;
        }

        protected IASTFragment createFragment(ASTNode node, ISourceRange range, ASTNode scope, IDocument document) throws Exception {
            this.fRange = range;
            this.fScope = scope;
            this.fDocument = document;
            IASTFragment result = this.createFragment(node, null);
            if (this.modelException != null) {
                throw this.modelException;
            }
            return result;
        }

        private static IExpressionFragment createInfixExpressionSubPartFragmentBySourceRange(InfixExpression node, ISourceRange range, ASTNode scope, IDocument document) throws Exception {
            return AssociativeInfixExpressionFragment.createSubPartFragmentBySourceRange(node, range, document);
        }
    }
}

