/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IFormatterCommonPrferences;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TabAutoEditStrategy
implements IAutoEditStrategy {
    private int lastIndentSize = 0;
    private String lastIndentString = "";
    private StringBuffer helpBuffer = new StringBuffer();
    private IStructuredDocument document;
    private DocumentCommand command;
    private IndentLineAutoEditStrategy autoIndentLineStrategy = new IndentLineAutoEditStrategy();

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null && command.text.equals("\t")) {
            String partitionType = FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)document), (int)command.offset, (boolean)true);
            if ("org.eclipse.wst.html.SCRIPT".equals(partitionType) || "org.eclipse.wst.html.HTML_DEFAULT".equals(partitionType) || "org.eclipse.wst.html.SCRIPT".equals(partitionType)) {
                return;
            }
            command.text = "";
            this.command = command;
            this.document = (IStructuredDocument)document;
            boolean isAutoIndent = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("smart_tab");
            if (!isAutoIndent) {
                this.applyTabRule();
                return;
            }
            if (command.length != 0) {
                return;
            }
            this.tabPressed();
        }
    }

    private void tabPressed() {
        try {
            boolean caretInBegining;
            int lineNumber = this.document.getLineOfOffset(this.command.offset);
            IRegion originalLineInfo = this.document.getLineInformation(lineNumber);
            int originalLineStart = this.document.getLineOffset(lineNumber);
            int originalIndentSize = 0;
            int autoIndentSize = 0;
            boolean bl = caretInBegining = this.command.offset == originalLineStart;
            if (caretInBegining || !this.hasTextBeforeCaret(originalLineInfo)) {
                originalIndentSize = this.calculateOriginalIndentSize(lineNumber, originalLineInfo);
                autoIndentSize = this.calculateAutoIndentSize(lineNumber);
                if (autoIndentSize == -1) {
                    this.applyTabRule();
                    return;
                }
                boolean emptyCharAfterOldCaretPos = this.hasEmptyCharAfterCaret(lineNumber, originalLineStart);
                if (autoIndentSize >= originalIndentSize) {
                    this.applyIndent(lineNumber, originalLineStart);
                    if (autoIndentSize == originalIndentSize && !emptyCharAfterOldCaretPos) {
                        this.applyTabRule();
                    }
                } else if (this.hasEmptyCharAfterCaret(lineNumber, originalLineStart)) {
                    this.applyIndent(lineNumber, originalLineStart);
                } else {
                    this.applyTabRule();
                }
            } else {
                this.applyTabRule();
            }
        }
        catch (BadLocationException exp) {
            Logger.logException(exp);
        }
    }

    private boolean hasTextBeforeCaret(IRegion originalLineInfo) throws BadLocationException {
        int length = originalLineInfo.getLength();
        int lineOffset = originalLineInfo.getOffset();
        String lineText = this.document.get(lineOffset, length);
        int caretIndexInLine = this.command.offset - lineOffset;
        int i = 0;
        while (i < caretIndexInLine) {
            if (lineText.charAt(i) != ' ' && lineText.charAt(i) != '\t') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasEmptyCharAfterCaret(int lineNumber, int originalLineStart) throws BadLocationException {
        boolean result = false;
        IRegion lineInfo = this.document.getLineInformation(lineNumber);
        int length = lineInfo.getLength();
        if (length == 0) {
            return false;
        }
        int caretIndexInString = this.command.offset - originalLineStart;
        String lineText = this.document.get(originalLineStart, length);
        if (caretIndexInString == lineText.length()) {
            return false;
        }
        char charAfterCaret = lineText.charAt(caretIndexInString);
        if (charAfterCaret == ' ' || charAfterCaret == '\t') {
            result = true;
        }
        return result;
    }

    private int calculateOriginalIndentSize(int lineNumber, IRegion lineInfo) throws BadLocationException {
        int startOffset = lineInfo.getOffset();
        int length = lineInfo.getLength();
        String lineText = this.document.get(startOffset, length);
        int result = 0;
        int i = 0;
        while (i < lineText.length()) {
            switch (lineText.charAt(i)) {
                default: {
                    i = lineText.length();
                    break;
                }
                case ' ': {
                    ++result;
                    break;
                }
                case '\t': {
                    result += 4;
                }
            }
            ++i;
        }
        return result;
    }

    private void applyIndent(int lineNumber, int offset) throws BadLocationException {
        this.command.offset = offset;
        this.command.length = this.getCurrentIndentLength(lineNumber);
        this.command.text = this.helpBuffer.toString();
    }

    private int getCurrentIndentLength(int lineNumber) throws BadLocationException {
        IRegion lineInfo = this.document.getLineInformation(lineNumber);
        int startOffset = lineInfo.getOffset();
        int length = lineInfo.getLength();
        String lineText = this.document.get(startOffset, length);
        int i = 0;
        while (i < length && (lineText.charAt(i) == ' ' || lineText.charAt(i) == '\t')) {
            ++i;
        }
        return i;
    }

    private int calculateAutoIndentSize(int lineNumber) {
        this.helpBuffer.setLength(0);
        try {
            this.autoIndentLineStrategy.placeMatchingBlanks(this.document, this.helpBuffer, lineNumber, this.command);
        }
        catch (Exception e) {
            Logger.logException(e);
            return -1;
        }
        int result = 0;
        String str = this.helpBuffer.toString();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case ' ': {
                    ++result;
                    break;
                }
                case '\t': {
                    result += 4;
                }
            }
            ++i;
        }
        return result;
    }

    private void applyTabRule() {
        IFormatterCommonPrferences formatterCommonPrferences = FormatterUtils.getFormatterCommonPrferences();
        char indentChar = formatterCommonPrferences.getIndentationChar((IDocument)this.document);
        if (indentChar == ' ') {
            int lineOffset = -1;
            try {
                IRegion lineInfo = this.document.getLineInformationOfOffset(this.command.offset);
                lineOffset = this.command.offset - lineInfo.getOffset();
            }
            catch (BadLocationException e) {
                Logger.log(202, e.getMessage(), e);
            }
            int indentSize = formatterCommonPrferences.getIndentationSize((IDocument)this.document);
            if (lineOffset > 0) {
                lineOffset %= indentSize;
                indentSize -= lineOffset;
            }
            if (indentSize == 0) {
                indentSize = formatterCommonPrferences.getIndentationSize((IDocument)this.document);
            }
            this.command.text = String.valueOf(this.command.text) + this.getIndentationString(indentSize);
        } else {
            this.command.text = String.valueOf(this.command.text) + "\t";
        }
    }

    private String getIndentationString(int indentSize) {
        if (indentSize == this.lastIndentSize) {
            return this.lastIndentString;
        }
        this.lastIndentSize = indentSize;
        char[] result = new char[indentSize];
        int i = 0;
        while (i < result.length) {
            result[i] = 32;
            ++i;
        }
        this.lastIndentString = String.valueOf(result);
        return this.lastIndentString;
    }
}

