/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.typeinference.PHPClassType;

public class PHPSimpleTypes {
    private static final Map<String, IEvaluatedType> SIMPLE_TYPES;
    public static final IEvaluatedType NUMBER;
    public static final IEvaluatedType BOOLEAN;
    public static final IEvaluatedType STRING;
    public static final IEvaluatedType OBJECT;
    public static final IEvaluatedType RESOURCE;
    public static final IEvaluatedType ARRAY;
    public static final IEvaluatedType VOID;
    public static final IEvaluatedType NULL;
    public static final IEvaluatedType MIXED;

    static {
        NUMBER = new SimpleType(1);
        BOOLEAN = new SimpleType(5);
        STRING = new SimpleType(0);
        OBJECT = new PHPClassType("object");
        RESOURCE = new PHPClassType("resource");
        ARRAY = new MultiTypeType();
        VOID = new PHPClassType("void");
        NULL = new SimpleType(8);
        MIXED = new PHPClassType("mixed");
        SIMPLE_TYPES = new HashMap<String, IEvaluatedType>();
        SIMPLE_TYPES.put("array", (IEvaluatedType)new MultiTypeType());
        SIMPLE_TYPES.put("bool", BOOLEAN);
        SIMPLE_TYPES.put("boolean", BOOLEAN);
        SIMPLE_TYPES.put("int", NUMBER);
        SIMPLE_TYPES.put("integer", NUMBER);
        SIMPLE_TYPES.put("float", NUMBER);
        SIMPLE_TYPES.put("double", NUMBER);
        SIMPLE_TYPES.put("number", NUMBER);
        SIMPLE_TYPES.put("string", STRING);
        SIMPLE_TYPES.put("resource", RESOURCE);
        SIMPLE_TYPES.put("string", STRING);
        SIMPLE_TYPES.put("object", OBJECT);
        SIMPLE_TYPES.put("void", VOID);
        SIMPLE_TYPES.put("null", NULL);
        SIMPLE_TYPES.put("mixed", MIXED);
    }

    public static IEvaluatedType fromString(String type) {
        return SIMPLE_TYPES.get(type.toLowerCase());
    }

    public static IEvaluatedType fromStringCS(String type) {
        return SIMPLE_TYPES.get(type);
    }

    public static boolean isSimpleTypeCS(String type) {
        return SIMPLE_TYPES.containsKey(type);
    }
}

