/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.FinallyClause;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class TryStatement
extends Statement {
    private final Block tryStatement;
    private final List<CatchClause> catchClauses;
    private final FinallyClause finallyClause;

    public TryStatement(int start, int end, Block tryStatement, List<CatchClause> catchClauses, FinallyClause finallyClause) {
        super(start, end);
        assert (tryStatement != null && catchClauses != null);
        this.tryStatement = tryStatement;
        this.catchClauses = catchClauses;
        this.finallyClause = finallyClause;
    }

    public TryStatement(int start, int end, Block tryStatement, List<CatchClause> catchClauses) {
        this(start, end, tryStatement, catchClauses, null);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            this.tryStatement.traverse(visitor);
            for (CatchClause catchClause : this.catchClauses) {
                catchClause.traverse(visitor);
            }
            if (this.finallyClause != null) {
                this.finallyClause.traverse(visitor);
            }
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 58;
    }

    public Collection<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    public Block getTryStatement() {
        return this.tryStatement;
    }

    public FinallyClause getFinallyClause() {
        return this.finallyClause;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

