/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class InfixExpression
extends Expression {
    public static final int OP_IS_IDENTICAL = 0;
    public static final int OP_IS_NOT_IDENTICAL = 1;
    public static final int OP_IS_EQUAL = 2;
    public static final int OP_IS_NOT_EQUAL = 3;
    public static final int OP_RGREATER = 4;
    public static final int OP_IS_SMALLER_OR_EQUAL = 5;
    public static final int OP_LGREATER = 6;
    public static final int OP_IS_GREATER_OR_EQUAL = 7;
    public static final int OP_BOOL_OR = 8;
    public static final int OP_BOOL_AND = 9;
    public static final int OP_STRING_OR = 10;
    public static final int OP_STRING_AND = 11;
    public static final int OP_STRING_XOR = 12;
    public static final int OP_OR = 13;
    public static final int OP_AND = 14;
    public static final int OP_XOR = 15;
    public static final int OP_CONCAT = 16;
    public static final int OP_PLUS = 17;
    public static final int OP_MINUS = 18;
    public static final int OP_MUL = 19;
    public static final int OP_DIV = 20;
    public static final int OP_MOD = 21;
    public static final int OP_SL = 22;
    public static final int OP_SR = 23;
    public static final int OP_POW = 24;
    private final Expression right;
    private final int operator;
    private final Expression left;

    public InfixExpression(int start, int end, Expression left, int operator, Expression right) {
        super(start, end);
        assert (right != null && left != null);
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public String getOperator() {
        switch (this.getOperatorType()) {
            case 0: {
                return "===";
            }
            case 1: {
                return "!==";
            }
            case 2: {
                return "==";
            }
            case 3: {
                return "!=";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return "<=";
            }
            case 6: {
                return ">";
            }
            case 7: {
                return ">=";
            }
            case 8: {
                return "||";
            }
            case 9: {
                return "&&";
            }
            case 10: {
                return "or";
            }
            case 11: {
                return "and";
            }
            case 12: {
                return "xor";
            }
            case 13: {
                return "|";
            }
            case 14: {
                return "&";
            }
            case 15: {
                return "^";
            }
            case 16: {
                return ".";
            }
            case 17: {
                return "+";
            }
            case 18: {
                return "-";
            }
            case 19: {
                return "*";
            }
            case 20: {
                return "/";
            }
            case 21: {
                return "%";
            }
            case 22: {
                return "<<";
            }
            case 23: {
                return ">>";
            }
            case 24: {
                return "**";
            }
        }
        throw new IllegalArgumentException();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            this.left.traverse(visitor);
            this.right.traverse(visitor);
        }
        visitor.endvisit((Expression)this);
    }

    public int getKind() {
        return 37;
    }

    public Expression getLeft() {
        return this.left;
    }

    public int getOperatorType() {
        return this.operator;
    }

    public Expression getRight() {
        return this.right;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

