/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalTypesStrategy;

public class UseNameStrategy
extends GlobalTypesStrategy {
    private static final String FUNCTION_KEYWORD = "function";
    private static final String CONST_KEYWORD = "const";

    public UseNameStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, trueFlag, falseFlag);
    }

    public UseNameStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        AbstractCompletionContext completionContext = (AbstractCompletionContext)this.getContext();
        if (completionContext.getPrefix() != null && completionContext.getPrefix().indexOf(92) >= 0) {
            return;
        }
        this.reportKeyword(FUNCTION_KEYWORD, reporter);
        this.reportKeyword(CONST_KEYWORD, reporter);
        super.apply(reporter);
    }

    private void reportKeyword(String keyword, ICompletionReporter reporter) throws BadLocationException {
        AbstractCompletionContext completionContext = (AbstractCompletionContext)this.getContext();
        if (completionContext.getPrefix() == null || keyword.startsWith(completionContext.getPrefix())) {
            reporter.reportKeyword(keyword, " ", (ISourceRange)this.getReplacementRange(completionContext));
        }
    }

    @Override
    public String getNSSuffix(AbstractCompletionContext abstractContext) {
        return "";
    }

    @Override
    protected int getExtraInfo() {
        return 2;
    }
}

