/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionContextResolver;
import org.eclipse.php.core.codeassist.ICompletionStrategy;
import org.eclipse.php.core.codeassist.ICompletionStrategyFactory;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.CompletionCompanion;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestorExtension;
import org.eclipse.php.internal.core.codeassist.contexts.CompletionContextResolver;
import org.eclipse.php.internal.core.codeassist.strategies.CompletionStrategyFactory;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class PHPCompletionEngine
extends ScriptCompletionEngine
implements ICompletionReporter {
    private int relevanceKeyword;
    private int relevanceMethod;
    private int relevanceClass;
    private int relevanceVar;
    private int relevanceConst;
    private Map<? super Object, Object> processedElements = new HashMap<Object, Object>();
    private Set<? super Object> processedPaths = new HashSet<Object>();
    private Set<IField> processedFields = new TreeSet<IField>(new Comparator<IField>(){

        @Override
        public int compare(IField f1, IField f2) {
            if (PHPModelUtils.isSameField(f1, f2)) {
                return 0;
            }
            return f1.getElementName().compareTo(f2.getElementName());
        }
    });
    IModuleSource module;

    public void complete(IModuleSource module, int position, int i) {
        this.complete(module, position, i, true);
    }

    public void complete(IModuleSource module, int position, int i, boolean waitForBuilder) {
        if (!PHPCorePlugin.toolkitInitialized) {
            return;
        }
        if (this.requestor instanceof IPHPCompletionRequestor) {
            ((IPHPCompletionRequestor)this.requestor).setOffset(this.offset);
        }
        if (waitForBuilder) {
            ModelManager.getModelManager().getIndexManager().waitUntilReady();
        }
        this.module = module;
        this.relevanceKeyword = 10000000;
        this.relevanceMethod = 100000;
        this.relevanceClass = 10000;
        this.relevanceVar = 1000000;
        this.relevanceConst = 1000;
        try {
            ICompletionStrategyFactory[] strategyFactories;
            ICompletionContextResolver[] contextResolvers;
            if (this.requestor instanceof IPHPCompletionRequestorExtension) {
                contextResolvers = ((IPHPCompletionRequestorExtension)this.requestor).getContextResolvers();
                strategyFactories = ((IPHPCompletionRequestorExtension)this.requestor).getStrategyFactories();
            } else {
                contextResolvers = CompletionContextResolver.getActive();
                strategyFactories = CompletionStrategyFactory.getActive();
            }
            CompletionCompanion companion = new CompletionCompanion();
            ISourceModule sourceModule = (ISourceModule)module.getModelElement();
            ICompletionContextResolver[] iCompletionContextResolverArray = contextResolvers;
            int n = contextResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionContextResolver resolver = iCompletionContextResolverArray[n2];
                ICompletionContext[] contexts = resolver.resolve(sourceModule, position, this.requestor, companion);
                if (contexts != null && contexts.length > 0) {
                    ICompletionStrategyFactory[] iCompletionStrategyFactoryArray = strategyFactories;
                    int n3 = strategyFactories.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICompletionStrategyFactory factory = iCompletionStrategyFactoryArray[n4];
                        ICompletionStrategy[] strategies = factory.create(contexts);
                        if (strategies != null && strategies.length > 0) {
                            ICompletionStrategy[] iCompletionStrategyArray = strategies;
                            int n5 = strategies.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ICompletionStrategy strategy = iCompletionStrategyArray[n6];
                                strategy.init(companion);
                                try {
                                    strategy.apply(this);
                                }
                                catch (Exception e) {
                                    PHPCorePlugin.log(e);
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        finally {
            this.processedElements.clear();
            this.processedPaths.clear();
        }
    }

    private int nextKeywordRelevance() {
        int relevance;
        if ((relevance = this.relevanceKeyword--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    private int nextMethodRelevance() {
        int relevance;
        if ((relevance = this.relevanceMethod--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    private int nextClassRelevance() {
        int relevance;
        if ((relevance = this.relevanceClass--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    private int nextVariableRelevance() {
        int relevance;
        if ((relevance = this.relevanceVar--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    private int nextConstantRelevance() {
        int relevance;
        if ((relevance = this.relevanceConst--) < 1) {
            relevance = 1;
        }
        return relevance;
    }

    @Override
    public void reportField(IField field, String suffix, ISourceRange replaceRange, boolean removeDollar) {
        this.reportField(field, suffix, replaceRange, removeDollar, 0);
    }

    @Override
    public void reportField(IField field, String suffix, ISourceRange replaceRange, boolean removeDollar, int subRelevance) {
        this.reportField(field, suffix, replaceRange, removeDollar, subRelevance, null);
    }

    @Override
    public void reportField(IField field, String suffix, ISourceRange replaceRange, boolean removeDollar, int subRelevance, Object extraInfo) {
        if (this.processedFields.contains(field)) {
            return;
        }
        this.processedFields.add(field);
        int flags = 0;
        try {
            flags = field.getFlags();
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        int relevance = PHPFlags.isConstant(flags) ? this.relevanceConst : this.relevanceVar;
        relevance += subRelevance;
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(1, this.actualCompletionPosition);
            proposal.setName(field.getElementName());
            String completion = String.valueOf(field.getElementName()) + suffix;
            if (removeDollar && completion.startsWith("$")) {
                completion = completion.substring(1);
            }
            proposal.setCompletion(completion);
            proposal.setExtraInfo(extraInfo);
            proposal.setModelElement((IModelElement)field);
            proposal.setFlags(flags);
            proposal.setRelevance(relevance);
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    public void reportField(IField field, String completion, ISourceRange replaceRange, int subRelevance) {
        if (this.processedFields.contains(field)) {
            return;
        }
        this.processedFields.add(field);
        int flags = 0;
        try {
            flags = field.getFlags();
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        int relevance = PHPFlags.isConstant(flags) ? this.relevanceConst : this.relevanceVar;
        relevance += subRelevance;
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(1, this.actualCompletionPosition);
            proposal.setName(field.getElementName());
            proposal.setCompletion(completion);
            proposal.setModelElement((IModelElement)field);
            proposal.setFlags(flags);
            proposal.setRelevance(relevance);
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    @Override
    public void reportKeyword(String keyword, String suffix, ISourceRange replaceRange) {
        this.reportKeyword(keyword, suffix, replaceRange, 0);
    }

    @Override
    public void reportKeyword(String keyword, String suffix, ISourceRange replaceRange, int subRelevance) {
        if (this.processedElements.containsKey(keyword)) {
            return;
        }
        this.processedElements.put(keyword, keyword);
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
            proposal.setName(keyword);
            proposal.setCompletion(String.valueOf(keyword) + suffix);
            proposal.setRelevance(this.relevanceKeyword + subRelevance);
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    @Override
    public void reportMethod(IMethod method, String suffix, ISourceRange replaceRange, Object extraInfo) {
        this.reportMethod(method, suffix, replaceRange, extraInfo, 0);
    }

    @Override
    public void reportMethod(IMethod method, String suffix, ISourceRange replaceRange, Object extraInfo, int subRelevance) {
        if (this.processedElements.containsKey(method) && ((IMethod)this.processedElements.get(method)).getParent().getClass() == method.getParent().getClass()) {
            return;
        }
        this.processedElements.put(method, method);
        this.noProposal = false;
        if (!this.requestor.isIgnored(6)) {
            int relevance;
            CompletionProposal proposal;
            block8: {
                String elementName;
                proposal = this.createProposal(6, this.actualCompletionPosition);
                proposal.setExtraInfo(extraInfo);
                String[] params = null;
                try {
                    params = method.getParameterNames();
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
                if (params != null && params.length > 0) {
                    proposal.setParameterNames(params);
                }
                String completionName = elementName = method.getElementName();
                proposal.setModelElement((IModelElement)method);
                proposal.setName(elementName);
                relevance = this.relevanceMethod + subRelevance;
                proposal.setCompletion(String.valueOf(completionName) + suffix);
                try {
                    proposal.setIsConstructor(elementName.equals("__construct") || method.isConstructor());
                    proposal.setFlags(method.getFlags());
                }
                catch (ModelException e) {
                    if (!DEBUG) break block8;
                    e.printStackTrace();
                }
            }
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    @Override
    public void reportMethod(IMethod method, String suffix, ISourceRange replaceRange) {
        this.reportMethod(method, suffix, replaceRange, null);
    }

    @Override
    public void reportType(IType type, String suffix, ISourceRange replaceRange) {
        this.reportType(type, suffix, replaceRange, null);
    }

    @Override
    public void reportType(IType type, String suffix, ISourceRange replaceRange, Object extraInfo) {
        this.reportType(type, suffix, replaceRange, extraInfo, 0);
    }

    @Override
    public void reportType(IType type, String suffix, ISourceRange replaceRange, Object extraInfo, int subRelevance) {
        if (this.processedElements.containsKey(type) && this.processedElements.get(type).getClass() == type.getClass()) {
            return;
        }
        this.processedElements.put(type, type);
        this.noProposal = false;
        if (!this.requestor.isIgnored(7)) {
            String elementName;
            CompletionProposal proposal = this.createProposal(7, this.actualCompletionPosition);
            proposal.setExtraInfo(extraInfo);
            if (this.requestor.isContextInformationMode()) {
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor()) {
                            String[] params = method.getParameterNames();
                            if (params != null && params.length > 0) {
                                proposal.setParameterNames(params);
                            }
                            break;
                        }
                        ++n2;
                    }
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
            }
            String completionName = elementName = type.getElementName();
            proposal.setModelElement((IModelElement)type);
            proposal.setName(elementName);
            int relevance = this.relevanceClass + subRelevance;
            proposal.setCompletion(String.valueOf(completionName) + suffix);
            try {
                proposal.setFlags(type.getFlags());
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
            proposal.setRelevance(relevance);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    @Override
    public void reportResource(IModelElement model, IPath relative, String suffix, ISourceRange replaceRange) {
        if (this.processedElements.containsKey(model) || this.processedPaths.contains(relative)) {
            return;
        }
        this.processedElements.put(model, model);
        this.processedPaths.add(relative);
        this.noProposal = false;
        CompletionProposal proposal = null;
        if (model.getElementType() == 4 && !this.requestor.isIgnored(11)) {
            proposal = this.createProposal(11, this.actualCompletionPosition);
        } else if (model.getElementType() == 3) {
            proposal = this.createProposal(11, this.actualCompletionPosition);
        } else if (!this.requestor.isIgnored(2)) {
            proposal = this.createProposal(2, this.actualCompletionPosition);
        }
        if (proposal == null) {
            return;
        }
        proposal.setName(relative.toString());
        proposal.setCompletion(String.valueOf(relative.toString()) + suffix);
        proposal.setRelevance(this.relevanceKeyword);
        proposal.setReplaceRange(replaceRange.getOffset(), replaceRange.getOffset() + replaceRange.getLength());
        proposal.setModelElement(model);
        this.requestor.accept(proposal);
        if (DEBUG) {
            this.printDebug(proposal);
        }
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return method.getElementName();
    }

    protected String processTypeName(IType type, String token) {
        return type.getElementName();
    }

    @Override
    public IModuleSource getModule() {
        return this.module;
    }
}

