/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTError;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.ArrayCreation;
import org.eclipse.php.internal.core.ast.nodes.ArrayElement;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.BreakStatement;
import org.eclipse.php.internal.core.ast.nodes.CastExpression;
import org.eclipse.php.internal.core.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.CloneExpression;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import org.eclipse.php.internal.core.ast.nodes.ConditionalExpression;
import org.eclipse.php.internal.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ContinueStatement;
import org.eclipse.php.internal.core.ast.nodes.DeclareStatement;
import org.eclipse.php.internal.core.ast.nodes.DoStatement;
import org.eclipse.php.internal.core.ast.nodes.EchoStatement;
import org.eclipse.php.internal.core.ast.nodes.EmptyStatement;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FinallyClause;
import org.eclipse.php.internal.core.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.ast.nodes.ForStatement;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.GotoLabel;
import org.eclipse.php.internal.core.ast.nodes.GotoStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.IfStatement;
import org.eclipse.php.internal.core.ast.nodes.IgnoreError;
import org.eclipse.php.internal.core.ast.nodes.InLineHtml;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.PostfixExpression;
import org.eclipse.php.internal.core.ast.nodes.PrefixExpression;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Quote;
import org.eclipse.php.internal.core.ast.nodes.Reference;
import org.eclipse.php.internal.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.internal.core.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StaticStatement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.SwitchCase;
import org.eclipse.php.internal.core.ast.nodes.SwitchStatement;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.TryStatement;
import org.eclipse.php.internal.core.ast.nodes.UnaryOperation;
import org.eclipse.php.internal.core.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.Visitable;
import org.eclipse.php.internal.core.ast.nodes.WhileStatement;
import org.eclipse.php.internal.core.ast.nodes.YieldExpression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public abstract class ASTNode
implements Visitable {
    public static final int ARRAY_ACCESS = 0;
    public static final int ARRAY_CREATION = 1;
    public static final int ARRAY_ELEMENT = 2;
    public static final int ASSIGNMENT = 3;
    public static final int AST_ERROR = 4;
    public static final int BACK_TICK_EXPRESSION = 5;
    public static final int BLOCK = 6;
    public static final int BREAK_STATEMENT = 7;
    public static final int CAST_EXPRESSION = 8;
    public static final int CATCH_CLAUSE = 9;
    public static final int STATIC_CONSTANT_ACCESS = 10;
    public static final int CONSTANT_DECLARATION = 11;
    public static final int CLASS_DECLARATION = 12;
    public static final int CLASS_INSTANCE_CREATION = 13;
    public static final int CLASS_NAME = 14;
    public static final int CLONE_EXPRESSION = 15;
    public static final int COMMENT = 16;
    public static final int CONDITIONAL_EXPRESSION = 17;
    public static final int CONTINUE_STATEMENT = 18;
    public static final int DECLARE_STATEMENT = 19;
    public static final int DO_STATEMENT = 20;
    public static final int ECHO_STATEMENT = 21;
    public static final int EMPTY_STATEMENT = 22;
    public static final int EXPRESSION_STATEMENT = 23;
    public static final int FIELD_ACCESS = 24;
    public static final int FIELD_DECLARATION = 25;
    public static final int FOR_EACH_STATEMENT = 26;
    public static final int FORMAL_PARAMETER = 27;
    public static final int FOR_STATEMENT = 28;
    public static final int FUNCTION_DECLARATION = 29;
    public static final int FUNCTION_INVOCATION = 30;
    public static final int FUNCTION_NAME = 31;
    public static final int GLOBAL_STATEMENT = 32;
    public static final int IDENTIFIER = 33;
    public static final int IF_STATEMENT = 34;
    public static final int IGNORE_ERROR = 35;
    public static final int INCLUDE = 36;
    public static final int INFIX_EXPRESSION = 37;
    public static final int IN_LINE_HTML = 38;
    public static final int INSTANCE_OF_EXPRESSION = 39;
    public static final int INTERFACE_DECLARATION = 40;
    public static final int LIST_VARIABLE = 41;
    public static final int METHOD_DECLARATION = 42;
    public static final int METHOD_INVOCATION = 43;
    public static final int POSTFIX_EXPRESSION = 44;
    public static final int PREFIX_EXPRESSION = 45;
    public static final int PROGRAM = 46;
    public static final int QUOTE = 47;
    public static final int REFERENCE = 48;
    public static final int REFLECTION_VARIABLE = 49;
    public static final int RETURN_STATEMENT = 50;
    public static final int SCALAR = 51;
    public static final int STATIC_FIELD_ACCESS = 52;
    public static final int STATIC_METHOD_INVOCATION = 53;
    public static final int STATIC_STATEMENT = 54;
    public static final int SWITCH_CASE = 55;
    public static final int SWITCH_STATEMENT = 56;
    public static final int THROW_STATEMENT = 57;
    public static final int TRY_STATEMENT = 58;
    public static final int UNARY_OPERATION = 59;
    public static final int VARIABLE = 60;
    public static final int WHILE_STATEMENT = 61;
    public static final int PARENTHESIS_EXPRESSION = 62;
    public static final int SINGLE_FIELD_DECLARATION = 63;
    public static final int NAMESPACE = 64;
    public static final int NAMESPACE_NAME = 65;
    public static final int USE_STATEMENT_PART = 66;
    public static final int USE_STATEMENT = 67;
    public static final int GOTO_LABEL = 68;
    public static final int GOTO_STATEMENT = 69;
    public static final int LAMBDA_FUNCTION_DECLARATION = 70;
    public static final int TRAIT_USE_STATEMENT = 71;
    public static final int TRAIT_DECLARATION = 72;
    public static final int FULLY_QUALIFIED_TRAIT_METHOD_REFERENCE = 73;
    public static final int TRAIT_ALIAS = 74;
    public static final int YIELD_STATEMENT = 75;
    public static final int FINALLY_CLAUSE = 76;
    static final boolean CYCLE_RISK = true;
    static final boolean NO_CYCLE_RISK = false;
    static final boolean MANDATORY = true;
    static final boolean OPTIONAL = false;
    public static final char MALFORMED = '\u0001';
    public static final char ORIGINAL = '\u0002';
    public static final char PROTECT = '\u0004';
    public static final char RECOVERED = '\b';
    private int start = -1;
    private int length = 0;
    int flags = 0;
    private StructuralPropertyDescriptor location = null;
    final AST ast;
    private ASTNode parent = null;
    private static final Map UNMODIFIABLE_EMPTY_MAP = Collections.unmodifiableMap(new HashMap(1));
    private Object property1 = null;
    private Object property2 = null;

    public ASTNode(AST ast) {
        if (ast == null) {
            throw new IllegalArgumentException();
        }
        this.ast = ast;
        this.setFlags(ast.getDefaultNodeFlag());
    }

    public ASTNode(int start, int end, AST ast) {
        this(ast);
        this.start = start;
        this.length = end - start;
    }

    @Override
    public final void accept(Visitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        visitor.preVisit(this);
        this.accept0(visitor);
        visitor.postVisit(this);
    }

    abstract void accept0(Visitor var1);

    public abstract boolean subtreeMatch(ASTMatcher var1, Object var2);

    public abstract int getType();

    public final StructuralPropertyDescriptor getLocationInParent() {
        return this.location;
    }

    public final Object getStructuralProperty(StructuralPropertyDescriptor property) {
        if (property instanceof SimplePropertyDescriptor) {
            SimplePropertyDescriptor p = (SimplePropertyDescriptor)property;
            if (p.getValueType() == Integer.class) {
                int result = this.internalGetSetIntProperty(p, true, 0);
                return result;
            }
            if (p.getValueType() == Boolean.class) {
                boolean result = this.internalGetSetBooleanProperty(p, true, false);
                return result;
            }
            return this.internalGetSetObjectProperty(p, true, null);
        }
        if (property instanceof ChildPropertyDescriptor) {
            return this.internalGetSetChildProperty((ChildPropertyDescriptor)property, true, null);
        }
        if (property instanceof ChildListPropertyDescriptor) {
            return this.internalGetChildListProperty((ChildListPropertyDescriptor)property);
        }
        throw new IllegalArgumentException();
    }

    public final void setStructuralProperty(StructuralPropertyDescriptor property, Object value) {
        if (property instanceof SimplePropertyDescriptor) {
            SimplePropertyDescriptor p = (SimplePropertyDescriptor)property;
            if (p.getValueType() == Integer.TYPE) {
                int arg = (Integer)value;
                this.internalGetSetIntProperty(p, false, arg);
                return;
            }
            if (p.getValueType() == Boolean.TYPE) {
                boolean arg = (Boolean)value;
                this.internalGetSetBooleanProperty(p, false, arg);
                return;
            }
            if (value == null && p.isMandatory()) {
                throw new IllegalArgumentException();
            }
            this.internalGetSetObjectProperty(p, false, value);
            return;
        }
        if (property instanceof ChildPropertyDescriptor) {
            ChildPropertyDescriptor p = (ChildPropertyDescriptor)property;
            ASTNode child = (ASTNode)value;
            if (child == null && p.isMandatory()) {
                throw new IllegalArgumentException();
            }
            this.internalGetSetChildProperty(p, false, child);
            return;
        }
        if (property instanceof ChildListPropertyDescriptor) {
            throw new IllegalArgumentException("Cannot set the list of child list property");
        }
    }

    public final List<StructuralPropertyDescriptor> structuralPropertiesForType() {
        return this.internalStructuralPropertiesForType(this.ast.apiLevel);
    }

    abstract List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion var1);

    public AST getAST() {
        return this.ast;
    }

    public ASTNode getParent() {
        return this.parent;
    }

    public void setParent(ASTNode parent, StructuralPropertyDescriptor location) {
        this.parent = parent;
        this.location = location;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.start + this.length;
    }

    public static Class<? extends ASTNode> nodeClassForType(int nodeType) {
        switch (nodeType) {
            case 0: {
                return ArrayAccess.class;
            }
            case 1: {
                return ArrayCreation.class;
            }
            case 2: {
                return ArrayElement.class;
            }
            case 3: {
                return Assignment.class;
            }
            case 4: {
                return ASTError.class;
            }
            case 5: {
                return BackTickExpression.class;
            }
            case 6: {
                return Block.class;
            }
            case 7: {
                return BreakStatement.class;
            }
            case 8: {
                return CastExpression.class;
            }
            case 9: {
                return CatchClause.class;
            }
            case 10: {
                return StaticConstantAccess.class;
            }
            case 11: {
                return ConstantDeclaration.class;
            }
            case 12: {
                return ClassDeclaration.class;
            }
            case 13: {
                return ClassInstanceCreation.class;
            }
            case 14: {
                return ClassName.class;
            }
            case 15: {
                return CloneExpression.class;
            }
            case 16: {
                return Comment.class;
            }
            case 17: {
                return ConditionalExpression.class;
            }
            case 18: {
                return ContinueStatement.class;
            }
            case 19: {
                return DeclareStatement.class;
            }
            case 20: {
                return DoStatement.class;
            }
            case 21: {
                return EchoStatement.class;
            }
            case 22: {
                return EmptyStatement.class;
            }
            case 23: {
                return ExpressionStatement.class;
            }
            case 24: {
                return FieldAccess.class;
            }
            case 25: {
                return FieldsDeclaration.class;
            }
            case 26: {
                return ForEachStatement.class;
            }
            case 27: {
                return FormalParameter.class;
            }
            case 28: {
                return ForStatement.class;
            }
            case 29: {
                return FunctionDeclaration.class;
            }
            case 30: {
                return FunctionInvocation.class;
            }
            case 31: {
                return FunctionName.class;
            }
            case 32: {
                return GlobalStatement.class;
            }
            case 68: {
                return GotoLabel.class;
            }
            case 69: {
                return GotoStatement.class;
            }
            case 33: {
                return Identifier.class;
            }
            case 34: {
                return IfStatement.class;
            }
            case 35: {
                return IgnoreError.class;
            }
            case 36: {
                return Include.class;
            }
            case 37: {
                return InfixExpression.class;
            }
            case 38: {
                return InLineHtml.class;
            }
            case 39: {
                return InstanceOfExpression.class;
            }
            case 40: {
                return InterfaceDeclaration.class;
            }
            case 70: {
                return LambdaFunctionDeclaration.class;
            }
            case 41: {
                return ListVariable.class;
            }
            case 42: {
                return MethodDeclaration.class;
            }
            case 43: {
                return MethodInvocation.class;
            }
            case 64: {
                return NamespaceDeclaration.class;
            }
            case 65: {
                return NamespaceName.class;
            }
            case 44: {
                return PostfixExpression.class;
            }
            case 45: {
                return PrefixExpression.class;
            }
            case 46: {
                return Program.class;
            }
            case 47: {
                return Quote.class;
            }
            case 48: {
                return Reference.class;
            }
            case 49: {
                return ReflectionVariable.class;
            }
            case 50: {
                return ReturnStatement.class;
            }
            case 75: {
                return YieldExpression.class;
            }
            case 51: {
                return Scalar.class;
            }
            case 52: {
                return StaticFieldAccess.class;
            }
            case 53: {
                return StaticMethodInvocation.class;
            }
            case 54: {
                return StaticStatement.class;
            }
            case 55: {
                return SwitchCase.class;
            }
            case 56: {
                return SwitchStatement.class;
            }
            case 57: {
                return ThrowStatement.class;
            }
            case 58: {
                return TryStatement.class;
            }
            case 59: {
                return UnaryOperation.class;
            }
            case 67: {
                return UseStatement.class;
            }
            case 66: {
                return UseStatementPart.class;
            }
            case 60: {
                return Variable.class;
            }
            case 61: {
                return WhileStatement.class;
            }
            case 62: {
                return ParenthesisExpression.class;
            }
            case 76: {
                return FinallyClause.class;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(buffer, "");
        return buffer.toString();
    }

    protected void appendInterval(StringBuffer buffer) {
        buffer.append(" start='").append(this.start).append("' length='").append(this.length).append("'");
    }

    protected static String getXmlStringValue(String input) {
        String escapedString = input;
        escapedString = escapedString.replaceAll("&", "&amp;");
        escapedString = escapedString.replaceAll(">", "&gt;");
        escapedString = escapedString.replaceAll("<", "&lt;");
        escapedString = escapedString.replaceAll("'", "&apos;");
        return escapedString;
    }

    public Program getProgramRoot() {
        ASTNode node = this;
        while (node != null) {
            if (node.getType() == 46) {
                return (Program)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public ASTNode getEnclosingBodyNode() {
        ASTNode node = this;
        do {
            switch (node.getType()) {
                case 29: {
                    return node;
                }
                case 25: {
                    return null;
                }
                case 46: {
                    return node;
                }
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    public final ASTNode getRoot() {
        ASTNode candidate = this;
        ASTNode p;
        while ((p = candidate.getParent()) != null) {
            candidate = p;
        }
        return candidate;
    }

    public final void setSourceRange(int startPosition, int length) {
        if (startPosition >= 0 && length < 0) {
            throw new IllegalArgumentException();
        }
        if (startPosition < 0 && length != 0) {
            throw new IllegalArgumentException();
        }
        this.start = startPosition;
        this.length = length;
    }

    public final void delete() {
        StructuralPropertyDescriptor p = this.getLocationInParent();
        if (p == null) {
            return;
        }
        if (p.isChildProperty()) {
            this.getParent().setStructuralProperty(this.location, null);
            return;
        }
        if (p.isChildListProperty()) {
            List l = (List)this.getParent().getStructuralProperty(this.location);
            l.remove(this);
        }
    }

    final void preReplaceChild(ASTNode oldChild, ASTNode newChild, ChildPropertyDescriptor property) {
        if ((this.flags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        if (newChild != null) {
            ASTNode.checkNewChild(this, newChild, property.cycleRisk, null);
        }
        if (oldChild != null) {
            if ((oldChild.flags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            if (newChild != null) {
                this.ast.preReplaceChildEvent(this, oldChild, newChild, property);
            } else {
                this.ast.preRemoveChildEvent(this, oldChild, property);
            }
            oldChild.setParent(null, null);
        } else if (newChild != null) {
            this.ast.preAddChildEvent(this, newChild, property);
        }
        if (newChild != null) {
            newChild.setParent(this, property);
        }
    }

    final void postReplaceChild(ASTNode oldChild, ASTNode newChild, ChildPropertyDescriptor property) {
        if (newChild != null) {
            if (oldChild != null) {
                this.ast.postReplaceChildEvent(this, oldChild, newChild, property);
            } else {
                this.ast.postAddChildEvent(this, newChild, property);
            }
        } else {
            this.ast.postRemoveChildEvent(this, oldChild, property);
        }
    }

    final void preValueChange(SimplePropertyDescriptor property) {
        if ((this.flags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        this.ast.preValueChangeEvent(this, property);
        this.ast.modifying();
    }

    final void postValueChange(SimplePropertyDescriptor property) {
        this.ast.postValueChangeEvent(this, property);
    }

    final void checkModifiable() {
        if ((this.flags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        this.ast.modifying();
    }

    final void preLazyInit() {
        this.ast.disableEvents();
    }

    final void postLazyInit(ASTNode newChild, ChildPropertyDescriptor property) {
        newChild.setParent(this, property);
        this.ast.reenableEvents();
    }

    public final Object getProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.property1 == null) {
            return null;
        }
        if (this.property1 instanceof String) {
            if (propertyName.equals(this.property1)) {
                return this.property2;
            }
            return null;
        }
        Map m = (Map)this.property1;
        return m.get(propertyName);
    }

    public final void setProperty(String propertyName, Object data) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.property1 == null) {
            if (data == null) {
                return;
            }
            this.property1 = propertyName;
            this.property2 = data;
            return;
        }
        if (this.property1 instanceof String) {
            if (propertyName.equals(this.property1)) {
                this.property2 = data;
                if (data == null) {
                    this.property1 = null;
                    this.property2 = null;
                }
                return;
            }
            if (data == null) {
                return;
            }
            HashMap<Object, Object> m = new HashMap<Object, Object>(2);
            m.put(this.property1, this.property2);
            m.put(propertyName, data);
            this.property1 = m;
            this.property2 = null;
            return;
        }
        HashMap m = (HashMap)this.property1;
        if (data == null) {
            m.remove(propertyName);
            if (m.size() == 1) {
                Map.Entry[] entries = m.entrySet().toArray(new Map.Entry[1]);
                this.property1 = entries[0].getKey();
                this.property2 = entries[0].getValue();
            }
            return;
        }
        m.put(propertyName, data);
    }

    public final Map properties() {
        if (this.property1 == null) {
            return UNMODIFIABLE_EMPTY_MAP;
        }
        if (this.property1 instanceof String) {
            return Collections.singletonMap(this.property1, this.property2);
        }
        if (this.property2 == null) {
            this.property2 = Collections.unmodifiableMap((Map)this.property1);
        }
        return (Map)this.property2;
    }

    public final int getFlags() {
        return this.flags & 0xFFFF;
    }

    public final void setFlags(int flags) {
        this.ast.modifying();
        this.flags |= flags;
    }

    public static <T extends ASTNode> T copySubtree(AST target, T node) {
        if (node == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (target.apiLevel() != node.getAST().apiLevel()) {
            throw new UnsupportedOperationException();
        }
        ASTNode newNode = node.clone(target);
        return (T)newNode;
    }

    public static List copySubtrees(AST target, List<? extends ASTNode> nodes) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(nodes.size());
        for (ASTNode aSTNode : nodes) {
            ASTNode newNode = aSTNode.clone(target);
            result.add(newNode);
        }
        return result;
    }

    final ASTNode clone(AST target) {
        this.ast.preCloneNodeEvent(this);
        ASTNode c = this.clone0(target);
        this.ast.postCloneNodeEvent(this, c);
        return c;
    }

    abstract ASTNode clone0(AST var1);

    static void checkNewChild(ASTNode node, ASTNode newChild, boolean cycleCheck, Class nodeType) {
        if (newChild.ast != node.ast) {
            throw new IllegalArgumentException();
        }
        if (newChild.getParent() != null) {
            throw new IllegalArgumentException();
        }
        if (cycleCheck && newChild == node.getProgramRoot()) {
            throw new IllegalArgumentException();
        }
        Class<?> childClass = newChild.getClass();
        if (nodeType != null && !nodeType.isAssignableFrom(childClass)) {
            throw new ClassCastException();
        }
        if ((newChild.flags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
    }

    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        throw new RuntimeException("Node does not have this property");
    }

    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        throw new RuntimeException("Node does not have this property");
    }

    Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        throw new RuntimeException("Node does not have this property");
    }

    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        throw new RuntimeException("Node does not have this property");
    }

    List<StructuralPropertyDescriptor> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        throw new RuntimeException("Node does not have this property");
    }

    class NodeList<T extends ASTNode>
    extends AbstractList<T> {
        ArrayList<T> store = new ArrayList(0);
        ChildListPropertyDescriptor propertyDescriptor;
        private List<? super Cursor> cursors = null;

        NodeList(ChildListPropertyDescriptor property) {
            this.propertyDescriptor = property;
        }

        @Override
        public int size() {
            return this.store.size();
        }

        @Override
        public T get(int index) {
            return (T)((ASTNode)this.store.get(index));
        }

        @Override
        public T set(int index, T element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if ((ASTNode.this.flags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            T newChild = element;
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if (oldChild == newChild) {
                return (T)oldChild;
            }
            if ((oldChild.flags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode.checkNewChild(ASTNode.this, newChild, this.propertyDescriptor.cycleRisk, this.propertyDescriptor.elementType);
            ASTNode.this.ast.preReplaceChildEvent(ASTNode.this, oldChild, (ASTNode)newChild, this.propertyDescriptor);
            ASTNode result = (ASTNode)this.store.set(index, newChild);
            oldChild.setParent(null, null);
            ((ASTNode)newChild).setParent(ASTNode.this, this.propertyDescriptor);
            ASTNode.this.ast.postReplaceChildEvent(ASTNode.this, oldChild, (ASTNode)newChild, this.propertyDescriptor);
            return (T)result;
        }

        @Override
        public void add(int index, T element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if ((ASTNode.this.flags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            T newChild = element;
            ASTNode.checkNewChild(ASTNode.this, newChild, this.propertyDescriptor.cycleRisk, this.propertyDescriptor.elementType);
            ASTNode.this.ast.preAddChildEvent(ASTNode.this, (ASTNode)newChild, this.propertyDescriptor);
            this.store.add(index, element);
            this.updateCursors(index, 1);
            ((ASTNode)newChild).setParent(ASTNode.this, this.propertyDescriptor);
            ASTNode.this.ast.postAddChildEvent(ASTNode.this, (ASTNode)newChild, this.propertyDescriptor);
        }

        @Override
        public T remove(int index) {
            if ((ASTNode.this.flags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if ((oldChild.flags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode.this.ast.preRemoveChildEvent(ASTNode.this, oldChild, this.propertyDescriptor);
            oldChild.setParent(null, null);
            ASTNode result = (ASTNode)this.store.remove(index);
            this.updateCursors(index, -1);
            ASTNode.this.ast.postRemoveChildEvent(ASTNode.this, oldChild, this.propertyDescriptor);
            return (T)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Cursor newCursor() {
            NodeList nodeList = this;
            synchronized (nodeList) {
                if (this.cursors == null) {
                    this.cursors = new ArrayList<Cursor>(1);
                }
                Cursor result = new Cursor();
                this.cursors.add(result);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseCursor(Cursor cursor) {
            NodeList nodeList = this;
            synchronized (nodeList) {
                this.cursors.remove(cursor);
                if (this.cursors.isEmpty()) {
                    this.cursors = null;
                }
            }
        }

        private void updateCursors(int index, int delta) {
            if (this.cursors == null) {
                return;
            }
            for (Cursor cursor : this.cursors) {
                cursor.update(index, delta);
            }
        }

        class Cursor
        implements Iterator<T> {
            private int position = 0;

            Cursor() {
            }

            @Override
            public boolean hasNext() {
                return this.position < NodeList.this.store.size();
            }

            @Override
            public T next() {
                ASTNode result = (ASTNode)NodeList.this.store.get(this.position);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            void update(int index, int delta) {
                if (this.position > index) {
                    this.position += delta;
                }
            }
        }
    }
}

