/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.rename.RenameFileProcessor;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameFileWithClass
extends AbstractRenameRefactoringTest {
    private IProject project1;
    private IFile file;
    private IFile file1;

    @Before
    public void setUp() throws Exception {
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
        this.project1 = FileUtils.createProject("project1");
        this.file = this.project1.getFile("RenameFileWithClass1.php");
        ByteArrayInputStream source = new ByteArrayInputStream("<?php class RenameFileWithClass1{}?>".getBytes());
        if (!this.file.exists()) {
            this.file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        this.file1 = this.project1.getFile("RenameFileWithClass2.php");
        source = new ByteArrayInputStream("<?php include 'RenameFileWithClass1.php'; ?>".getBytes());
        if (!this.file1.exists()) {
            this.file1.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            this.file1.setContents((InputStream)source, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    @Test
    public void testRename() throws Exception {
        String content;
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        RenameFileProcessor processor = new RenameFileProcessor((IResource)this.file, program);
        processor.setNewElementName("RenameFileWithClass3.php");
        processor.setUpdateRefernces(true);
        processor.setUpdateTextualMatches(false);
        processor.setAttribute("org.eclipse.php.refactoring.core.rename.resource.classname", "true");
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        IFile file = this.project1.getFile("RenameFileWithClass3.php");
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.exists());
        try {
            content = FileUtils.getContents(file);
            Assert.assertEquals((Object)"<?php class RenameFileWithClass3{}?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            content = FileUtils.getContents(this.file1);
            Assert.assertEquals((Object)"<?php include 'RenameFileWithClass3.php'; ?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

