/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.refactoring.core.rename.AbstractRenameRefactoringTest;
import org.eclipse.php.refactoring.core.rename.RenameClassMemberProcessor;
import org.eclipse.php.refactoring.core.test.PdttFileExt;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class RenameClassMemberProcessorTest
extends AbstractRenameRefactoringTest {
    @PDTTList.Parameters
    public static String[] dirs = new String[]{"/resources/rename/renameClassMember/"};

    public RenameClassMemberProcessorTest(String[] fileNames) {
        super(fileNames);
    }

    @Test
    public void rename(String fileName) throws Exception {
        PdttFileExt testFile = (PdttFileExt)((Object)this.filesMap.get(fileName));
        IFile file = this.project.findFile(testFile.getTestFiles().get(0).getName());
        Program program = this.createProgram(file);
        Assert.assertNotNull((Object)program);
        int start = Integer.valueOf((String)testFile.getConfig().get("start"));
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameClassMemberProcessor processor = new RenameClassMemberProcessor(file, selectedNode);
        processor.setNewElementName((String)testFile.getConfig().get("newName"));
        processor.setUpdateTextualMatches(Boolean.valueOf((String)testFile.getConfig().get("updateTextualMatches")).booleanValue());
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        this.checkTestResult(testFile);
    }
}

