/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.ClosableWizardDialog;
import org.eclipse.php.internal.server.ui.PixelConverter;
import org.eclipse.php.internal.server.ui.ServerEditDialog;
import org.eclipse.php.internal.server.ui.ServerWizard;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

public class PHPServersConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_DEFAULT = 3;
    private IStatus fServersStatus;
    private ListDialogField fServersList;
    private PreferencePage fMainPreferencePage;

    public PHPServersConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        Assert.isNotNull((Object)mainPreferencePage);
        Assert.isNotNull((Object)store);
        this.fMainPreferencePage = mainPreferencePage;
    }

    public Control createControl(Composite parent) {
        ServerAdapter adapter = new ServerAdapter();
        String[] buttons = new String[]{PHPServerUIMessages.getString("PHPServersConfigurationBlock.new"), PHPServerUIMessages.getString("PHPServersConfigurationBlock.edit"), PHPServerUIMessages.getString("PHPServersConfigurationBlock.remove"), PHPServerUIMessages.getString("PHPServersConfigurationBlock.setDefault")};
        this.fServersList = new ListDialogField(adapter, buttons, (ILabelProvider)new PHPServersLabelProvider()){

            protected boolean managedButtonPressed(int index) {
                if (index == this.getRemoveButtonIndex()) {
                    PHPServersConfigurationBlock.this.handleRemoveServer();
                }
                return super.managedButtonPressed(index);
            }
        };
        this.fServersList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fServersList.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{PHPServerUIMessages.getString("PHPServersConfigurationBlock.name"), PHPServerUIMessages.getString("PHPServersConfigurationBlock.url")};
        ColumnLayoutData[] layoutDatas = new ColumnLayoutData[]{new ColumnWeightData(40), new ColumnWeightData(40)};
        this.fServersList.setTableColumns(new ListDialogField.ColumnsDescription(layoutDatas, columnsHeaders, true));
        if (this.fServersList.getSize() > 0) {
            this.fServersList.selectFirstElement();
        } else {
            this.fServersList.enableButton(1, false);
        }
        this.fServersStatus = new StatusInfo();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)parent);
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(parent, 768);
        Composite composite = new Composite((Composite)scrolledCompositeImpl, 0);
        composite.setLayout((Layout)layout);
        scrolledCompositeImpl.setContent((Control)composite);
        scrolledCompositeImpl.setLayout((Layout)layout);
        scrolledCompositeImpl.setFont(parent.getFont());
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.fServersList.getListControl(composite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.fServersList.getButtonBox(composite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        this.addFiller(composite);
        Point size = composite.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(size.x, size.y);
        return scrolledCompositeImpl;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    protected void sideButtonPressed(int index) {
        List selectedElements;
        if (index == 0) {
            Server newServer = this.getServerFromWizard();
            if (newServer != null) {
                this.fServersList.addElement((Object)newServer);
                ServersManager.addServer((Server)newServer);
                ServersManager.save();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PHPServersConfigurationBlock.this.fServersList.refresh();
                    }
                });
            }
        } else if (index == 1) {
            this.handleEditServerButtonSelected();
            this.fServersList.refresh();
        } else if (index == 3 && (selectedElements = this.fServersList.getSelectedElements()).size() > 0) {
            Server server = (Server)selectedElements.get(0);
            ServersManager.setDefaultServer(null, (Server)server);
            ServersManager.save();
            this.fServersList.refresh();
        }
    }

    protected Server getServerFromWizard() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor monitor = new NullProgressMonitor();
        Server theServer = null;
        ServerWizard wizard = new ServerWizard();
        ClosableWizardDialog dialog = new ClosableWizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 1) {
            monitor.setCanceled(true);
            return null;
        }
        theServer = (Server)wizard.getRootFragment().getWizardModel().getObject("server");
        return theServer;
    }

    protected void handleEditServerButtonSelected() {
        Server server = (Server)this.fServersList.getSelectedElements().get(0);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor monitor = new NullProgressMonitor();
        ServerEditDialog dialog = new ServerEditDialog(shell, server);
        if (dialog.open() == 1) {
            monitor.setCanceled(true);
            return;
        }
        ServersManager.save();
    }

    protected void handleRemoveServer() {
        Server server = (Server)this.fServersList.getSelectedElements().get(0);
        ServersManager.removeServer((String)server.getName());
        ServersManager.save();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PHPServersConfigurationBlock.this.fServersList.refresh();
            }
        });
    }

    protected void updateStatus() {
        this.fMainPreferencePage.setValid(this.fServersStatus.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, (IStatus)this.fServersStatus);
    }

    public void initialize() {
        ArrayList servers = new ArrayList();
        this.populateServerList(servers);
        this.fServersList.setElements(servers);
    }

    public void dispose() {
    }

    public void performDefaults() {
    }

    public void performOk() {
    }

    protected void populateServerList(List serverList) {
        Server[] servers = ServersManager.getServers();
        if (serverList == null) {
            serverList = new ArrayList<Server>();
        }
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                Server server = servers[i];
                serverList.add(server);
                ++i;
            }
        }
    }

    protected boolean isDefault(Server element) {
        return ServersManager.getDefaultServer(null) == element;
    }

    private class PHPServersLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private PHPServersLabelProvider() {
        }

        public Font getFont(Object element) {
            if (PHPServersConfigurationBlock.this.isDefault((Server)element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ServersPluginImages.get("org.eclipse.php.server.ui.server.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Server server = null;
            if (!(element instanceof Server)) {
                return super.getText(element);
            }
            server = (Server)element;
            if (columnIndex == 0) {
                String serverName = server.getName();
                if (PHPServersConfigurationBlock.this.isDefault((Server)element)) {
                    serverName = String.valueOf(serverName) + PHPServerUIMessages.getString("PHPServersConfigurationBlock.workspaceDefault");
                }
                return serverName;
            }
            if (columnIndex == 1) {
                return server.getBaseURL();
            }
            return element.toString();
        }
    }

    private class ServerAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ServerAdapter() {
        }

        private boolean hasActiveSelection(List selectedElements) {
            return selectedElements.size() == 1;
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            PHPServersConfigurationBlock.this.sideButtonPressed(index);
        }

        public void doubleClicked(ListDialogField field) {
            PHPServersConfigurationBlock.this.sideButtonPressed(1);
        }

        public void selectionChanged(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(1, this.hasActiveSelection(selectedElements));
            field.enableButton(2, this.hasActiveSelection(selectedElements) && field.getElements().size() > 1);
            if (selectedElements.size() == 1) {
                field.enableButton(3, !selectedElements.get(0).equals(ServersManager.getDefaultServer(null)));
            } else {
                field.enableButton(3, false);
            }
        }
    }
}

