/* The following code was generated by JFlex 1.4.1 on 2/27/13 6:12 AM */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTagKinds;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 2/27/13 6:12 AM from the specification file
 * <tt>documentor_compiler_ast_scanner.flex</tt>
 */
public class DocumentorLexer implements IDocumentorLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_IN_TAGS = 6;
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SHORT_DESC = 2;
  public static final int ST_IN_LONG_DESC = 4;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  1,  2,  3,  4,  5,  6, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\1\11\0\1\4\2\0"+
    "\1\37\1\6\1\5\20\0\1\7\3\0\1\42\34\0\1\10\1\11"+
    "\1\15\1\26\1\16\1\32\1\22\1\20\1\25\1\0\1\34\1\31"+
    "\1\30\1\33\1\21\1\24\1\0\1\14\1\12\1\13\1\17\1\35"+
    "\1\36\1\27\1\23\1\0\1\40\1\0\1\41\uff82\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\1\0\1\1\1\0\1\1\3\2\2\3"+
    "\3\2\2\4\4\2\2\5\1\2\2\1\2\2\2\1"+
    "\2\2\3\0\1\6\1\7\2\6\2\1\2\0\1\1"+
    "\1\10\23\0\1\11\1\1\2\0\1\12\2\0\1\1"+
    "\21\0\1\13\70\0\2\13\4\0\1\14\30\0\1\15"+
    "\6\0\1\16\30\0\1\17\12\0\1\20\4\0\1\21"+
    "\6\0\1\22\3\0\1\23\2\0\1\24\12\0\1\25"+
    "\4\0\1\26\6\0\1\27\3\0\1\30\2\0\1\31"+
    "\7\0\1\32\7\0\1\33\10\0\1\34\10\0\1\35"+
    "\7\0\1\36\10\0\1\37\4\0\1\40\1\41\1\42"+
    "\2\0\1\43\1\44\3\0\1\45\2\0\1\46\2\0"+
    "\1\47\6\0\1\50\1\51\1\52\2\0\1\53\1\54"+
    "\3\0\1\55\2\0\1\56\2\0\1\57\13\0\1\60"+
    "\1\61\3\0\1\62\2\0\1\63\7\0\1\64\1\65"+
    "\3\0\1\66\2\0\1\67\1\0\1\70\2\0\1\71"+
    "\1\72\1\0\1\73\1\74\4\0\1\75\2\0\1\76"+
    "\1\77\1\0\1\100\1\101\4\0\1\102\1\0\1\103"+
    "\3\0\1\104\1\0\1\105\1\0\1\106\3\0\1\107"+
    "\1\0\1\110\2\0\1\111\1\112\1\0\1\113\2\0"+
    "\1\114\1\115\11\0\1\116\2\0\1\117\1\120\1\0"+
    "\1\121\1\0\1\122\1\123";

  private static int [] zzUnpackAction() {
    int [] result = new int[473];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\43\0\106\0\151\0\214\0\257\0\322\0\365"+
    "\0\u0118\0\u013b\0\u015e\0\u0118\0\u0181\0\u01a4\0\u01c7\0\u01ea"+
    "\0\u0118\0\u020d\0\u0230\0\u0253\0\u0276\0\u0299\0\u0118\0\u02bc"+
    "\0\u02df\0\u0302\0\u0325\0\u0348\0\u036b\0\u038e\0\u03b1\0\u03d4"+
    "\0\u03f7\0\u041a\0\u015e\0\u01a4\0\u0118\0\u0118\0\u043d\0\u0460"+
    "\0\u01ea\0\u0230\0\u0253\0\u0276\0\u0483\0\u0118\0\u04a6\0\u04c9"+
    "\0\u04ec\0\u050f\0\u0532\0\u0555\0\u0578\0\u059b\0\u05be\0\u05e1"+
    "\0\u0604\0\u0627\0\u064a\0\u066d\0\u0690\0\u06b3\0\u06d6\0\u0299"+
    "\0\u02df\0\u0118\0\u06f9\0\u0348\0\u036b\0\u0118\0\u03d4\0\u03f7"+
    "\0\u071c\0\u073f\0\u0762\0\u0785\0\u07a8\0\u07cb\0\u07ee\0\u0811"+
    "\0\u0834\0\u0857\0\u087a\0\u089d\0\u08c0\0\u08e3\0\u0906\0\u0929"+
    "\0\u094c\0\u096f\0\u0992\0\u09b5\0\u09d8\0\u09fb\0\u0a1e\0\u0a41"+
    "\0\u0a64\0\u0a87\0\u0aaa\0\u0acd\0\u0af0\0\u0b13\0\u0b36\0\u0b59"+
    "\0\u0b7c\0\u0b9f\0\u0bc2\0\u0be5\0\u0c08\0\u0c2b\0\u0c4e\0\u0c71"+
    "\0\u0c94\0\u0cb7\0\u0cda\0\u0cfd\0\u0d20\0\u0d43\0\u0d66\0\u0d89"+
    "\0\u0dac\0\u0dcf\0\u0df2\0\u0e15\0\u0e38\0\u0e5b\0\u0e7e\0\u0ea1"+
    "\0\u0ec4\0\u0ee7\0\u0f0a\0\u0f2d\0\u0f50\0\u0f73\0\u0f96\0\u0fb9"+
    "\0\u0fdc\0\u0fff\0\u1022\0\u1045\0\u1068\0\u108b\0\u10ae\0\u10d1"+
    "\0\u10f4\0\u1117\0\u113a\0\u0118\0\u115d\0\u1180\0\u11a3\0\u11c6"+
    "\0\u11e9\0\u0118\0\u120c\0\u122f\0\u1252\0\u1275\0\u1298\0\u12bb"+
    "\0\u12de\0\u1301\0\u1324\0\u1347\0\u136a\0\u138d\0\u13b0\0\u13d3"+
    "\0\u13f6\0\u1419\0\u143c\0\u145f\0\u1482\0\u14a5\0\u14c8\0\u14eb"+
    "\0\u150e\0\u1531\0\u0118\0\u1554\0\u1577\0\u159a\0\u15bd\0\u15e0"+
    "\0\u1603\0\u0118\0\u1626\0\u1649\0\u166c\0\u168f\0\u16b2\0\u16d5"+
    "\0\u16f8\0\u171b\0\u173e\0\u1761\0\u1784\0\u17a7\0\u17ca\0\u17ed"+
    "\0\u1810\0\u1833\0\u1856\0\u1879\0\u189c\0\u18bf\0\u18e2\0\u1905"+
    "\0\u1928\0\u194b\0\u0118\0\u196e\0\u1991\0\u19b4\0\u19d7\0\u19fa"+
    "\0\u1a1d\0\u1a40\0\u1a63\0\u1a86\0\u1aa9\0\u0118\0\u1acc\0\u1aef"+
    "\0\u1b12\0\u1b35\0\u0118\0\u1b58\0\u1b7b\0\u1b9e\0\u1bc1\0\u1be4"+
    "\0\u1c07\0\u0118\0\u1c2a\0\u1c4d\0\u1c70\0\u0118\0\u1c93\0\u1cb6"+
    "\0\u1cd9\0\u1cfc\0\u1d1f\0\u1d42\0\u1d65\0\u1d88\0\u1dab\0\u1dce"+
    "\0\u1df1\0\u1e14\0\u1e37\0\u0118\0\u1e5a\0\u1e7d\0\u1ea0\0\u1ec3"+
    "\0\u0118\0\u1ee6\0\u1f09\0\u1f2c\0\u1f4f\0\u1f72\0\u1f95\0\u0118"+
    "\0\u1fb8\0\u1fdb\0\u1ffe\0\u0118\0\u2021\0\u2044\0\u2067\0\u208a"+
    "\0\u20ad\0\u20d0\0\u20f3\0\u2116\0\u2139\0\u215c\0\u0118\0\u217f"+
    "\0\u21a2\0\u21c5\0\u21e8\0\u220b\0\u222e\0\u2251\0\u0118\0\u2274"+
    "\0\u2297\0\u22ba\0\u22dd\0\u2300\0\u2323\0\u2346\0\u2369\0\u0118"+
    "\0\u238c\0\u23af\0\u23d2\0\u23f5\0\u2418\0\u243b\0\u245e\0\u2481"+
    "\0\u0118\0\u24a4\0\u24c7\0\u24ea\0\u250d\0\u2530\0\u2553\0\u2576"+
    "\0\u0118\0\u2599\0\u25bc\0\u25df\0\u2602\0\u2625\0\u2648\0\u266b"+
    "\0\u268e\0\u0118\0\u26b1\0\u26d4\0\u26f7\0\u271a\0\u0118\0\u0118"+
    "\0\u273d\0\u2760\0\u2783\0\u0118\0\u0118\0\u27a6\0\u27c9\0\u27ec"+
    "\0\u0118\0\u280f\0\u2832\0\u0118\0\u2855\0\u2878\0\u0118\0\u289b"+
    "\0\u28be\0\u28e1\0\u2904\0\u2927\0\u294a\0\u0118\0\u0118\0\u296d"+
    "\0\u2990\0\u29b3\0\u0118\0\u0118\0\u29d6\0\u29f9\0\u2a1c\0\u0118"+
    "\0\u2a3f\0\u2a62\0\u0118\0\u2a85\0\u2aa8\0\u0118\0\u2acb\0\u2aee"+
    "\0\u2b11\0\u2b34\0\u2b57\0\u2b7a\0\u2b9d\0\u2bc0\0\u2be3\0\u2c06"+
    "\0\u2c29\0\u0118\0\u0118\0\u2c4c\0\u2c6f\0\u2c92\0\u0118\0\u2cb5"+
    "\0\u2cd8\0\u0118\0\u2cfb\0\u2d1e\0\u2d41\0\u2d64\0\u2d87\0\u2daa"+
    "\0\u2dcd\0\u0118\0\u0118\0\u2df0\0\u2e13\0\u2e36\0\u0118\0\u2e59"+
    "\0\u2e7c\0\u0118\0\u2e9f\0\u0118\0\u2ec2\0\u2ee5\0\u0118\0\u0118"+
    "\0\u2f08\0\u2f2b\0\u0118\0\u2f4e\0\u2f71\0\u2f94\0\u2fb7\0\u0118"+
    "\0\u2fda\0\u2ffd\0\u0118\0\u0118\0\u3020\0\u3043\0\u0118\0\u3066"+
    "\0\u3089\0\u30ac\0\u30cf\0\u0118\0\u30f2\0\u0118\0\u3115\0\u3138"+
    "\0\u315b\0\u0118\0\u317e\0\u0118\0\u31a1\0\u0118\0\u31c4\0\u31e7"+
    "\0\u320a\0\u0118\0\u322d\0\u0118\0\u3250\0\u3273\0\u0118\0\u0118"+
    "\0\u3296\0\u0118\0\u32b9\0\u32dc\0\u0118\0\u0118\0\u32ff\0\u3322"+
    "\0\u3345\0\u3368\0\u338b\0\u33ae\0\u33d1\0\u33f4\0\u3417\0\u0118"+
    "\0\u343a\0\u345d\0\u0118\0\u0118\0\u3480\0\u0118\0\u34a3\0\u0118"+
    "\0\u0118";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[473];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\50\11\1\12\36\11\1\13\1\14\1\15\1\16\1\11"+
    "\1\17\35\11\1\20\1\21\1\22\1\23\1\11\1\17"+
    "\1\24\30\11\1\25\3\11\1\26\1\27\1\30\1\31"+
    "\37\11\1\32\1\27\1\30\1\33\2\11\1\24\30\11"+
    "\1\25\3\11\1\34\1\27\1\30\1\35\37\11\1\36"+
    "\1\27\1\30\1\37\2\11\1\40\30\11\1\41\2\11"+
    "\47\0\1\42\37\0\1\43\2\0\1\44\1\0\1\45"+
    "\36\0\1\14\45\0\1\46\36\0\1\47\1\45\1\50"+
    "\40\0\1\51\1\21\1\22\1\52\1\0\1\45\1\53"+
    "\30\0\1\54\4\0\1\21\41\0\1\55\1\21\1\22"+
    "\1\0\1\56\1\0\1\53\30\0\1\54\12\0\1\57"+
    "\1\0\1\60\1\61\1\62\1\63\1\64\1\65\2\0"+
    "\1\66\1\0\1\67\1\70\1\71\1\0\1\72\1\73"+
    "\1\74\1\75\1\0\1\76\14\0\1\77\34\0\1\100"+
    "\2\0\1\101\40\0\1\27\45\0\1\102\36\0\1\32"+
    "\2\0\1\33\2\0\1\53\30\0\1\54\3\0\1\103"+
    "\3\0\1\102\1\0\1\53\30\0\1\54\3\0\1\104"+
    "\2\0\1\105\43\0\1\106\36\0\1\36\2\0\1\37"+
    "\2\0\1\107\30\0\1\110\3\0\1\111\3\0\1\106"+
    "\1\0\1\107\30\0\1\110\12\0\1\112\1\0\1\113"+
    "\1\114\1\115\1\116\1\117\1\120\2\0\1\121\1\0"+
    "\1\122\1\123\1\124\1\0\1\125\1\126\1\127\1\130"+
    "\1\0\1\131\14\0\1\132\37\0\1\133\37\0\1\47"+
    "\43\0\1\45\41\0\1\55\1\21\1\22\3\0\1\53"+
    "\30\0\1\54\13\0\1\134\3\0\1\135\1\0\1\136"+
    "\36\0\1\137\2\0\1\140\1\141\5\0\1\142\34\0"+
    "\1\143\1\144\1\145\37\0\1\146\34\0\1\147\10\0"+
    "\1\150\50\0\1\151\25\0\1\152\61\0\1\153\21\0"+
    "\1\154\3\0\1\155\50\0\1\156\10\0\1\157\25\0"+
    "\1\160\42\0\1\161\51\0\1\162\42\0\1\163\25\0"+
    "\1\164\42\0\1\165\5\0\1\166\51\0\1\167\16\0"+
    "\1\103\5\0\1\53\30\0\1\54\3\0\1\111\5\0"+
    "\1\107\30\0\1\110\13\0\1\170\3\0\1\171\1\0"+
    "\1\172\36\0\1\173\2\0\1\174\1\175\5\0\1\176"+
    "\34\0\1\177\1\200\1\201\37\0\1\202\34\0\1\203"+
    "\10\0\1\204\50\0\1\205\25\0\1\206\61\0\1\207"+
    "\21\0\1\210\3\0\1\211\50\0\1\212\10\0\1\213"+
    "\25\0\1\214\42\0\1\215\51\0\1\216\42\0\1\217"+
    "\25\0\1\220\42\0\1\221\5\0\1\222\51\0\1\223"+
    "\16\0\1\133\1\224\1\225\51\0\1\226\45\0\1\227"+
    "\40\0\1\230\37\0\1\231\50\0\1\232\35\0\1\233"+
    "\64\0\1\234\22\0\1\235\43\0\1\236\54\0\1\237"+
    "\27\0\1\240\42\0\1\241\53\0\1\242\26\0\1\243"+
    "\50\0\1\244\45\0\1\245\35\0\1\246\1\247\46\0"+
    "\1\250\54\0\1\251\22\0\1\252\41\0\1\253\11\0"+
    "\1\254\31\0\1\255\44\0\1\256\15\0\1\257\40\0"+
    "\1\260\1\0\1\261\37\0\1\262\26\0\1\263\42\0"+
    "\1\264\61\0\1\265\21\0\1\266\45\0\1\267\40\0"+
    "\1\270\37\0\1\271\50\0\1\272\35\0\1\273\64\0"+
    "\1\274\22\0\1\275\43\0\1\276\54\0\1\277\27\0"+
    "\1\300\42\0\1\301\53\0\1\302\26\0\1\303\50\0"+
    "\1\304\45\0\1\305\35\0\1\306\1\307\46\0\1\310"+
    "\54\0\1\311\22\0\1\312\41\0\1\313\11\0\1\314"+
    "\31\0\1\315\44\0\1\316\15\0\1\317\40\0\1\320"+
    "\1\0\1\321\37\0\1\322\26\0\1\323\42\0\1\324"+
    "\61\0\1\325\11\0\1\224\53\0\1\326\45\0\1\327"+
    "\44\0\1\330\35\0\1\331\53\0\1\332\33\0\1\333"+
    "\46\0\1\334\42\0\1\335\42\0\1\336\40\0\1\337"+
    "\41\0\1\340\47\0\1\341\47\0\1\342\24\0\1\343"+
    "\41\0\1\344\41\0\1\345\66\0\1\346\32\0\1\347"+
    "\37\0\1\350\37\0\1\351\41\0\1\352\41\0\1\353"+
    "\46\0\1\354\40\0\1\355\60\0\1\356\24\0\1\357"+
    "\34\0\1\360\50\0\1\361\36\0\1\362\50\0\1\363"+
    "\35\0\1\364\45\0\1\365\44\0\1\366\35\0\1\367"+
    "\53\0\1\370\33\0\1\371\46\0\1\372\42\0\1\373"+
    "\42\0\1\374\40\0\1\375\41\0\1\376\47\0\1\377"+
    "\47\0\1\u0100\24\0\1\u0101\41\0\1\u0102\41\0\1\u0103"+
    "\66\0\1\u0104\32\0\1\u0105\37\0\1\u0106\37\0\1\u0107"+
    "\41\0\1\u0108\41\0\1\u0109\46\0\1\u010a\40\0\1\u010b"+
    "\60\0\1\u010c\24\0\1\u010d\34\0\1\u010e\50\0\1\u010f"+
    "\36\0\1\u0110\50\0\1\u0111\36\0\1\u0112\40\0\1\u0113"+
    "\51\0\1\u0114\46\0\1\u0115\25\0\1\u0116\50\0\1\u0117"+
    "\40\0\1\u0118\64\0\1\u0119\20\0\1\u011a\50\0\1\u011b"+
    "\34\0\1\u011c\52\0\1\u011d\26\0\1\u011e\62\0\1\u011f"+
    "\22\0\1\u0120\50\0\1\u0121\40\0\1\u0122\42\0\1\u0123"+
    "\44\0\1\u0124\45\0\1\u0125\54\0\1\u0126\21\0\1\u0127"+
    "\61\0\1\u0128\23\0\1\u0129\55\0\1\u012a\33\0\1\u012b"+
    "\40\0\1\u012c\40\0\1\u012d\51\0\1\u012e\46\0\1\u012f"+
    "\25\0\1\u0130\50\0\1\u0131\40\0\1\u0132\64\0\1\u0133"+
    "\20\0\1\u0134\50\0\1\u0135\34\0\1\u0136\52\0\1\u0137"+
    "\26\0\1\u0138\62\0\1\u0139\22\0\1\u013a\50\0\1\u013b"+
    "\40\0\1\u013c\42\0\1\u013d\44\0\1\u013e\45\0\1\u013f"+
    "\54\0\1\u0140\21\0\1\u0141\61\0\1\u0142\23\0\1\u0143"+
    "\55\0\1\u0144\33\0\1\u0145\34\0\1\u0146\44\0\1\u0147"+
    "\44\0\1\u0148\43\0\1\u0149\42\0\1\u014a\52\0\1\u014b"+
    "\27\0\1\u014c\63\0\1\u014d\30\0\1\u014e\46\0\1\u014f"+
    "\46\0\1\u0150\42\0\1\u0151\33\0\1\u0152\34\0\1\u0153"+
    "\44\0\1\u0154\57\0\1\u0155\24\0\1\u0156\53\0\1\u0157"+
    "\26\0\1\u0158\51\0\1\u0159\45\0\1\u015a\37\0\1\u015b"+
    "\35\0\1\u015c\36\0\1\u015d\44\0\1\u015e\44\0\1\u015f"+
    "\43\0\1\u0160\42\0\1\u0161\52\0\1\u0162\27\0\1\u0163"+
    "\63\0\1\u0164\30\0\1\u0165\46\0\1\u0166\46\0\1\u0167"+
    "\42\0\1\u0168\33\0\1\u0169\34\0\1\u016a\44\0\1\u016b"+
    "\57\0\1\u016c\24\0\1\u016d\53\0\1\u016e\26\0\1\u016f"+
    "\51\0\1\u0170\45\0\1\u0171\37\0\1\u0172\35\0\1\u0173"+
    "\43\0\1\u0174\62\0\1\u0175\41\0\1\u0176\16\0\1\u0177"+
    "\46\0\1\u0178\50\0\1\u0179\36\0\1\u017a\42\0\1\u017b"+
    "\37\0\1\u017c\37\0\1\u017d\42\0\1\u017e\50\0\1\u017f"+
    "\43\0\1\u0180\33\0\1\u0181\65\0\1\u0182\34\0\1\u0183"+
    "\32\0\1\u0184\62\0\1\u0185\41\0\1\u0186\16\0\1\u0187"+
    "\46\0\1\u0188\50\0\1\u0189\36\0\1\u018a\42\0\1\u018b"+
    "\37\0\1\u018c\37\0\1\u018d\42\0\1\u018e\50\0\1\u018f"+
    "\43\0\1\u0190\33\0\1\u0191\65\0\1\u0192\34\0\1\u0193"+
    "\30\0\1\u0194\37\0\1\u0195\42\0\1\u0196\63\0\1\u0197"+
    "\34\0\1\u0198\37\0\1\u0199\45\0\1\u019a\50\0\1\u019b"+
    "\24\0\1\u019c\43\0\1\u019d\43\0\1\u019e\40\0\1\u019f"+
    "\42\0\1\u01a0\37\0\1\u01a1\42\0\1\u01a2\63\0\1\u01a3"+
    "\34\0\1\u01a4\37\0\1\u01a5\45\0\1\u01a6\50\0\1\u01a7"+
    "\24\0\1\u01a8\43\0\1\u01a9\43\0\1\u01aa\40\0\1\u01ab"+
    "\43\0\1\u01ac\50\0\1\u01ad\33\0\1\u01ae\66\0\1\u01af"+
    "\21\0\1\u01b0\41\0\1\u01b1\43\0\1\u01b2\52\0\1\u01b3"+
    "\30\0\1\u01b4\50\0\1\u01b5\33\0\1\u01b6\66\0\1\u01b7"+
    "\21\0\1\u01b8\41\0\1\u01b9\43\0\1\u01ba\66\0\1\u01bb"+
    "\16\0\1\u01bc\40\0\1\u01bd\21\0\1\u01be\32\0\1\u01bf"+
    "\32\0\1\u01c0\45\0\1\u01c1\37\0\1\u01c2\40\0\1\u01c3"+
    "\21\0\1\u01c4\32\0\1\u01c5\32\0\1\u01c6\45\0\1\u01c7"+
    "\37\0\1\u01c8\40\0\1\u01c9\43\0\1\u01ca\43\0\1\u01cb"+
    "\40\0\1\u01cc\43\0\1\u01cd\35\0\1\u01ce\57\0\1\u01cf"+
    "\56\0\1\u01d0\11\0\1\u01d1\57\0\1\u01d2\56\0\1\u01d3"+
    "\27\0\1\u01d4\27\0\1\u01d5\55\0\1\u01d6\27\0\1\u01d7"+
    "\45\0\1\u01d8\42\0\1\u01d9\24\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[13510];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\1\1\1\0\1\1\1\0\1\1\1\11\2\1"+
    "\1\11\4\1\1\11\5\1\1\11\12\1\3\0\2\11"+
    "\4\1\2\0\1\1\1\11\23\0\1\11\1\1\2\0"+
    "\1\11\2\0\1\1\21\0\1\1\70\0\1\11\1\1"+
    "\4\0\1\11\30\0\1\11\6\0\1\11\30\0\1\11"+
    "\12\0\1\11\4\0\1\11\6\0\1\11\3\0\1\11"+
    "\2\0\1\1\12\0\1\11\4\0\1\11\6\0\1\11"+
    "\3\0\1\11\2\0\1\1\7\0\1\11\7\0\1\11"+
    "\10\0\1\11\10\0\1\11\7\0\1\11\10\0\1\11"+
    "\4\0\2\11\1\1\2\0\2\11\3\0\1\11\2\0"+
    "\1\11\2\0\1\11\6\0\2\11\1\1\2\0\2\11"+
    "\3\0\1\11\2\0\1\11\2\0\1\11\13\0\2\11"+
    "\3\0\1\11\2\0\1\11\7\0\2\11\3\0\1\11"+
    "\2\0\1\11\1\0\1\11\2\0\2\11\1\0\1\1"+
    "\1\11\4\0\1\11\2\0\2\11\1\0\1\1\1\11"+
    "\4\0\1\11\1\0\1\11\3\0\1\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\1\0\1\11\2\0\2\11"+
    "\1\0\1\11\2\0\2\11\11\0\1\11\2\0\2\11"+
    "\1\0\1\11\1\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[473];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private String shortDesc = null;
    private String longDesc = null;
    private ArrayList<PHPDocTag> tagList = null;
    private int currTagId = 0;
    private int tagPosition = 0;
    private StringBuffer sBuffer = null;
    private int numOfLines = 0;
    private int startPos = 0;
	private List<Scalar> textList;

	public PHPDocBlock parse() {
		int start = zzStartRead - zzPushbackPos;
		longDesc = "";
		tagList = new ArrayList<PHPDocTag>();
		textList = new ArrayList<Scalar>();
		sBuffer = new StringBuffer();
		numOfLines = 1;

		// start parsing
		try {
			next_token();
		} catch (IOException e) {
			Logger.logException(e);
		}
		if (!tagList.isEmpty() && !textList.isEmpty()) {
			// lastText is empty if the last line only contains '*/' and white
			// spaces
			Scalar lastText = textList.get(textList.size() - 1);
			PHPDocTag lastTag = tagList.get(tagList.size() - 1);
			if (lastText.sourceEnd() >= lastTag.sourceEnd()) {
				textList.remove(textList.size() - 1);
				if (!isBlank(lastText.getValue())) {
					lastTag.getTexts().add(lastText);
				}
			}
		}

		PHPDocTag[] tags = new PHPDocTag[tagList.size()];
		tagList.toArray(tags);

		PHPDocBlock rv = new PHPDocBlock(start, zzMarkedPos - zzPushbackPos,
				shortDesc, longDesc, tags, textList);

		return rv;

	}

	private boolean isBlank(String value) {
		char[] line = value.toCharArray();
		for (int i = 0; i < line.length; i++) {
			char c = line[i];
			if (c != '\t' && c != ' ') {
				return false;
			}
		}
		return true;
	}

	private void startTagsState(int firstState) {
		updateStartPos();
		hendleDesc();
		currTagId = firstState;
		tagPosition = findTagPosition();
		sBuffer = new StringBuffer();
		yybegin(ST_IN_TAGS);
	}

	private int findTagPosition() {
		for (int i = zzStartRead; i < zzMarkedPos; i++) {
			if (zzBuffer[i] == '@') {
				return i - zzPushbackPos;
			}
		}
		return -1;
	}

	private void setNewTag(int newTag) {
		updateStartPos();
		setTagValue();

		sBuffer = new StringBuffer();
		currTagId = newTag;
		tagPosition = findTagPosition();
	}

	private void setTagValue() {
		String value = sBuffer.toString();
		// special case for backward compatibility
		if (currTagId == PHPDocTagKinds.DESC) {
			shortDesc = shortDesc + value;
			return;
		}

		PHPDocTag basicPHPDocTag = new PHPDocTag(tagPosition, zzStartRead
				- zzPushbackPos, currTagId, value, getTexts(tagPosition,
				zzStartRead, true));
		tagList.add(basicPHPDocTag);
	}

	private List<Scalar> getTexts(int start, int end, boolean remove) {
		List<Scalar> result = new ArrayList<Scalar>();
		for (Iterator iterator = textList.iterator(); iterator.hasNext();) {
			Scalar scalar = (Scalar) iterator.next();
			if (scalar.sourceStart() >= start && scalar.sourceEnd() <= end) {
				result.add(scalar);
				if (remove) {
					iterator.remove();
				}
			}
		}
		// Scalar[] texts = new Scalar[result.size()];
		// result.toArray(texts);
		return result;
	}

	private void appendText() {
		if (oldString != null) {
			sBuffer.append(oldString);
		}
		StringBuffer sb = new StringBuffer();
		sb.append(zzBuffer, startPos, zzMarkedPos - startPos);
		addText(sb.toString());
		sBuffer.append(sb);
		updateStartPos();
	}

	private void addText(String string) {
		textList.add(new Scalar(startPos, startPos + string.length(), string,
				Scalar.TYPE_STRING));
	}

    private void hendleDesc() {
        if(zzLexicalState == ST_IN_SHORT_DESC){
            shortDesc = sBuffer.toString().trim();
        }
        else{
            longDesc = sBuffer.toString().trim();
        }

        sBuffer = new StringBuffer();
    }

	private void startLongDescState(boolean withNewLine) {
		hendleDesc();
		updateStartPos();
		if (!withNewLine) {
			addText("");
		}
		yybegin(ST_IN_LONG_DESC);
	}

	private void hendleNewLine() {
		appendText();
		if (numOfLines == 4) {
			int firstLineEnd = sBuffer.indexOf("\n", 1);
			shortDesc = sBuffer.substring(0, firstLineEnd);
			shortDesc = shortDesc.trim();
			sBuffer.delete(0, firstLineEnd);
			yybegin(ST_IN_LONG_DESC);
		} else {
			numOfLines++;
		}
	}
	private void appendLastText() {
		StringBuffer sb = new StringBuffer();
		sb.append(zzBuffer, startPos, zzMarkedPos - startPos - 2);
		addText(sb.toString());
		sBuffer.append(sb);
		updateStartPos();
	}

    int maxNumberofLines = 4;

    private void handleDocEnd_shortDesc() {
        appendLastText();
        if(numOfLines==maxNumberofLines){
            int firstLineEnd = sBuffer.indexOf("\n",1);
            shortDesc = sBuffer.substring(0,firstLineEnd);
            shortDesc = shortDesc.trim();
            sBuffer.delete(0,firstLineEnd);
            longDesc = sBuffer.toString().trim();
        }
        else{
            shortDesc = sBuffer.toString().trim();
        }
    }

    private void handleDocEnd_longDesc() {
       appendLastText();
       longDesc = sBuffer.toString().trim();
    }

    private void handleDocEnd_inTags() {
        appendLastText();
        setTagValue();
    }


    private void updateStartPos(){
        startPos = zzMarkedPos;
        oldString = null;
    }
    
    public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
    	this.zzReader = reader;
    	this.zzBuffer = buffer;
    	this.zzMarkedPos = parameters[0];
    	this.zzPushbackPos = parameters[1];
    	this.zzCurrentPos = parameters[2];
    	this.zzStartRead = parameters[3];
    	this.zzEndRead = parameters[4];
    	this.yyline = parameters[5];  
    }
    
    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
    }
    
    public char[] getBuffer(){
    	return zzBuffer;
    }
    


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DocumentorLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public DocumentorLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 96) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


    /* The following fields are added in order to support the change in zzRefill */
    
     String oldString=null;
    
 /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
	
	oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 16: 
          { startTagsState(PHPDocTagKinds.TODO);
          }
        case 84: break;
        case 44: 
          { setNewTag(PHPDocTagKinds.RETURN);
          }
        case 85: break;
        case 51: 
          { startTagsState(PHPDocTagKinds.VERSION);
          }
        case 86: break;
        case 45: 
          { setNewTag(PHPDocTagKinds.GLOBAL);
          }
        case 87: break;
        case 68: 
          { startTagsState(PHPDocTagKinds.NAMESPACE);
          }
        case 88: break;
        case 73: 
          { startTagsState(PHPDocTagKinds.DEPRECATED);
          }
        case 89: break;
        case 32: 
          { startTagsState(PHPDocTagKinds.ACCESS);
          }
        case 90: break;
        case 13: 
          { startTagsState(PHPDocTagKinds.VAR);
          }
        case 91: break;
        case 70: 
          { setNewTag(PHPDocTagKinds.COPYRIGHT);
          }
        case 92: break;
        case 15: 
          { setNewTag(PHPDocTagKinds.VAR);
          }
        case 93: break;
        case 42: 
          { setNewTag(PHPDocTagKinds.STATIC);
          }
        case 94: break;
        case 59: 
          { startTagsState(PHPDocTagKinds.PROPERTY);
          }
        case 95: break;
        case 18: 
          { startTagsState(PHPDocTagKinds.DESC);
          }
        case 96: break;
        case 63: 
          { setNewTag(PHPDocTagKinds.CATEGORY);
          }
        case 97: break;
        case 12: 
          { startTagsState(PHPDocTagKinds.SEE);
          }
        case 98: break;
        case 14: 
          { setNewTag(PHPDocTagKinds.SEE);
          }
        case 99: break;
        case 50: 
          { startTagsState(PHPDocTagKinds.LICENSE);
          }
        case 100: break;
        case 21: 
          { setNewTag(PHPDocTagKinds.TODO);
          }
        case 101: break;
        case 43: 
          { setNewTag(PHPDocTagKinds.THROWS);
          }
        case 102: break;
        case 65: 
          { setNewTag(PHPDocTagKinds.INTERNAL);
          }
        case 103: break;
        case 20: 
          { startTagsState(PHPDocTagKinds.NAME);
          }
        case 104: break;
        case 19: 
          { startTagsState(PHPDocTagKinds.LINK);
          }
        case 105: break;
        case 17: 
          { startTagsState(PHPDocTagKinds.USES);
          }
        case 106: break;
        case 23: 
          { setNewTag(PHPDocTagKinds.DESC);
          }
        case 107: break;
        case 52: 
          { setNewTag(PHPDocTagKinds.EXAMPLE);
          }
        case 108: break;
        case 9: 
          { handleDocEnd_longDesc();return -1;
          }
        case 109: break;
        case 29: 
          { setNewTag(PHPDocTagKinds.SINCE);
          }
        case 110: break;
        case 31: 
          { setNewTag(PHPDocTagKinds.FINAL);
          }
        case 111: break;
        case 83: 
          { setNewTag(PHPDocTagKinds.PROPERTY_WRITE);
          }
        case 112: break;
        case 47: 
          { setNewTag(PHPDocTagKinds.METHOD);
          }
        case 113: break;
        case 55: 
          { setNewTag(PHPDocTagKinds.VERSION);
          }
        case 114: break;
        case 38: 
          { startTagsState(PHPDocTagKinds.IGNORE);
          }
        case 115: break;
        case 67: 
          { startTagsState(PHPDocTagKinds.COPYRIGHT);
          }
        case 116: break;
        case 36: 
          { startTagsState(PHPDocTagKinds.RETURN);
          }
        case 117: break;
        case 69: 
          { setNewTag(PHPDocTagKinds.STATICVAR);
          }
        case 118: break;
        case 58: 
          { startTagsState(PHPDocTagKinds.CATEGORY);
          }
        case 119: break;
        case 82: 
          { startTagsState(PHPDocTagKinds.PROPERTY_WRITE);
          }
        case 120: break;
        case 49: 
          { startTagsState(PHPDocTagKinds.PACKAGE);
          }
        case 121: break;
        case 37: 
          { startTagsState(PHPDocTagKinds.GLOBAL);
          }
        case 122: break;
        case 25: 
          { setNewTag(PHPDocTagKinds.NAME);
          }
        case 123: break;
        case 26: 
          { startTagsState(PHPDocTagKinds.SINCE);
          }
        case 124: break;
        case 24: 
          { setNewTag(PHPDocTagKinds.LINK);
          }
        case 125: break;
        case 41: 
          { setNewTag(PHPDocTagKinds.AUTHOR);
          }
        case 126: break;
        case 22: 
          { setNewTag(PHPDocTagKinds.USES);
          }
        case 127: break;
        case 60: 
          { startTagsState(PHPDocTagKinds.INTERNAL);
          }
        case 128: break;
        case 77: 
          { setNewTag(PHPDocTagKinds.FILESOURCE);
          }
        case 129: break;
        case 61: 
          { setNewTag(PHPDocTagKinds.ABSTRACT);
          }
        case 130: break;
        case 62: 
          { setNewTag(PHPDocTagKinds.TUTORIAL);
          }
        case 131: break;
        case 54: 
          { setNewTag(PHPDocTagKinds.LICENSE);
          }
        case 132: break;
        case 11: 
          { updateStartPos();
        yybegin(ST_IN_SHORT_DESC);
          }
        case 133: break;
        case 30: 
          { setNewTag(PHPDocTagKinds.PARAM);
          }
        case 134: break;
        case 3: 
          { hendleNewLine();
          }
        case 135: break;
        case 1: 
          { updateStartPos();
          }
        case 136: break;
        case 28: 
          { startTagsState(PHPDocTagKinds.FINAL);
          }
        case 137: break;
        case 79: 
          { setNewTag(PHPDocTagKinds.INHERITDOC);
          }
        case 138: break;
        case 35: 
          { startTagsState(PHPDocTagKinds.THROWS);
          }
        case 139: break;
        case 40: 
          { setNewTag(PHPDocTagKinds.ACCESS);
          }
        case 140: break;
        case 6: 
          { appendText();
    startLongDescState(true);
          }
        case 141: break;
        case 34: 
          { startTagsState(PHPDocTagKinds.STATIC);
          }
        case 142: break;
        case 71: 
          { setNewTag(PHPDocTagKinds.NAMESPACE);
          }
        case 143: break;
        case 4: 
          { startLongDescState(false);
          }
        case 144: break;
        case 75: 
          { setNewTag(PHPDocTagKinds.SUBPACKAGE);
          }
        case 145: break;
        case 5: 
          { appendText();
          }
        case 146: break;
        case 81: 
          { setNewTag(PHPDocTagKinds.PROPERTY_READ);
          }
        case 147: break;
        case 66: 
          { startTagsState(PHPDocTagKinds.STATICVAR);
          }
        case 148: break;
        case 39: 
          { startTagsState(PHPDocTagKinds.METHOD);
          }
        case 149: break;
        case 27: 
          { startTagsState(PHPDocTagKinds.PARAM);
          }
        case 150: break;
        case 53: 
          { setNewTag(PHPDocTagKinds.PACKAGE);
          }
        case 151: break;
        case 56: 
          { startTagsState(PHPDocTagKinds.ABSTRACT);
          }
        case 152: break;
        case 57: 
          { startTagsState(PHPDocTagKinds.TUTORIAL);
          }
        case 153: break;
        case 76: 
          { setNewTag(PHPDocTagKinds.DEPRECATED);
          }
        case 154: break;
        case 74: 
          { startTagsState(PHPDocTagKinds.FILESOURCE);
          }
        case 155: break;
        case 33: 
          { startTagsState(PHPDocTagKinds.AUTHOR);
          }
        case 156: break;
        case 80: 
          { startTagsState(PHPDocTagKinds.PROPERTY_READ);
          }
        case 157: break;
        case 78: 
          { startTagsState(PHPDocTagKinds.INHERITDOC);
          }
        case 158: break;
        case 7: 
          { maxNumberofLines = 4;
    handleDocEnd_shortDesc();
    return -1;
          }
        case 159: break;
        case 46: 
          { setNewTag(PHPDocTagKinds.IGNORE);
          }
        case 160: break;
        case 64: 
          { setNewTag(PHPDocTagKinds.PROPERTY);
          }
        case 161: break;
        case 10: 
          { handleDocEnd_inTags();return -1;
          }
        case 162: break;
        case 72: 
          { startTagsState(PHPDocTagKinds.SUBPACKAGE);
          }
        case 163: break;
        case 48: 
          { startTagsState(PHPDocTagKinds.EXAMPLE);
          }
        case 164: break;
        case 2: 
          { 
          }
        case 165: break;
        case 8: 
          { maxNumberofLines = 5;
    handleDocEnd_shortDesc();
    return -1;
          }
        case 166: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            return YYEOF;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java DocumentorLexer <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        DocumentorLexer scanner = null;
        try {
          scanner = new DocumentorLexer( new java.io.FileReader(argv[i]) );
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
