/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationUtilities;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugMessageRequestImpl;

public class AddFilesRequest
extends DebugMessageRequestImpl
implements IDebugRequestMessage {
    private int counter;
    private String[] paths;

    public void setPaths(String[] paths) {
        this.paths = new String[paths.length];
        System.arraycopy(paths, 0, this.paths, 0, paths.length);
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public int getCounter() {
        return this.counter;
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.setID(in.readInt());
        int pathSize = in.readInt();
        if (pathSize > 0) {
            String[] paths = new String[pathSize];
            int i = 0;
            while (i < pathSize) {
                paths[i] = CommunicationUtilities.readString(in);
                ++i;
            }
            this.setPaths(paths);
        }
    }

    public int getType() {
        return 38;
    }

    public void serialize(DataOutputStream out) throws IOException {
        out.writeShort(this.getType());
        out.writeInt(this.getID());
        String[] paths = this.getPaths();
        out.writeInt(paths.length);
        int i = 0;
        while (i < paths.length) {
            CommunicationUtilities.writeString(out, paths[i]);
            ++i;
        }
    }
}

