/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IStep;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.core.phar.PharPath;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.pathmapper.DebugSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceLookupDirector;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPCompositeSourceContainer;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpPreferences;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpThread;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpDebugTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.TimedEvent;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.Base64;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.EngineTypes;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBGpTarget
extends DBGpElement
implements IPHPDebugTarget,
IDBGpDebugTarget,
IStep,
IBreakpointManagerListener,
IDBGpSessionListener {
    private String sessionID;
    private String ideKey;
    private boolean webLaunch = false;
    private boolean multiSessionManaged = false;
    private IProcess process;
    private IWebBrowser browser;
    private String stopDebugURL;
    private volatile int targetState;
    private static final int STATE_CREATE = 0;
    private static final int STATE_INIT_SESSION_WAIT = 1;
    private static final int STATE_STARTED_SUSPENDED = 2;
    private static final int STATE_STARTED_RUNNING = 3;
    private static final int STATE_STARTED_SESSION_WAIT = 4;
    private static final int STATE_TERMINATING = 5;
    private static final int STATE_TERMINATED = 6;
    private static final int STATE_DISCONNECTED = 7;
    private String projectScript;
    private String name;
    private ILaunch launch;
    private DBGpThread langThread;
    private IThread[] allThreads;
    private int currentStackLevel;
    private IStackFrame[] stackFrames;
    private IVariable[] currentVariables;
    private DBGpBreakpointFacade bpFacade;
    private IVariable[] superGlobalVars;
    private Vector<DBGpBreakpointCmd> DBGpCmdQueue = new Vector();
    private volatile DBGpSession session;
    private DBGpPreferences sessionPreferences;
    private Object sessionMutex = new Object();
    private TimedEvent te = new TimedEvent();
    private boolean stopAtStart;
    private boolean asyncSupported;
    private boolean stepping;
    private PathMapper pathMapper = null;
    private DebugOutput debugOutput = new DebugOutput();

    private DBGpTarget() {
        super(null);
        this.setState(0);
        this.ideKey = DBGpSessionHandler.getInstance().getIDEKey();
        this.allThreads = new IThread[0];
        this.fireCreationEvent();
    }

    public DBGpTarget(ILaunch launch, String projectRelativeScript, String ideKey, String sessionID, boolean stopAtStart) {
        this();
        this.stopAtStart = stopAtStart;
        this.launch = launch;
        this.projectScript = projectRelativeScript;
        this.ideKey = ideKey;
        this.webLaunch = false;
        this.sessionID = sessionID;
        this.process = null;
        this.stopDebugURL = null;
        this.browser = null;
    }

    public DBGpTarget(ILaunch launch, String workspaceRelativeScript, String stopDebugURL, String ideKey, boolean stopAtStart, IWebBrowser browser) {
        this();
        this.stopAtStart = stopAtStart;
        this.launch = launch;
        this.projectScript = workspaceRelativeScript;
        this.ideKey = ideKey;
        this.webLaunch = true;
        this.sessionID = null;
        this.stopDebugURL = stopDebugURL;
        this.browser = browser;
        this.process = null;
    }

    public void waitForInitialSession(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs, IProgressMonitor launchMonitor) {
        this.configureInitialState(facade, sessionPrefs);
        try {
            while (!(this.session != null || this.launch.isTerminated() || this.isTerminating() || launchMonitor == null || launchMonitor.isCanceled())) {
                this.te.waitForEvent(500L);
            }
            this.sessionReceived(launchMonitor);
        }
        catch (Exception exception) {
            this.terminateDebugTarget(true);
        }
    }

    public void sessionReceived(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs) {
        this.configureInitialState(facade, sessionPrefs);
        this.sessionReceived(null);
    }

    public void configureInitialState(DBGpBreakpointFacade facade, DBGpPreferences sessionPrefs) {
        this.bpFacade = facade;
        this.sessionPreferences = sessionPrefs;
        this.setState(1);
    }

    private void sessionReceived(IProgressMonitor launchMonitor) {
        boolean launchIsCanceled = false;
        if (this.session != null && this.session.isActive()) {
            if (launchMonitor != null) {
                launchIsCanceled = launchMonitor.isCanceled();
            }
            if (!(this.isTerminating() || this.launch.isTerminated() || launchIsCanceled)) {
                this.langThread = new DBGpThread(this);
                this.allThreads = new IThread[]{this.langThread};
                this.langThread.fireCreationEvent();
                IBreakpointManager bpmgr = DebugPlugin.getDefault().getBreakpointManager();
                bpmgr.addBreakpointListener((IBreakpointListener)this);
                bpmgr.addBreakpointManagerListener((IBreakpointManagerListener)this);
                this.testInitialScriptLocating();
                if (this.session != null) {
                    this.initiateSession();
                }
            } else {
                this.session.endSession();
                this.terminateDebugTarget(true);
            }
        } else {
            this.terminateDebugTarget(true);
        }
    }

    private void testInitialScriptLocating() {
        IFile file;
        String initScript = this.session.getInitialScript();
        if (initScript != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(initScript))) == null && this.pathMapper != null && this.pathMapper.getLocalFile(initScript) == null) {
            if (this.projectScript != null) {
                this.handlePDTSessionInitiation(initScript);
            } else {
                this.handleRemoteSessionInitiation(initScript);
            }
        }
    }

    private void handlePDTSessionInitiation(String initScript) {
        VirtualPath vpScr = new VirtualPath(this.projectScript);
        VirtualPath vpInit = new VirtualPath(initScript);
        if (vpScr.getLastSegment().equals(vpInit.getLastSegment())) {
            PathEntry pe = new PathEntry(this.projectScript, PathEntry.Type.WORKSPACE, (Object)ResourcesPlugin.getWorkspace().getRoot());
            this.pathMapper.addEntry(initScript, pe);
        } else {
            try {
                DebugSearchEngine.find(initScript, this);
            }
            catch (Exception exception) {}
        }
    }

    private void handleRemoteSessionInitiation(String initScript) {
        try {
            PathEntry pe = DebugSearchEngine.find(this.pathMapper, initScript, null, this);
            if (pe != null) {
                Object container = pe.getContainer();
                if (container != null && container instanceof IResource) {
                    IResource res = (IResource)container;
                    IProject prj = res.getProject();
                    PHPSourceLookupDirector dir = (PHPSourceLookupDirector)this.getLaunch().getSourceLocator();
                    ISourceContainer[] containers = new ISourceContainer[]{new PHPCompositeSourceContainer(prj, null)};
                    dir.setSourceContainers(containers);
                }
            } else if (!this.isTerminated()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_debugError, (String)PHPDebugCoreMessages.XDebug_DBGpTarget_0);
                    }
                });
                this.session.endSession();
                this.terminateDebugTarget(true);
            }
        }
        catch (Exception exception) {}
    }

    private void initiateSession() {
        if (this.targetState != 1 && this.targetState != 4) {
            DBGpLogger.logWarning("initiateSession in Wrong State: " + this.targetState, this, null);
        }
        this.stackFrames = null;
        this.currentVariables = null;
        this.superGlobalVars = null;
        this.debugOutput = new DebugOutput();
        this.session.startSession();
        this.setState(2);
        this.negotiateDBGpFeatures();
        this.loadPredefinedBreakpoints();
        if (!this.stopAtStart) {
            this.setState(3);
            this.session.sendAsyncCmd("run");
        } else {
            this.suspended(16);
            try {
                this.stepInto();
            }
            catch (DebugException debugException) {}
        }
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess proc) {
        this.process = proc;
    }

    public IThread[] getThreads() throws DebugException {
        return this.allThreads;
    }

    public boolean hasThreads() throws DebugException {
        boolean hasThreads = this.allThreads.length > 0;
        return hasThreads;
    }

    public String getName() throws DebugException {
        if (this.name == null) {
            this.name = this.isWebLaunch() || this.multiSessionManaged ? PHPDebugCoreMessages.XDebug_DBGpTarget_1 : (this.projectScript == null ? (this.session != null ? this.session.getInitialScript() : PHPDebugCoreMessages.XDebug_DBGpTarget_2) : this.projectScript);
        }
        return this.name;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        boolean canTerminate;
        boolean bl = canTerminate = 6 != this.targetState && this.targetState != 0 && 7 != this.targetState;
        if (this.process != null) {
            canTerminate = canTerminate && this.process.canTerminate();
        }
        return canTerminate;
    }

    public boolean isTerminated() {
        boolean terminated;
        boolean bl = terminated = 6 == this.targetState;
        if (this.process != null) {
            return this.process.isTerminated();
        }
        return terminated;
    }

    public boolean isTerminating() {
        boolean terminating = this.targetState == 6 || this.targetState == 5;
        return terminating;
    }

    public boolean hasStarted() {
        boolean started = 3 == this.targetState || 4 == this.targetState || 2 == this.targetState;
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        if (this.isTerminating()) {
            if (this.session == null && 5 == this.targetState) {
                this.terminateDebugTarget(true);
            }
            return;
        }
        DBGpSessionHandler.getInstance().removeSessionListener(this);
        if (2 == this.targetState) {
            Object object = this.sessionMutex;
            synchronized (object) {
                if (this.session != null && this.session.isActive()) {
                    this.setState(5);
                    this.session.sendAsyncCmd("stop");
                } else {
                    this.terminateDebugTarget(true);
                }
            }
        } else {
            this.terminateDebugTarget(true);
            if (this.isWebLaunch()) {
                this.sendStopDebugURL();
            }
        }
    }

    private void sendStopDebugURL() {
        if (this.stopDebugURL == null) {
            return;
        }
        try {
            if (this.browser != null) {
                DBGpLogger.debug("browser is not null, sending " + this.stopDebugURL);
                this.browser.openURL(new URL(this.stopDebugURL));
            } else {
                DBGpUtils.openInternalBrowserView(this.stopDebugURL);
            }
        }
        catch (PartInitException e) {
            DBGpLogger.logException("Failed to send stop URL: " + this.stopDebugURL, this, e);
        }
        catch (MalformedURLException e) {
            DBGpLogger.logException(null, this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded() {
        boolean unexpectedTermination = false;
        Object object = this.sessionMutex;
        synchronized (object) {
            this.session = null;
            if (5 == this.targetState) {
                if (this.isWebLaunch()) {
                    this.sendStopDebugURL();
                }
                this.terminateDebugTarget(true);
            } else {
                unexpectedTermination = this.isSuspended();
                if (this.isWebLaunch()) {
                    if (this.isSuspended()) {
                        this.fireResumeEvent(1);
                        this.langThread.fireResumeEvent(1);
                    }
                    this.stepping = false;
                    this.setState(4);
                    this.langThread.setBreakpoints(null);
                } else {
                    this.terminateDebugTarget(true);
                }
            }
        }
        if (unexpectedTermination) {
            final String errorMessage = PHPDebugCoreMessages.XDebugMessage_unexpectedTermination;
            Status status = new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, null);
            DebugPlugin.log((IStatus)status);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_debugError, (String)errorMessage);
                }
            });
        }
    }

    public void terminateDebugTarget(boolean isTerminate) {
        if (6 != this.targetState) {
            DBGpSessionHandler.getInstance().removeSessionListener(this);
            IBreakpointManager bpmgr = DebugPlugin.getDefault().getBreakpointManager();
            bpmgr.removeBreakpointListener((IBreakpointListener)this);
            bpmgr.removeBreakpointManagerListener((IBreakpointManagerListener)this);
            if (isTerminate && 3 == this.targetState) {
                this.setState(5);
                if (this.process != null) {
                    try {
                        this.process.terminate();
                    }
                    catch (DebugException debugException) {}
                } else if (this.session != null) {
                    this.session.endSession();
                }
            }
            this.setState(6);
            if (this.session != null) {
                this.session.endSession();
            }
            if (this.langThread != null) {
                this.langThread.fireTerminateEvent();
            }
            this.stepping = false;
            this.fireTerminateEvent();
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return this.asyncSupported;
    }

    public boolean isSuspended() {
        boolean isSuspended = 2 == this.targetState;
        return isSuspended;
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        try {
            if (this.isSuspended() && this.getCurrentStackFrames().length > 1) {
                return true;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public void stepInto() throws DebugException {
        this.stepping = true;
        this.resumed(1);
        this.session.sendAsyncCmd("step_into");
    }

    public void stepOver() throws DebugException {
        this.stepping = true;
        this.resumed(2);
        this.session.sendAsyncCmd("step_over");
    }

    public void stepReturn() throws DebugException {
        this.stepping = true;
        this.resumed(4);
        this.session.sendAsyncCmd("step_out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        this.stepping = false;
        this.resumed(1);
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                this.session.sendAsyncCmd("run");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                this.session.sendAsyncCmd("break");
            }
        }
    }

    public boolean canDisconnect() {
        boolean canDisconnect = 3 == this.targetState || 2 == this.targetState;
        return canDisconnect;
    }

    public void disconnect() throws DebugException {
        if (this.isTerminating()) {
            return;
        }
        if (3 == this.targetState || 2 == this.targetState) {
            this.setState(7);
            if (this.session != null) {
                if (!this.isWebLaunch()) {
                    if (this.multiSessionManaged && this.session.getEngineType() == EngineTypes.Xdebug && this.versionCheckLT(this.session.getEngineVersion(), "2.0.2")) {
                        this.session.sendSyncCmd("stop");
                    } else {
                        this.session.sendAsyncCmd("detach");
                    }
                    this.terminateDebugTarget(false);
                } else {
                    if (this.session.getEngineType() == EngineTypes.Xdebug && this.versionCheckLT(this.session.getEngineVersion(), "2.0.2")) {
                        this.session.sendSyncCmd("stop");
                    } else {
                        this.session.sendAsyncCmd("detach");
                    }
                    this.stepping = false;
                    this.langThread.setBreakpoints(null);
                    this.setState(4);
                    this.resumed(1);
                }
            }
        }
    }

    private boolean versionCheckLT(String engineVersion, String requiredVersion) {
        boolean isLessThan = true;
        boolean isEqual = true;
        StringTokenizer stEngine = new StringTokenizer(engineVersion, ".");
        StringTokenizer stCheck = new StringTokenizer(requiredVersion, ".");
        while (stEngine.hasMoreTokens()) {
            int checkVal;
            int engineVal;
            String engineValStr = stEngine.nextToken();
            if (!stCheck.hasMoreTokens()) continue;
            String checkValStr = stCheck.nextToken();
            try {
                engineVal = Integer.parseInt(engineValStr);
                try {
                    checkVal = Integer.parseInt(checkValStr);
                    if (engineVal > checkVal) {
                        isLessThan = false;
                        isEqual = false;
                    }
                    if (engineVal == checkVal) continue;
                    isEqual = false;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (NumberFormatException numberFormatException) {
                engineVal = this.getNumber(engineValStr);
                isEqual = false;
                try {
                    checkVal = Integer.parseInt(checkValStr);
                    if (engineVal <= checkVal) continue;
                    isLessThan = false;
                    isEqual = false;
                }
                catch (NumberFormatException numberFormatException2) {}
            }
        }
        if (stCheck.hasMoreTokens()) {
            isEqual = false;
        }
        return isLessThan && !isEqual;
    }

    private int getNumber(String engineValStr) {
        int x = -1;
        int i = 0;
        while (i < engineValStr.length()) {
            char ch = engineValStr.charAt(i);
            if (!Character.isDigit(ch) && i > 0) {
                x = Integer.parseInt(engineValStr.substring(0, i));
                break;
            }
            ++i;
        }
        return x;
    }

    public boolean isDisconnected() {
        return 7 == this.targetState || 6 == this.targetState;
    }

    private void resumed(int detail) {
        this.setState(3);
        this.fireResumeEvent(detail);
        this.langThread.fireResumeEvent(detail);
    }

    public void suspended(int detail) {
        this.setState(2);
        this.processQueuedBpCmds();
        this.stackFrames = null;
        this.currentVariables = null;
        this.superGlobalVars = null;
        this.fireSuspendEvent(detail);
        this.langThread.fireSuspendEvent(detail);
    }

    private void negotiateDBGpFeatures() {
        String supported;
        Node child;
        DBGpResponse resp = this.session.sendSyncCmd("feature_set", "-n show_hidden -v 1");
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("feature_set", "-n max_depth -v " + this.getMaxDepth());
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("feature_set", "-n max_children -v " + this.getMaxChildren());
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("feature_get", "-n encoding");
        if (DBGpUtils.isGoodDBGpResponse(this, resp) && (child = resp.getParentNode().getFirstChild()) != null) {
            String data = child.getNodeValue();
            try {
                "abcdefg".getBytes(data);
                this.session.setSessionEncoding(data);
            }
            catch (UnsupportedEncodingException uee) {
                DBGpLogger.logWarning("encoding from debug engine invalid", this, uee);
            }
        }
        this.asyncSupported = false;
        resp = this.session.sendSyncCmd("feature_get", "-n supports_async");
        if (DBGpUtils.isGoodDBGpResponse(this, resp) && (child = resp.getParentNode().getFirstChild()) != null && (supported = child.getNodeValue()) != null && supported.equals("1")) {
            this.asyncSupported = true;
        }
        resp = this.session.sendSyncCmd("stdout", "-c " + this.getCaptureStdout());
        DBGpUtils.isGoodDBGpResponse(this, resp);
        resp = this.session.sendSyncCmd("stderr", "-c " + this.getCaptureStderr());
        DBGpUtils.isGoodDBGpResponse(this, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized IStackFrame[] getCurrentStackFrames() throws DebugException {
        if (this.stackFrames == null) {
            this.currentStackLevel = 0;
            this.stackFrames = new IStackFrame[0];
            Object object = this.sessionMutex;
            synchronized (object) {
                DBGpResponse resp;
                if (this.session != null && this.session.isActive() && DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("stack_get"))) {
                    Node parent = resp.getParentNode();
                    NodeList stackNodes = parent.getChildNodes();
                    this.stackFrames = new IStackFrame[stackNodes.getLength()];
                    int i = 0;
                    while (i < stackNodes.getLength()) {
                        Node stackNode = stackNodes.item(i);
                        this.stackFrames[i] = new DBGpStackFrame(this.langThread, stackNode);
                        ++i;
                    }
                    this.currentStackLevel = stackNodes.getLength() - 1;
                }
            }
        }
        return this.stackFrames;
    }

    private IVariable[] getContextLocalVars(String level) {
        DBGpResponse resp = this.session.sendSyncCmd("context_get", "-d " + level);
        return this.parseVarResp(resp, level);
    }

    private IVariable[] getSuperGlobalVars() {
        if (this.superGlobalVars == null) {
            DBGpResponse resp = this.session.sendSyncCmd("context_get", "-c 1");
            this.superGlobalVars = this.parseVarResp(resp, "-1");
        }
        return this.superGlobalVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariable[] getVariables(String level) {
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isActive()) {
                if (level.equals("0")) {
                    if (this.currentVariables == null) {
                        this.currentVariables = this.getContextAtLevel(level);
                        return this.currentVariables;
                    }
                    DBGpLogger.debug("getVariables: returning cached variables");
                    return this.currentVariables;
                }
                return this.getContextAtLevel(level);
            }
            return new IVariable[0];
        }
    }

    private IVariable[] getContextAtLevel(String level) {
        boolean getSuperGlobals = this.showGLobals();
        IVariable[] globals = null;
        globals = getSuperGlobals ? this.getSuperGlobalVars() : new IVariable[]{};
        IVariable[] locals = this.getContextLocalVars(level);
        int totalLength = globals.length + locals.length;
        IVariable[] merged = new IVariable[totalLength];
        if (globals.length > 0) {
            System.arraycopy(globals, 0, merged, 0, globals.length);
        }
        if (locals.length > 0) {
            System.arraycopy(locals, 0, merged, globals.length, locals.length);
        }
        return merged;
    }

    private IVariable[] parseVarResp(DBGpResponse resp, String reportedLevel) {
        IVariable[] variables = new IVariable[]{};
        if (DBGpUtils.isGoodDBGpResponse(this, resp) && resp.getErrorCode() == 0) {
            Node parent = resp.getParentNode();
            NodeList properties = parent.getChildNodes();
            variables = new DBGpVariable[properties.getLength()];
            int i = 0;
            while (i < properties.getLength()) {
                Node property = properties.item(i);
                variables[i] = new DBGpVariable(this, property, reportedLevel);
                ++i;
            }
        }
        return variables;
    }

    public boolean setProperty(DBGpVariable var, String data) {
        String encoded;
        try {
            encoded = Base64.encode(data.getBytes(this.getBinaryEncoding()));
        }
        catch (UnsupportedEncodingException e1) {
            DBGpLogger.logException("unexpected encoding problem", this, e1);
            encoded = Base64.encode(data.getBytes());
        }
        String fullName = var.getFullName();
        String stackLevel = var.getStackLevel();
        String args = "-n " + fullName + " -d " + stackLevel + " -l " + encoded.length() + " -- " + encoded;
        try {
            if (var.getReferenceTypeName().equals("string")) {
                args = "-t string " + args;
            }
        }
        catch (DebugException debugException) {}
        DBGpResponse resp = this.session.sendSyncCmd("property_set", args);
        boolean success = false;
        if (DBGpUtils.isGoodDBGpResponse(this, resp) && resp.getTopAttribute("success").equals("1")) {
            if (!stackLevel.equals("0")) {
                this.currentVariables = null;
                this.superGlobalVars = null;
            }
            success = true;
        }
        return success;
    }

    public Node getProperty(String fullName, String stackLevel, int page) {
        if (fullName != null && fullName.trim().length() != 0) {
            DBGpResponse resp;
            String args = "-n " + fullName + " -d " + stackLevel + " -p " + page;
            if (stackLevel.equals("-1")) {
                args = "-n " + fullName + " -d " + this.getCurrentStackLevel() + " -p " + page;
            }
            if (DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("property_get", args))) {
                return resp.getParentNode().getFirstChild();
            }
        }
        return null;
    }

    public Node getCompleteString(String fullName, String stackLevel, int length) {
        if (fullName != null && fullName.trim().length() != 0) {
            DBGpResponse resp;
            String args = "-n " + fullName + " -d " + stackLevel;
            if (stackLevel.equals("-1")) {
                args = "-n " + fullName + " -d " + this.getCurrentStackLevel();
            }
            if (DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("property_value", args = String.valueOf(args) + " -m " + length))) {
                return resp.getParentNode();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node eval(String toEval) {
        String encoded = Base64.encode(this.getSessionEncodingBytes(toEval));
        String args = "-- " + encoded;
        Node response = null;
        Object object = this.sessionMutex;
        synchronized (object) {
            DBGpResponse resp;
            if (this.session != null && this.session.isActive() && DBGpUtils.isGoodDBGpResponse(this, resp = this.session.sendSyncCmd("eval", args))) {
                response = resp.getParentNode().getFirstChild();
            }
        }
        return response;
    }

    private synchronized void setState(int newState) {
        if (DBGpLogger.debugState()) {
            String newStateStr = "";
            switch (newState) {
                case 0: {
                    newStateStr = "STATE_CREATE";
                    break;
                }
                case 7: {
                    newStateStr = "STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    newStateStr = "INIT_SESSION_WAIT";
                    break;
                }
                case 3: {
                    newStateStr = "STATE_STARTED_RUNNING";
                    break;
                }
                case 4: {
                    newStateStr = "STATE_STARTED_SESSION_WAIT";
                    break;
                }
                case 2: {
                    newStateStr = "STATE_STARTED_SUSPENDED";
                    break;
                }
                case 6: {
                    newStateStr = "STATE_TERMINATED";
                    break;
                }
                case 5: {
                    newStateStr = "STATE_TERMINATING";
                }
            }
            DBGpLogger.debug("State Change: " + newStateStr);
        }
        this.targetState = newState;
    }

    public int getCurrentStackLevel() {
        return this.currentStackLevel;
    }

    private String mapToExternalFileIfRequired(DBGpBreakpoint bp) {
        String internalFile = "";
        String mappedFileName = null;
        if (this.pathMapper != null) {
            if (bp.getIFile() != null) {
                internalFile = bp.getIFile().getFullPath().toString();
                mappedFileName = this.pathMapper.getRemoteFile(internalFile);
            }
            if (mappedFileName == null) {
                internalFile = bp.getFileName();
                mappedFileName = this.pathMapper.getRemoteFile(internalFile);
            }
        }
        if (mappedFileName == null) {
            DBGpLogger.debug("outbound File '" + internalFile + "' Not remapped");
            mappedFileName = bp.getFileName();
        } else if (DBGpLogger.debugBP()) {
            String mapMsg = "remapped eclipse file: '" + internalFile + "' to '" + mappedFileName + "'";
            DBGpLogger.debug(mapMsg);
        }
        return mappedFileName;
    }

    public String mapToWorkspaceFileIfRequired(String decodedFile) {
        String mappedFile = null;
        PathEntry mappedPathEntry = null;
        File fileSystemFile = new File(decodedFile);
        if (fileSystemFile.exists() && this.pathMapper != null) {
            mappedPathEntry = this.pathMapper.getLocalFile(decodedFile);
        } else {
            try {
                mappedPathEntry = this.projectScript != null ? DebugSearchEngine.find(decodedFile, this) : DebugSearchEngine.find(this.pathMapper, decodedFile, null, this);
            }
            catch (Exception exception) {}
        }
        if (mappedPathEntry == null) {
            PharPath pharPath = PharPath.getPharPath((IPath)new Path("phar:" + decodedFile));
            if (pharPath != null) {
                DBGpLogger.debug("inbound File '" + decodedFile + "' remapped to phar file");
                mappedFile = "phar:" + decodedFile;
            } else {
                DBGpLogger.debug("inbound File '" + decodedFile + "' Not remapped");
                mappedFile = decodedFile;
            }
        } else {
            mappedFile = mappedPathEntry.getResolvedPath();
            IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(mappedFile));
            if (file != null) {
                IPath t = file.getRawLocation();
                mappedFile = t != null ? t.toString() : file.getFullPath().toOSString();
            }
            if (DBGpLogger.debugResp()) {
                String mapMsg = "mapped inbound file '" + decodedFile + "' to '" + mappedFile + "'";
                DBGpLogger.debug(mapMsg);
            }
        }
        return mappedFile;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.bpFacade.supportsBreakpoint(breakpoint);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    DBGpBreakpoint bp = this.bpFacade.createDBGpBreakpoint(breakpoint);
                    if (this.isSuspended() || this.asyncSupported && this.isRunning()) {
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("Breakpoint Add requested immediately");
                        }
                        this.sendBreakpointAddCmd(bp, false);
                    } else if (this.isRunning()) {
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("Breakpoint Add deferred until suspended");
                        }
                        DBGpBreakpointCmd bpSet = new DBGpBreakpointCmd("breakpoint_set", bp);
                        this.queueBpCmd(bpSet);
                    }
                }
            }
            catch (CoreException e) {
                DBGpLogger.logException("Exception adding breakpoint", this, e);
            }
        }
    }

    private void sendBreakpointAddCmd(DBGpBreakpoint bp, boolean onResponseThread) {
        DBGpResponse resp;
        bp.resetConditionChanged();
        String fileName = bp.getFileName();
        int lineNumber = bp.getLineNumber();
        String debugMsg = null;
        if (DBGpLogger.debugBP()) {
            debugMsg = "adding breakpoint to file:" + fileName + ", at Line Number: " + lineNumber;
        }
        fileName = this.mapToExternalFileIfRequired(bp);
        String args = "-t line -f " + DBGpUtils.getFileURIString(fileName) + " -n " + lineNumber;
        DBGpBreakpointCondition condition = new DBGpBreakpointCondition(bp);
        if (condition.getType() == 2) {
            if (debugMsg != null) {
                debugMsg = String.valueOf(debugMsg) + " with expression:" + condition.getExpression();
            }
            args = String.valueOf(args) + " -- " + Base64.encode(this.getSessionEncodingBytes(condition.getExpression()));
        } else if (condition.getType() == 1) {
            if (debugMsg != null) {
                debugMsg = String.valueOf(debugMsg) + " with hit :" + condition.getHitCondition() + condition.getHitValue();
            }
            args = String.valueOf(args) + " -h " + condition.getHitValue() + " -o " + condition.hitCondition;
        }
        if (debugMsg != null) {
            DBGpLogger.debug(debugMsg);
        }
        if (DBGpUtils.isGoodDBGpResponse(this, resp = onResponseThread ? this.session.sendSyncCmdOnResponseThread("breakpoint_set", args) : this.session.sendSyncCmd("breakpoint_set", args))) {
            String bpId = resp.getTopAttribute("id");
            bp.setID(Integer.parseInt(bpId));
            if (DBGpLogger.debugBP()) {
                DBGpLogger.debug("Breakpoint installed with id: " + bpId);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            DBGpBreakpoint bp = this.bpFacade.createDBGpBreakpoint(breakpoint);
            if (this.isSuspended() || this.asyncSupported && this.isRunning()) {
                if (DBGpLogger.debugBP()) {
                    DBGpLogger.debug("Immediately removing of breakpoint with ID: " + bp.getID());
                }
                this.sendBreakpointRemoveCmd(bp, false);
            } else if (this.isRunning()) {
                if (DBGpLogger.debugBP()) {
                    DBGpLogger.debug("Deferring Removing of breakpoint with ID: " + bp.getID());
                }
                DBGpBreakpointCmd bpRemove = new DBGpBreakpointCmd("breakpoint_remove", bp);
                this.queueBpCmd(bpRemove);
            }
        }
    }

    private void sendBreakpointRemoveCmd(DBGpBreakpoint bp, boolean onResponseThread) {
        String args = "-d " + bp.getID();
        if (DBGpLogger.debugBP()) {
            DBGpLogger.debug("Removing breakpoint with ID: " + bp.getID());
        }
        DBGpResponse resp = onResponseThread ? this.session.sendSyncCmdOnResponseThread("breakpoint_remove", args) : this.session.sendSyncCmd("breakpoint_remove", args);
        DBGpUtils.isGoodDBGpResponse(this, resp);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        IBreakpointManager bmgr = DebugPlugin.getDefault().getBreakpointManager();
        if (!bmgr.isEnabled()) {
            return;
        }
        int deltaLNumber = delta.getAttribute("lineNumber", 0);
        IMarker marker = breakpoint.getMarker();
        int lineNumber = marker.getAttribute("lineNumber", 0);
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                DBGpBreakpoint bp = this.bpFacade.createDBGpBreakpoint(breakpoint);
                if (bp.hasConditionChanged()) {
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("condition changed for breakpoint with ID: " + bp.getID());
                    }
                    bp.resetConditionChanged();
                    if (breakpoint.isEnabled()) {
                        this.breakpointRemoved(breakpoint, null);
                    } else {
                        return;
                    }
                }
                if (lineNumber != deltaLNumber) {
                    if (DBGpLogger.debugBP()) {
                        DBGpLogger.debug("line number changed for breakpoint with ID: " + bp.getID());
                    }
                    if (breakpoint.isEnabled()) {
                        this.breakpointRemoved(breakpoint, null);
                    } else {
                        return;
                    }
                }
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException e) {
                DBGpLogger.logException("Exception Changing Breakpoint", this, e);
            }
        }
    }

    public void breakpointHit(String filename, int lineno) {
        IBreakpoint breakpoint = this.findBreakpointHit(filename, lineno);
        if (breakpoint != null) {
            this.langThread.setBreakpoints(new IBreakpoint[]{breakpoint});
        } else {
            this.langThread.setBreakpoints(new IBreakpoint[0]);
        }
        this.suspended(16);
    }

    private IBreakpoint findBreakpointHit(String filename, int lineno) {
        return this.bpFacade.findBreakpointHit(filename, lineno);
    }

    private void loadPredefinedBreakpoints() {
        IBreakpointManager bmgr = DebugPlugin.getDefault().getBreakpointManager();
        if (!bmgr.isEnabled()) {
            return;
        }
        IBreakpoint[] breakpoints = bmgr.getBreakpoints(this.bpFacade.getBreakpointModelID());
        int i = 0;
        while (i < breakpoints.length) {
            this.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    public void runToLine(IFile fileName, int lineNumber) {
        if (DBGpLogger.debugBP()) {
            DBGpLogger.debug("runtoline: " + fileName + " " + lineNumber);
        }
        if (this.isSuspended()) {
            try {
                IBreakpoint breakpoint = this.bpFacade.createRunToLineBreakpoint(fileName, lineNumber);
                IBreakpointManager bmgr = DebugPlugin.getDefault().getBreakpointManager();
                bmgr.addBreakpoint(breakpoint);
                this.resume();
            }
            catch (DebugException e) {
                DBGpLogger.logException("Unexpected DebugException", this, e);
            }
            catch (CoreException e) {
                DBGpLogger.logException("Unexpected CoreException", this, e);
            }
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.bpFacade.getBreakpointModelID());
        int i = 0;
        while (i < breakpoints.length) {
            if (this.supportsBreakpoint(breakpoints[i])) {
                if (enabled) {
                    this.breakpointAdded(breakpoints[i]);
                } else {
                    this.breakpointRemoved(breakpoints[i], null);
                }
            }
            ++i;
        }
    }

    private void queueBpCmd(DBGpBreakpointCmd bpCmd) {
        if (bpCmd.getCmd().equals("breakpoint_remove")) {
            boolean foundAdd = false;
            if (this.DBGpCmdQueue.size() > 0) {
                int i = this.DBGpCmdQueue.size() - 1;
                while (i >= 0 && !foundAdd) {
                    DBGpBreakpointCmd entry = this.DBGpCmdQueue.get(i);
                    if (entry.getCmd().equals("breakpoint_set") && bpCmd.getBp().getFileName().equals(entry.getBp().getFileName()) && bpCmd.getBp().getLineNumber() == entry.getBp().getLineNumber()) {
                        foundAdd = true;
                        this.DBGpCmdQueue.remove(i);
                        if (DBGpLogger.debugBP()) {
                            DBGpLogger.debug("removed a breakpoint command: " + entry);
                        }
                    }
                    --i;
                }
            }
            if (!foundAdd) {
                this.DBGpCmdQueue.add(bpCmd);
            }
        } else {
            this.DBGpCmdQueue.add(bpCmd);
        }
    }

    private void processQueuedBpCmds() {
        if (DBGpLogger.debugBP()) {
            DBGpLogger.debug("processing deferred BP cmds");
        }
        int i = 0;
        while (i < this.DBGpCmdQueue.size()) {
            DBGpBreakpointCmd bpCmd = this.DBGpCmdQueue.get(i);
            if (bpCmd.getCmd().equals("breakpoint_set")) {
                this.sendBreakpointAddCmd(bpCmd.getBp(), true);
            } else if (bpCmd.getCmd().equals("breakpoint_remove")) {
                this.sendBreakpointRemoveCmd(bpCmd.getBp(), true);
            }
            ++i;
        }
        this.DBGpCmdQueue.clear();
    }

    public boolean SessionCreated(DBGpSession session) {
        boolean isMine = false;
        isMine = DBGpSessionHandler.getInstance().isCorrectSession(session, this);
        if (isMine) {
            if (this.session == null && !this.isTerminating()) {
                session.setDebugTarget(this);
                this.session = session;
                if (1 == this.targetState || this.targetState == 0) {
                    this.te.signalEvent();
                } else {
                    this.initiateSession();
                }
            } else {
                isMine = false;
            }
        }
        return isMine;
    }

    public String getIdeKey() {
        return this.ideKey;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public boolean isWebLaunch() {
        return this.webLaunch;
    }

    public String getSessionEncoding() {
        if (this.session != null) {
            return this.session.getSessionEncoding();
        }
        return "ISO-8859-1";
    }

    public String getBinaryEncoding() {
        if (this.session != null) {
            return this.session.getBinaryEncoding();
        }
        return DBGpSession.DEFAULT_BINARY_ENCODING;
    }

    private int getMaxDepth() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("MaxDepth", 3);
        }
        return 3;
    }

    public int getMaxChildren() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("MaxChildren", 31);
        }
        return 31;
    }

    private int getCaptureStdout() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("CaptureStdout", 0);
        }
        return 0;
    }

    private int getCaptureStderr() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getInt("CaptureStderr", 0);
        }
        return 0;
    }

    private boolean showGLobals() {
        if (this.sessionPreferences != null) {
            return this.sessionPreferences.getBoolean("ShowGlobals", true);
        }
        return true;
    }

    public void setPathMapper(PathMapper pathMapper) {
        this.pathMapper = pathMapper;
    }

    public boolean isRunning() {
        boolean isRunning = 3 == this.targetState;
        return isRunning;
    }

    public boolean isMultiSessionManaged() {
        return this.multiSessionManaged;
    }

    public void setMultiSessionManaged(boolean multiSessionManaged) {
        this.multiSessionManaged = multiSessionManaged;
    }

    public DBGpSession getSession() {
        return this.session;
    }

    public void setSession(DBGpSession session) {
        this.session = session;
    }

    public DebugOutput getOutputBuffer() {
        return this.debugOutput;
    }

    private byte[] getSessionEncodingBytes(String toConvert) {
        byte[] result = null;
        try {
            result = toConvert.getBytes(this.getSessionEncoding());
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("unexpected encoding problem", this, e);
        }
        return result;
    }

    public boolean isWaiting() {
        boolean isWaiting = 4 == this.targetState;
        return isWaiting;
    }

    private static class DBGpBreakpointCmd {
        private String cmd;
        private DBGpBreakpoint bp;

        public DBGpBreakpointCmd(String cmd, DBGpBreakpoint bp) {
            this.cmd = cmd;
            this.bp = bp;
        }

        public String getCmd() {
            return this.cmd;
        }

        public DBGpBreakpoint getBp() {
            return this.bp;
        }
    }

    private static class DBGpBreakpointCondition {
        private String hitCondition;
        private String hitValue;
        private String expression;
        private int type = 0;
        public static final int NONE = 0;
        public static final int HIT = 1;
        public static final int EXPR = 2;
        public static final int INVALID = 3;

        public DBGpBreakpointCondition(DBGpBreakpoint bp) {
            if (bp.isConditional() && bp.isConditionEnabled()) {
                String bpExpression = bp.getExpression().trim();
                if (bpExpression.endsWith(")") && (bpExpression.startsWith("hit(") || bpExpression.startsWith("HIT("))) {
                    if (bpExpression.length() > 5) {
                        this.type = 1;
                        String internal = bpExpression.substring(4, bpExpression.length() - 1).trim();
                        if (internal.startsWith("%")) {
                            this.hitCondition = "%";
                            this.hitValue = internal.substring(1).trim();
                        } else {
                            this.hitCondition = internal.substring(0, 2);
                            if (this.hitCondition.equals("==") || this.hitCondition.equals(">=")) {
                                this.hitValue = internal.substring(2).trim();
                            } else {
                                this.type = 3;
                            }
                        }
                        if (this.type != 3) {
                            try {
                                Integer.parseInt(this.hitValue);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.type = 3;
                            }
                        }
                    } else {
                        this.type = 3;
                    }
                } else if (bpExpression.length() == 0) {
                    this.type = 0;
                    this.expression = bpExpression;
                } else {
                    this.type = 2;
                    this.expression = bpExpression;
                }
            }
        }

        public String getExpression() {
            return this.expression;
        }

        public String getHitCondition() {
            return this.hitCondition;
        }

        public String getHitValue() {
            return this.hitValue;
        }

        public int getType() {
            return this.type;
        }
    }
}

