/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.communication;

import com.ibm.icu.text.MessageFormat;
import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceLookupDirector;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.util.PerspectiveManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class XDebugCommunicationDaemon
extends AbstractDebuggerCommunicationDaemon {
    public static final String XDEBUG_DEBUGGER_ID = "org.eclipse.php.debug.core.xdebugDebugger";
    private PortChangeListener portChangeListener;

    public void init() {
        this.initDeamonChangeListener();
        super.init();
    }

    protected void initDeamonChangeListener() {
        if (this.portChangeListener == null) {
            Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
            this.portChangeListener = new PortChangeListener();
            preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.portChangeListener);
        }
    }

    public int getReceiverPort() {
        return PHPDebugPlugin.getDebugPort(XDEBUG_DEBUGGER_ID);
    }

    public String getDebuggerID() {
        return XDEBUG_DEBUGGER_ID;
    }

    public boolean isDebuggerDaemon() {
        return true;
    }

    protected void startConnectionThread(Socket socket) {
        if (DBGpLogger.debugSession()) {
            DBGpLogger.debug("Connection established: " + socket.toString());
        }
        try {
            DBGpSession session = new DBGpSession(socket);
            if (session.isActive() && !DBGpSessionHandler.getInstance().fireSessionAdded(session)) {
                XDebugPreferenceMgr.AcceptRemoteSession aSess = XDebugPreferenceMgr.getAcceptRemoteSession();
                if (aSess != XDebugPreferenceMgr.AcceptRemoteSession.off) {
                    if (aSess == XDebugPreferenceMgr.AcceptRemoteSession.localhost && !session.getRemoteAddress().isLoopbackAddress()) {
                        session.endSession();
                    } else if (aSess == XDebugPreferenceMgr.AcceptRemoteSession.prompt) {
                        PromptUser prompt = new PromptUser(session);
                        Display.getDefault().syncExec((Runnable)prompt);
                        if (prompt.isResult()) {
                            this.createLaunch(session);
                        } else {
                            session.endSession();
                        }
                    } else {
                        this.createLaunch(session);
                    }
                } else {
                    session.endSession();
                }
            }
        }
        catch (Exception e) {
            DBGpLogger.logException("Unexpected Exception: Listener thread still listening", this, e);
        }
    }

    private void createLaunch(DBGpSession session) throws CoreException {
        boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(null);
        DBGpTarget target = null;
        PathMapper mapper = null;
        PHPSourceLookupDirector srcLocator = new PHPSourceLookupDirector();
        srcLocator.setSourcePathComputer(DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer("org.eclipse.php.debug.core.sourcePathComputer.php"));
        ILaunchConfigurationType type = null;
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        type = session.getSessionId() == null ? lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.webPageLaunch") : lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy launchConfig = type.newInstance(null, PHPDebugCoreMessages.XDebugMessage_remoteSessionTitle);
        srcLocator.initializeDefaults((ILaunchConfiguration)launchConfig);
        srcLocator.initializeParticipants();
        Launch remoteLaunch = new Launch((ILaunchConfiguration)launchConfig, "debug", (ISourceLocator)srcLocator);
        boolean multiSession = XDebugPreferenceMgr.useMultiSession();
        if (session.getSessionId() == null && !multiSession) {
            target = new DBGpTarget((ILaunch)remoteLaunch, null, null, session.getIdeKey(), stopAtFirstLine, null);
            Server server = null;
            Server[] servers = ServersManager.getServers();
            int i = 0;
            while (i < servers.length) {
                if (servers[i].getPort() == session.getRemotePort() && servers[i].getHost().equalsIgnoreCase(session.getRemoteHostname())) {
                    server = servers[i];
                    break;
                }
                ++i;
            }
            if (server != null) {
                mapper = PathMapperRegistry.getByServer(server);
            }
            if (mapper == null) {
                mapper = new PathMapper();
            }
            DBGpSessionHandler.getInstance().addSessionListener(target);
        } else {
            target = new DBGpTarget((ILaunch)remoteLaunch, null, session.getIdeKey(), session.getSessionId(), stopAtFirstLine);
            mapper = new PathMapper();
        }
        target.setPathMapper(mapper);
        target.setSession(session);
        session.setDebugTarget(target);
        if (multiSession && session.getSessionId() == null) {
            DBGpMultiSessionTarget multiSessionTarget = new DBGpMultiSessionTarget((ILaunch)remoteLaunch, null, null, session.getIdeKey(), stopAtFirstLine, null);
            DBGpSessionHandler.getInstance().addSessionListener(multiSessionTarget);
            remoteLaunch.addDebugTarget((IDebugTarget)multiSessionTarget);
            multiSessionTarget.sessionReceived((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), target, mapper);
        } else {
            remoteLaunch.addDebugTarget((IDebugTarget)target);
            target.sessionReceived((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences());
        }
        DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)remoteLaunch);
        if (!target.isTerminated() && !target.isTerminating()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (!PerspectiveManager.isCurrentPerspective((IWorkbenchWindow)window, (String)"org.eclipse.debug.ui.DebugPerspective") && PerspectiveManager.shouldSwitchPerspective((IWorkbenchWindow)window, (String)"org.eclipse.debug.ui.DebugPerspective")) {
                        PerspectiveManager.switchToPerspective((IWorkbenchWindow)window, (String)"org.eclipse.debug.ui.DebugPerspective");
                    }
                }
            });
        }
    }

    private class PortChangeListener
    implements Preferences.IPropertyChangeListener {
        private PortChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.php.debug.core.xdebug_port")) {
                XDebugCommunicationDaemon.this.resetSocket();
            }
        }
    }

    private class PromptUser
    implements Runnable {
        private DBGpSession session;
        private boolean result;

        public boolean isResult() {
            return this.result;
        }

        public PromptUser(DBGpSession session) {
            this.session = session;
        }

        public void run() {
            String insert = String.valueOf(this.session.getRemoteAddress().getCanonicalHostName()) + "/" + this.session.getRemoteAddress().getHostAddress();
            String message = MessageFormat.format((String)PHPDebugCoreMessages.XDebugMessage_remoteSessionPrompt, (Object[])new Object[]{insert});
            this.result = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_remoteSessionTitle, (String)message);
        }
    }
}

