/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.dltk.core.IArchiveEntry;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.util.HandleFactory;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.phar.PharArchiveFile;
import org.eclipse.php.internal.core.phar.PharPath;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;

public class PHPSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public String getSourceName(Object object) throws CoreException {
        if (object instanceof PHPStackFrame) {
            return ((PHPStackFrame)((Object)object)).getSourceName();
        }
        if (object instanceof DBGpStackFrame) {
            String src = ((DBGpStackFrame)((Object)object)).getSourceName();
            if (src == null) {
                src = ((DBGpStackFrame)((Object)object)).getQualifiedFile();
                Path p = new Path(src);
                src = p.lastSegment();
            }
            return src;
        }
        return null;
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        Object[] sourceElements = EMPTY;
        try {
            sourceElements = super.findSourceElements(object);
        }
        catch (Throwable throwable) {}
        if (sourceElements == EMPTY) {
            String fileName = null;
            if (object instanceof PHPStackFrame) {
                fileName = ((PHPStackFrame)((Object)object)).getSourceName();
            } else if (object instanceof DBGpStackFrame) {
                fileName = ((DBGpStackFrame)((Object)object)).getQualifiedFile();
            }
            if (fileName != null) {
                HandleFactory fac = new HandleFactory();
                IDLTKSearchScope scope = DLTKSearchScopeFactory.getInstance().createWorkspaceScope(true, PHPLanguageToolkit.getDefault());
                IPath localPath = EnvironmentPathUtils.getFile((IEnvironment)LocalEnvironment.getInstance(), (IPath)new Path(fileName)).getFullPath();
                Openable openable = fac.createOpenable(localPath.toString(), scope);
                if (openable instanceof IStorage) {
                    return new Object[]{openable};
                }
                File file = new File(fileName);
                if (file.exists()) {
                    return new Object[]{new LocalFile(file)};
                }
                PharPath pharPath = PharPath.getPharPath((IPath)new Path(fileName));
                if (pharPath != null) {
                    try {
                        PharArchiveFile archiveFile = new PharArchiveFile(pharPath.getPharName());
                        IArchiveEntry entry = archiveFile.getArchiveEntry(String.valueOf(pharPath.getFolder().length() == 0 ? "" : String.valueOf(pharPath.getFolder()) + "/") + pharPath.getFile());
                        return new Object[]{new ExternalEntryFile(fileName, archiveFile, entry)};
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return EMPTY;
            }
        }
        return sourceElements;
    }

    private static final class ExternalEntryFile
    extends PlatformObject
    implements IStorage {
        private String fileName;
        private IArchiveEntry entry;
        private PharArchiveFile archiveFile;

        public ExternalEntryFile(String fileName, PharArchiveFile archiveFile, IArchiveEntry entry) {
            this.fileName = fileName;
            this.entry = entry;
            this.archiveFile = archiveFile;
        }

        public InputStream getContents() throws CoreException {
            try {
                return this.archiveFile.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new ModelException((Throwable)e, 985);
            }
        }

        public IPath getFullPath() {
            return new Path(this.fileName);
        }

        public String getName() {
            return this.entry.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public String toString() {
            return "ExternalEntryFile[" + this.fileName + "]";
        }
    }
}

