/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.util.XMLWriter;

public class MapXMLWriter
extends XMLWriter {
    public static final String MAP_TAG = "map";
    public static final String KEY_TAG = "key";
    public static final String VALUE_TAG = "value";
    public static final String NAME_TAG = "name";

    public MapXMLWriter(OutputStream output) throws UnsupportedEncodingException {
        super(output);
    }

    public void writeMap(Map map) {
        HashMap<String, String> tagsMap = new HashMap<String, String>();
        Iterator keys = map.keySet().iterator();
        this.startTag(MAP_TAG, null);
        while (keys.hasNext()) {
            Object key = keys.next();
            Object values = map.get(key);
            tagsMap.put(NAME_TAG, key.toString());
            this.startTag(KEY_TAG, tagsMap);
            if (key != null) {
                if (values instanceof List) {
                    Iterator valuesIter = ((List)values).iterator();
                    while (valuesIter.hasNext()) {
                        this.printSimpleTag(VALUE_TAG, valuesIter.next());
                    }
                } else if (values != null) {
                    this.printSimpleTag(VALUE_TAG, values.toString());
                }
            }
            this.endTag(KEY_TAG);
        }
        this.endTag(MAP_TAG);
        this.flush();
    }
}

