/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineMethodUtils {
    public static String DEFINE = "define";

    public static PHPCallExpression getDefineNodeByField(ModuleDeclaration module, IField field) throws ModelException {
        FunctionInvocationSearcher visitor;
        block2: {
            visitor = new FunctionInvocationSearcher(module, (IMember)field);
            try {
                module.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                Logger.logException(e);
            }
        }
        return visitor.getResult();
    }

    public static PHPDocBlock getDefinePHPDocBlockByField(ModuleDeclaration module, IField field) throws ModelException {
        if (module instanceof PHPModuleDeclaration) {
            if (DefineMethodUtils.getDefineNodeByField(module, field) == null) {
                return null;
            }
            PHPModuleDeclaration phpModule = (PHPModuleDeclaration)module;
            List<PHPDocBlock> phpDocBlocks = phpModule.getPhpDocBlocks();
            if (phpDocBlocks != null && !phpDocBlocks.isEmpty()) {
                List statements = phpModule.getStatements();
                ISourceRange sourceRange = field.getNameRange();
                ASTNode previousStatement = null;
                for (ASTNode statement : statements) {
                    if (statement.sourceStart() <= sourceRange.getOffset() && statement.sourceEnd() >= sourceRange.getOffset() + sourceRange.getLength()) {
                        if ((phpDocBlocks = DefineMethodUtils.getPHPDocBlockBetweenStatements(previousStatement, statement, phpDocBlocks)).isEmpty()) {
                            return null;
                        }
                        Collections.sort(phpDocBlocks, new Comparator<PHPDocBlock>(){

                            @Override
                            public int compare(PHPDocBlock o1, PHPDocBlock o2) {
                                return o1.sourceStart() - o2.sourceStart();
                            }
                        });
                        return phpDocBlocks.get(phpDocBlocks.size() - 1);
                    }
                    previousStatement = statement;
                }
                PHPCallExpression callExpression = DefineMethodUtils.getDefineNodeByField(phpModule, field);
                callExpression.getReceiver();
            }
        }
        return null;
    }

    private static List<PHPDocBlock> getPHPDocBlockBetweenStatements(ASTNode previousStatement, ASTNode statement, List<PHPDocBlock> phpDocBlocks) {
        if (previousStatement == null) {
            return DefineMethodUtils.getPHPDocBlockBetweenRange(-1, statement.sourceStart(), phpDocBlocks);
        }
        return DefineMethodUtils.getPHPDocBlockBetweenRange(previousStatement.sourceEnd(), statement.sourceStart(), phpDocBlocks);
    }

    private static List<PHPDocBlock> getPHPDocBlockBetweenRange(int start, int end, List<PHPDocBlock> phpDocBlocks) {
        ArrayList<PHPDocBlock> result = new ArrayList<PHPDocBlock>();
        for (PHPDocBlock phpDocBlock : phpDocBlocks) {
            if (phpDocBlock.sourceStart() < start || phpDocBlock.sourceEnd() > end) continue;
            result.add(phpDocBlock);
        }
        return result;
    }

    public static class FunctionInvocationSearcher
    extends ASTVisitor {
        private int bestScore = Integer.MAX_VALUE;
        private int modelStart;
        private int modelEnd;
        private int modelCutoffStart;
        private int modelCutoffEnd;
        private String elementName;
        private PHPCallExpression result;

        public FunctionInvocationSearcher(ModuleDeclaration moduleDeclaration, IMember modelElement) throws ModelException {
            ISourceRange sourceRange = modelElement.getSourceRange();
            this.modelStart = sourceRange.getOffset();
            this.modelEnd = this.modelStart + sourceRange.getLength();
            this.modelCutoffStart = this.modelStart - 100;
            this.modelCutoffEnd = this.modelEnd + 100;
            this.elementName = modelElement.getElementName();
        }

        public PHPCallExpression getResult() {
            return this.result;
        }

        protected void checkElementDeclaration(PHPCallExpression s) {
            int astEnd;
            int diff2;
            int astStart;
            int diff1;
            int score;
            String constant;
            ASTNode argument;
            CallArgumentsList args;
            if (s.getName().equals(DEFINE) && (args = s.getArgs()) != null && args.getChilds() != null && (argument = (ASTNode)args.getChilds().get(0)) instanceof Scalar && (constant = ASTUtils.stripQuotes(((Scalar)argument).getValue())).equals(this.elementName) && (score = (diff1 = this.modelStart - (astStart = s.sourceStart())) * diff1 + (diff2 = this.modelEnd - (astEnd = s.sourceEnd())) * diff2) < this.bestScore) {
                this.bestScore = score;
                this.result = s;
            }
        }

        protected boolean interesting(ASTNode s) {
            if (s.sourceStart() < 0 || s.sourceEnd() < s.sourceStart()) {
                return true;
            }
            return this.modelCutoffEnd >= s.sourceStart() && this.modelCutoffStart < s.sourceEnd();
        }

        public boolean visit(Expression s) throws Exception {
            return this.interesting((ASTNode)s);
        }

        public boolean visit(Statement s) throws Exception {
            if (!this.interesting((ASTNode)s)) {
                return false;
            }
            if (s instanceof ExpressionStatement && ((ExpressionStatement)s).getExpr() instanceof PHPCallExpression) {
                this.checkElementDeclaration((PHPCallExpression)((ExpressionStatement)s).getExpr());
            }
            return true;
        }

        public boolean visit(ModuleDeclaration s) throws Exception {
            return this.interesting((ASTNode)s);
        }

        public boolean visitGeneral(ASTNode s) throws Exception {
            return this.interesting(s);
        }
    }
}

