/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.File;
import java.io.IOException;
import org.eclipse.php.internal.core.phar.PharEntry;
import org.eclipse.php.internal.core.phar.PharEntryBufferedRandomInputStream;

public class GZPharEntryBufferedRandomInputStream
extends PharEntryBufferedRandomInputStream {
    byte[] header;
    byte[] tailer;
    protected int headerIndex;
    protected int tailerIndex;

    public GZPharEntryBufferedRandomInputStream(File file, PharEntry pharEntry) throws IOException {
        super(file, pharEntry);
        byte[] byArray = new byte[10];
        byArray[0] = 31;
        byArray[1] = -117;
        byArray[2] = 8;
        this.header = byArray;
        this.tailer = GZPharEntryBufferedRandomInputStream.comcat(pharEntry.getCrcByte(), pharEntry.getSizeByte());
        this.headerIndex = 0;
        this.tailerIndex = 0;
    }

    private static byte[] comcat(byte[] bs, byte[] content) {
        byte[] tmp = new byte[bs.length + content.length];
        System.arraycopy(bs, 0, tmp, 0, bs.length);
        System.arraycopy(content, 0, tmp, bs.length, content.length);
        return tmp;
    }

    public int read() throws IOException {
        if (this.headerIndex < this.header.length) {
            return (this.header[this.headerIndex++] + 256) % 256;
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int j;
        int result = 0;
        if (this.headerIndex < this.header.length) {
            j = 0;
            while (this.headerIndex < this.header.length && j < len) {
                b[off + j] = (byte)((this.header[this.headerIndex] + 256) % 256);
                ++this.headerIndex;
                ++j;
            }
            if (j < len) {
                result = super.read(b, off + j, len - j);
                result = j + result;
            } else {
                result = j;
            }
        } else {
            result = super.read(b, off, len);
        }
        if (result < len && this.tailerIndex < this.tailer.length) {
            j = 0;
            while (this.tailerIndex < this.tailer.length && result + j < len) {
                b[result + j] = (byte)((this.tailer[this.tailerIndex] + 256) % 256);
                ++this.tailerIndex;
                ++j;
            }
            result = j + result;
        }
        return result;
    }
}

