/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class CurlyCloseIndentationStrategy
implements IIndentationStrategy {
    public void placeMatchingBlanks(IStructuredDocument document, StringBuffer result, int lineNumber, int forOffset) throws BadLocationException {
        IRegion curlyOpenLine = this.getCurlyOpenLineInformation(document, forOffset);
        if (curlyOpenLine == null) {
            return;
        }
        int indentationBaseLineIndex = DefaultIndentationStrategy.getIndentationBaseLine(document, document.getLineOfOffset(curlyOpenLine.getOffset()), forOffset, true);
        IRegion indentationBaseLine = document.getLineInformation(indentationBaseLineIndex);
        String blanks = "";
        blanks = indentationBaseLine != null ? FormatterUtils.getLineBlanks((IDocument)document, indentationBaseLine) : FormatterUtils.getLineBlanks((IDocument)document, document.getLineInformationOfOffset(forOffset));
        result.append(blanks);
    }

    protected IRegion getCurlyOpenLineInformation(IStructuredDocument document, int forOffset) throws BadLocationException {
        int offset = forOffset;
        int curlyCount = 0;
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        if (sdRegion == null) {
            return null;
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        block0: do {
            if (tRegion instanceof IPhpScriptRegion) {
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                tRegion = scriptRegion.getPhpToken(offset - regionStart - 1);
                while (tRegion != null) {
                    String token = tRegion.getType();
                    if (token == "PHP_CURLY_OPEN") {
                        if (--curlyCount < 0) {
                            return document.getLineInformationOfOffset(tRegion.getStart() + regionStart);
                        }
                    } else if (token == "PHP_CURLY_CLOSE") {
                        ++curlyCount;
                    }
                    if (tRegion.getStart() <= 0) break;
                    tRegion = scriptRegion.getPhpToken(tRegion.getStart() - 1);
                }
            }
            tRegion = null;
            while ((sdRegion = sdRegion.getPrevious()) != null) {
                if (!sdRegion.getFirstRegion().getType().equals("PHP_OPEN")) continue;
                tRegion = sdRegion.getRegions().get(1);
                regionStart = sdRegion.getStartOffset(tRegion);
                offset = sdRegion.getEndOffset(tRegion);
                continue block0;
            }
        } while (tRegion != null);
        return null;
    }
}

