/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.IRecoverable;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclaration
extends TypeDeclaration
implements IPHPDocAwareDeclaration,
IRecoverable {
    private PHPDocBlock phpDoc;
    private TypeReference superClass;
    private List<TypeReference> interfaceList;
    private boolean isRecovered;

    public ClassDeclaration(int start, int end, int nameStart, int nameEnd, int modifier, String className, TypeReference superClass, List<TypeReference> interfaces, Block body, PHPDocBlock phpDoc) {
        super(className, nameStart, nameEnd, start, end);
        this.setModifiers(modifier);
        this.phpDoc = phpDoc;
        this.superClass = superClass;
        this.interfaceList = interfaces;
        this.setBody(body);
    }

    public TypeReference getSuperClass() {
        return this.superClass;
    }

    public String getSuperClassName() {
        if (this.superClass != null) {
            return this.superClass.getName();
        }
        return null;
    }

    public Collection<TypeReference> getInterfaceList() {
        return this.interfaceList;
    }

    public String[] getInterfaceNames() {
        if (this.interfaceList != null) {
            String[] names = new String[this.interfaceList.size()];
            int i = 0;
            for (TypeReference iface : this.interfaceList) {
                names[i++] = iface.getName();
            }
            return names;
        }
        return null;
    }

    public void setSuperClass(TypeReference superClass) {
        this.superClass = superClass;
    }

    public void addInterface(TypeReference iface) {
        if (this.interfaceList == null) {
            this.interfaceList = new LinkedList<TypeReference>();
        }
        this.interfaceList.add(iface);
    }

    public void setInterfaceList(List<TypeReference> interfaceList) {
        this.interfaceList = interfaceList;
    }

    public ASTListNode getSuperClasses() {
        int start = this.getBodyStart() - 1;
        ASTListNode listNode = new ASTListNode(start, start);
        if (this.superClass != null) {
            listNode.addNode((ASTNode)this.superClass);
            if (this.superClass.sourceStart() < start) {
                start = this.superClass.sourceStart();
            }
        }
        if (this.interfaceList != null) {
            for (TypeReference iface : this.interfaceList) {
                listNode.addNode((ASTNode)iface);
                if (iface.sourceStart() >= start) continue;
                start = iface.sourceStart();
            }
        }
        listNode.setStart(start);
        return listNode;
    }

    public List<String> getSuperClassNames() {
        LinkedList<String> names = new LinkedList<String>();
        if (this.superClass != null) {
            names.add(this.superClass.getName());
        }
        if (this.interfaceList != null) {
            for (TypeReference iface : this.interfaceList) {
                names.add(iface.getName());
            }
        }
        return names;
    }

    public final void addSuperClass(ASTNode expression) {
        throw new IllegalStateException("Use setSuperClass() or setInterfaceList()/addInterface() instead");
    }

    public final void setSuperClasses(ASTListNode exprList) {
        throw new IllegalStateException("Use setSuperClass() or setInterfaceList()/addInterface() instead");
    }

    @Override
    public PHPDocBlock getPHPDoc() {
        return this.phpDoc;
    }

    public int getKind() {
        return 12;
    }

    @Override
    public boolean isRecovered() {
        return this.isRecovered;
    }

    @Override
    public void setRecovered(boolean isRecovered) {
        this.isRecovered = isRecovered;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

