/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.model.PhpModelAccess;

public class GlobalFunctionsStrategy
extends GlobalElementStrategy {
    public GlobalFunctionsStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        if (abstractContext.getPrefixWithoutProcessing().trim().length() == 0) {
            return;
        }
        String prefix = abstractContext.getPrefix();
        if (prefix.startsWith("$")) {
            return;
        }
        ISearchEngine.MatchRule matchRule = ISearchEngine.MatchRule.PREFIX;
        if (requestor.isContextInformationMode()) {
            matchRule = ISearchEngine.MatchRule.EXACT;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        IMethod[] functions = PhpModelAccess.getDefault().findMethods(prefix, matchRule, 8192, 0, scope, null);
        SourceRange replacementRange = this.getReplacementRange(abstractContext);
        String suffix = this.getSuffix(abstractContext);
        IMethod[] iMethodArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            reporter.reportMethod(method, suffix, replacementRange);
            ++n2;
        }
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "(".equals(nextWord) ? "" : "()";
    }
}

