/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.codeassist.contexts.NamespacePHPDocContext;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamespacePHPDocTagContext
extends NamespacePHPDocContext {
    private String tagName;
    private Pattern[] todos;

    public void setPatterns(IProject project) {
        this.todos = project != null ? TaskPatternsProvider.getInstance().getPatternsForProject(project) : TaskPatternsProvider.getInstance().getPetternsForWorkspace();
    }

    private ArrayList<Matcher> createMatcherList(String content) {
        ArrayList<Matcher> list = new ArrayList<Matcher>(this.todos.length);
        int i = 0;
        while (i < this.todos.length) {
            list.add(i, this.todos[i].matcher(content));
            ++i;
        }
        return list;
    }

    private Matcher getMinimalMatcher(ArrayList<Matcher> matchers, int startPosition) {
        Matcher minimal = null;
        int size = matchers.size();
        int i = 0;
        while (i < size) {
            Matcher tmp = matchers.get(i);
            if (tmp.find(startPosition)) {
                if (minimal == null || tmp.start() < minimal.start()) {
                    minimal = tmp;
                }
                ++i;
                continue;
            }
            matchers.remove(i);
            --size;
        }
        return minimal;
    }

    private boolean isPHPTag(String tagName) {
        ArrayList<Matcher> matchers = this.createMatcherList(tagName);
        Matcher matcher = this.getMinimalMatcher(matchers, 0);
        return matcher != null;
    }

    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        int tagStart;
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        this.setPatterns(sourceModule.getScriptProject().getProject());
        TextSequence statementText = this.getStatementText();
        int tagEnd = statementText.length();
        boolean found = false;
        do {
            tagEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, tagEnd);
            tagStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.getPhpVersion(), this.getStatementText(), tagEnd, true);
            this.tagName = statementText.subSequence(tagStart, tagEnd).toString();
            if (tagStart > 0 && statementText.charAt(tagStart - 1) == '@') {
                found = true;
            } else if (this.isPHPTag(this.tagName)) {
                found = true;
            }
            tagEnd = tagStart - 1;
        } while (!found && tagStart > 0);
        return found;
    }

    public String getTagName() {
        return this.tagName;
    }
}

