/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance.ast.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.core.tests.performance.Util;
import org.eclipse.php.internal.core.PHPVersion;
import org.osgi.framework.Bundle;

public class ProgramParserWrapper
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private IFile testFile;
    private IProject project;
    private PerformanceMonitor perfMonitor;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/project/programparser/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/project/programparser/php53"});
    }

    public ProgramParserWrapper() {
        super("");
    }

    public Test suite(Map map) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(map.get("project").toString());
        this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
        TestSuite suite = new TestSuite("Auto Program Parser Tests");
        final PHPVersion phpVersion = (PHPVersion)map.get("phpVersion");
        String[] stringArray = TESTS.get(phpVersion);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            testsDirectory = testsDirectory.replaceAll("project", map.get("project").toString());
            String[] stringArray2 = ProgramParserWrapper.getPDTTFiles((String)testsDirectory, (Bundle)PHPCorePerformanceTests.getDefault().getBundle());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                final String fileName = stringArray2[n4];
                try {
                    final PdttFile pdttFile = new PdttFile(PHPCorePerformanceTests.getDefault().getBundle(), fileName);
                    ProgramParser test = new ProgramParser(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                        protected void setUp() throws Exception {
                            PHPCoreTests.setProjectPhpVersion((IProject)ProgramParserWrapper.this.project, (PHPVersion)phpVersion);
                            pdttFile.applyPreferences();
                        }

                        protected void tearDown() throws Exception {
                            if (ProgramParserWrapper.this.testFile != null) {
                                ProgramParserWrapper.this.testFile.delete(true, null);
                                ProgramParserWrapper.this.testFile = null;
                            }
                        }

                        protected void runTest() throws Throwable {
                            ProgramParserWrapper.this.executeParser(pdttFile.getFile(), fileName);
                        }
                    };
                    suite.addTest((Test)test);
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        return suite;
    }

    protected void executeParser(String data, String fileName) throws Exception {
        this.testFile = this.project.getFile("pdttest/test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.project.refreshLocal(1, null);
        this.project.build(10, null);
        PHPCoreTests.waitForIndexer();
        this.perfMonitor.execute("PerformanceTests.testProgramParser_" + fileName, new PerformanceMonitor.Operation(){

            public void run() throws Exception {
                Util.createProgramFromSource(ProgramParserWrapper.this.testFile);
            }
        }, 1, 10);
    }

    public class ProgramParser
    extends AbstractPDTTTest {
        public ProgramParser(String description) {
            super(description);
        }
    }
}

